/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.partition.util;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionGraph;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionVertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PartitionVertexSequence
implements CloseableSequence<Vertex> {
    private final Iterator<Vertex> itty;
    private final PartitionGraph graph;
    private PartitionVertex nextVertex;

    public PartitionVertexSequence(Iterator<Vertex> itty, PartitionGraph graph) {
        this.itty = itty;
        this.graph = graph;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (null != this.nextVertex) {
            return true;
        }
        while (this.itty.hasNext()) {
            Vertex vertex = this.itty.next();
            if (!this.graph.isInPartition(vertex)) continue;
            this.nextVertex = new PartitionVertex(vertex, this.graph);
            return true;
        }
        return false;
    }

    @Override
    public Vertex next() {
        if (null != this.nextVertex) {
            PartitionVertex temp = this.nextVertex;
            this.nextVertex = null;
            return temp;
        }
        while (this.itty.hasNext()) {
            Vertex vertex = this.itty.next();
            if (!this.graph.isInPartition(vertex)) continue;
            return new PartitionVertex(vertex, this.graph);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<Vertex> iterator() {
        return this;
    }

    @Override
    public void close() {
        if (this.itty instanceof CloseableSequence) {
            ((CloseableSequence)this.itty).close();
        }
    }
}

