/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.io.graphml;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GraphMLReader {
    private final Graph graph;
    private String vertexIdKey = null;
    private String edgeIdKey = null;
    private String edgeLabelKey = null;

    public GraphMLReader(Graph graph) {
        this.graph = graph;
    }

    public void setVertexIdKey(String vertexIdKey) {
        this.vertexIdKey = vertexIdKey;
    }

    public void setEdgeIdKey(String edgeIdKey) {
        this.edgeIdKey = edgeIdKey;
    }

    public void setEdgeLabelKey(String edgeLabelKey) {
        this.edgeLabelKey = edgeLabelKey;
    }

    public void inputGraph(InputStream graphMLInputStream) throws IOException {
        GraphMLReader.inputGraph(this.graph, graphMLInputStream, 1000, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public void inputGraph(InputStream graphMLInputStream, int bufferSize) throws IOException {
        GraphMLReader.inputGraph(this.graph, graphMLInputStream, bufferSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public static void inputGraph(Graph graph, InputStream graphMLInputStream) throws IOException {
        GraphMLReader.inputGraph(graph, graphMLInputStream, 1000, null, null, null);
    }

    public static void inputGraph(Graph graph, InputStream graphMLInputStream, int bufferSize, String vertexIdKey, String edgeIdKey, String edgeLabelKey) throws IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(graphMLInputStream);
            int previousMaxBufferSize = 0;
            if (graph instanceof TransactionalGraph) {
                previousMaxBufferSize = ((TransactionalGraph)graph).getMaxBufferSize();
                ((TransactionalGraph)graph).setMaxBufferSize(bufferSize);
            }
            HashMap<String, String> keyIdMap = new HashMap<String, String>();
            HashMap<String, String> keyTypesMaps = new HashMap<String, String>();
            HashMap<String, Object> vertexIdMap = new HashMap<String, Object>();
            HashMap<String, String> vertexMappedIdMap = new HashMap<String, String>();
            String vertexId = null;
            HashMap<String, Object> vertexProps = null;
            boolean inVertex = false;
            String edgeId = null;
            String edgeLabel = null;
            Vertex edgeInVertex = null;
            Vertex edgeOutVertex = null;
            HashMap<String, Object> edgeProps = null;
            boolean inEdge = false;
            while (reader.hasNext()) {
                String elementName;
                Integer eventType = reader.next();
                if (eventType.equals(1)) {
                    String key;
                    String attributeName;
                    elementName = reader.getName().getLocalPart();
                    if (elementName.equals("key")) {
                        String id = reader.getAttributeValue(null, "id");
                        attributeName = reader.getAttributeValue(null, "attr.name");
                        String attributeType = reader.getAttributeValue(null, "attr.type");
                        keyIdMap.put(id, attributeName);
                        keyTypesMaps.put(attributeName, attributeType);
                        continue;
                    }
                    if (elementName.equals("node")) {
                        vertexId = reader.getAttributeValue(null, "id");
                        if (vertexIdKey != null) {
                            vertexMappedIdMap.put(vertexId, vertexId);
                        }
                        inVertex = true;
                        vertexProps = new HashMap<String, Object>();
                        continue;
                    }
                    if (elementName.equals("edge")) {
                        edgeId = reader.getAttributeValue(null, "id");
                        edgeLabel = reader.getAttributeValue(null, "label");
                        edgeLabel = edgeLabel == null ? "_default" : edgeLabel;
                        String outVertexId = reader.getAttributeValue(null, "source");
                        String inVertexId = reader.getAttributeValue(null, "target");
                        Object outObjectId = null;
                        Object inObjectId = null;
                        if (vertexIdKey == null) {
                            outObjectId = vertexIdMap.get(outVertexId);
                            inObjectId = vertexIdMap.get(inVertexId);
                        } else {
                            outObjectId = vertexIdMap.get(vertexMappedIdMap.get(outVertexId));
                            inObjectId = vertexIdMap.get(vertexMappedIdMap.get(inVertexId));
                        }
                        edgeOutVertex = null;
                        if (null != outObjectId) {
                            edgeOutVertex = graph.getVertex(outObjectId);
                        }
                        edgeInVertex = null;
                        if (null != inObjectId) {
                            edgeInVertex = graph.getVertex(inObjectId);
                        }
                        if (null == edgeOutVertex) {
                            edgeOutVertex = graph.addVertex(outVertexId);
                            vertexIdMap.put(outVertexId, edgeOutVertex.getId());
                            if (vertexIdKey != null) {
                                vertexMappedIdMap.put(outVertexId, outVertexId);
                            }
                        }
                        if (null == edgeInVertex) {
                            edgeInVertex = graph.addVertex(inVertexId);
                            vertexIdMap.put(inVertexId, edgeInVertex.getId());
                            if (vertexIdKey != null) {
                                vertexMappedIdMap.put(inVertexId, inVertexId);
                            }
                        }
                        inEdge = true;
                        edgeProps = new HashMap<String, Object>();
                        continue;
                    }
                    if (!elementName.equals("data") || (attributeName = (String)keyIdMap.get(key = reader.getAttributeValue(null, "key"))) == null) continue;
                    String value = reader.getElementText();
                    if (inVertex) {
                        if (vertexIdKey != null && key.equals(vertexIdKey)) {
                            vertexMappedIdMap.put(vertexId, value);
                            vertexId = value;
                            continue;
                        }
                        vertexProps.put(attributeName, GraphMLReader.typeCastValue(key, value, keyTypesMaps));
                        continue;
                    }
                    if (!inEdge) continue;
                    if (edgeLabelKey != null && key.equals(edgeLabelKey)) {
                        edgeLabel = value;
                        continue;
                    }
                    if (edgeIdKey != null && key.equals(edgeIdKey)) {
                        edgeId = value;
                        continue;
                    }
                    edgeProps.put(attributeName, GraphMLReader.typeCastValue(key, value, keyTypesMaps));
                    continue;
                }
                if (!eventType.equals(2)) continue;
                elementName = reader.getName().getLocalPart();
                if (elementName.equals("node")) {
                    Vertex currentVertex;
                    Object vertexObjectId = vertexIdMap.get(vertexId);
                    if (vertexObjectId != null) {
                        currentVertex = graph.getVertex(vertexObjectId);
                    } else {
                        currentVertex = graph.addVertex(vertexId);
                        vertexIdMap.put(vertexId, currentVertex.getId());
                    }
                    for (Map.Entry prop : vertexProps.entrySet()) {
                        currentVertex.setProperty((String)prop.getKey(), prop.getValue());
                    }
                    vertexId = null;
                    vertexProps = null;
                    inVertex = false;
                    continue;
                }
                if (!elementName.equals("edge")) continue;
                Edge currentEdge = graph.addEdge(edgeId, edgeOutVertex, edgeInVertex, edgeLabel);
                for (Map.Entry prop : edgeProps.entrySet()) {
                    currentEdge.setProperty((String)prop.getKey(), prop.getValue());
                }
                edgeId = null;
                edgeLabel = null;
                edgeInVertex = null;
                edgeOutVertex = null;
                edgeProps = null;
                inEdge = false;
            }
            reader.close();
            if (graph instanceof TransactionalGraph) {
                ((TransactionalGraph)graph).setMaxBufferSize(previousMaxBufferSize);
            }
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private static Object typeCastValue(String key, String value, Map<String, String> keyTypes) {
        String type = keyTypes.get(key);
        if (null == type || type.equals("string")) {
            return value;
        }
        if (type.equals("float")) {
            return Float.valueOf(value);
        }
        if (type.equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.equals("double")) {
            return Double.valueOf(value);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.equals("long")) {
            return Long.valueOf(value);
        }
        return value;
    }
}

