/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.util.ElementHelper;

public class GraphHelper {
    public static Vertex addVertex(Graph graph, Object id, Object ... properties) {
        if (properties.length % 2 != 0) {
            throw new RuntimeException("There must be an equal number of keys and values");
        }
        Vertex vertex = graph.addVertex(id);
        for (int i = 0; i < properties.length; i += 2) {
            vertex.setProperty((String)properties[i], properties[i + 1]);
        }
        return vertex;
    }

    public static Edge addEdge(Graph graph, Object id, Vertex outVertex, Vertex inVertex, String label, Object ... properties) {
        if (properties.length % 2 != 0) {
            throw new RuntimeException("There must be an equal number of keys and values");
        }
        Edge edge = graph.addEdge(id, outVertex, inVertex, label);
        for (int i = 0; i < properties.length; i += 2) {
            edge.setProperty((String)properties[i], properties[i + 1]);
        }
        return edge;
    }

    public static void copyGraph(Graph from, Graph to) {
        for (Vertex fromVertex : from.getVertices()) {
            Vertex toVertex = to.addVertex(fromVertex.getId());
            ElementHelper.copyProperties(fromVertex, toVertex);
        }
        for (Edge fromEdge : from.getEdges()) {
            Vertex outVertex = to.getVertex(fromEdge.getOutVertex().getId());
            Vertex inVertex = to.getVertex(fromEdge.getInVertex().getId());
            Edge toEdge = to.addEdge(fromEdge.getId(), outVertex, inVertex, fromEdge.getLabel());
            ElementHelper.copyProperties(fromEdge, toEdge);
        }
    }
}

