/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class IndirectionPolicy
implements Cloneable,
Serializable {
    protected DatabaseMapping mapping;

    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        return this.mapping.buildBackupCloneForPartObject(attributeValue, clone, backup, unitOfWork);
    }

    protected ReadObjectQuery buildCascadeQuery(MergeManager mergeManager) {
        ReadObjectQuery cascadeQuery = new ReadObjectQuery();
        if (mergeManager.shouldCascadeAllParts()) {
            cascadeQuery.cascadeAllParts();
            cascadeQuery.refreshIdentityMapResult();
        }
        if (mergeManager.shouldCascadePrivateParts() && this.getForeignReferenceMapping().isPrivateOwned()) {
            cascadeQuery.cascadePrivateParts();
            cascadeQuery.refreshIdentityMapResult();
        }
        return cascadeQuery;
    }

    public abstract Object buildIndirectObject(ValueHolderInterface var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract Object cloneAttribute(Object var1, Object var2, CacheKey var3, Object var4, AbstractSession var5, boolean var6);

    public Object extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        return this.getOneToOneMapping().extractPrimaryKeysFromRealReferenceObject(referenceObject, session);
    }

    public abstract AbstractRecord extractReferenceRow(Object var1);

    public abstract void fixObjectReferences(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4, RemoteSession var5);

    protected CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.mapping;
    }

    protected ForeignReferenceMapping getForeignReferenceMapping() {
        return (ForeignReferenceMapping)this.mapping;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected ObjectReferenceMapping getOneToOneMapping() {
        return (ObjectReferenceMapping)this.mapping;
    }

    public abstract Object getOriginalIndirectionObject(Object var1, AbstractSession var2);

    public Object getOriginalIndirectionObjectForMerge(Object unitOfWorkIndirectionObject, AbstractSession session) {
        return this.getOriginalIndirectionObject(unitOfWorkIndirectionObject, session);
    }

    public abstract Object getOriginalValueHolder(Object var1, AbstractSession var2);

    public abstract Object getRealAttributeValueFromObject(Object var1, Object var2);

    public void instantiateObject(Object object, Object attribute) {
        this.getRealAttributeValueFromObject(object, attribute);
    }

    protected AbstractTransformationMapping getTransformationMapping() {
        return (AbstractTransformationMapping)this.mapping;
    }

    public abstract Object getValueFromRemoteValueHolder(RemoteValueHolder var1);

    public boolean isAttributeValueFullyBuilt(Object attributeValue) {
        return true;
    }

    public void initialize() {
    }

    public boolean isWeavedObjectBasicIndirectionPolicy() {
        return false;
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        if (attributeValue != null) {
            this.mapping.iterateOnRealAttributeValue(iterator, attributeValue);
        }
    }

    protected void mergeClientIntoServerValueHolder(RemoteValueHolder serverValueHolder, MergeManager mergeManager) {
        serverValueHolder.setMapping(this.mapping);
        serverValueHolder.setSession(mergeManager.getSession());
        if (this.mapping.isForeignReferenceMapping()) {
            ReadObjectQuery query = this.buildCascadeQuery(mergeManager);
            serverValueHolder.setQuery(query);
        }
    }

    public abstract void mergeRemoteValueHolder(Object var1, Object var2, MergeManager var3);

    public abstract Object nullValueFromRow();

    public abstract boolean objectIsInstantiated(Object var1);

    public abstract boolean objectIsEasilyInstantiated(Object var1);

    public boolean objectIsInstantiatedOrChanged(Object object) {
        return this.objectIsInstantiated(object);
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        this.mapping.setAttributeValueInObject(target, attributeValue);
    }

    public void setSourceObject(Object sourceObject, Object attributeValue) {
    }

    public void setUseLazyInstantiation(Boolean useLazyInstantiation) {
    }

    public Boolean shouldUseLazyInstantiation() {
        return false;
    }

    public void reset(Object target) {
    }

    public boolean usesIndirection() {
        return true;
    }

    public boolean usesTransparentIndirection() {
        return false;
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) throws DescriptorException {
        return attributeValue;
    }

    public void validateContainerPolicy(IntegrityChecker checker) throws DescriptorException {
    }

    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateDeclaredAttributeTypeForCollection(Class attributeType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateGetMethodReturnTypeForCollection(Class returnType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateSetMethodParameterTypeForCollection(Class parameterType, IntegrityChecker checker) throws DescriptorException {
    }

    public abstract Object valueFromBatchQuery(ReadQuery var1, AbstractRecord var2, ObjectLevelReadQuery var3, CacheKey var4);

    public abstract Object valueFromMethod(Object var1, AbstractRecord var2, AbstractSession var3);

    public abstract Object valueFromQuery(ReadQuery var1, AbstractRecord var2, Object var3, AbstractSession var4);

    public abstract Object valueFromQuery(ReadQuery var1, AbstractRecord var2, AbstractSession var3);

    public abstract Object valueFromRow(Object var1);
}

