/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.ParallelCallbackHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.ShardingConfig;
import org.sagacity.sqltoy.config.model.ShardingGroupModel;
import org.sagacity.sqltoy.dialect.executor.DialectExecutor;
import org.sagacity.sqltoy.model.ShardingResult;
import org.sagacity.sqltoy.plugins.sharding.ShardingUtils;

public class ParallelUtils {
    private ParallelUtils() {
    }

    public static List execute(SqlToyContext sqlToyContext, List entities, boolean wrapIdValue, DataSource dataSource, ParallelCallbackHandler handler) throws Exception {
        Collection<ShardingGroupModel> shardingGroups;
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        if (wrapIdValue) {
            ShardingUtils.assignPKs(sqlToyContext, entityMeta, entities);
        }
        if ((shardingGroups = ShardingUtils.groupShardings(sqlToyContext, entities, entityMeta, dataSource)).size() == 1) {
            return handler.execute(sqlToyContext, shardingGroups.iterator().next());
        }
        ShardingConfig shardingConfig = entityMeta.getShardingConfig();
        ArrayList results = new ArrayList();
        int threads = shardingGroups.size();
        boolean globalRollback = shardingConfig.isGlobalRollback();
        if (threads > shardingConfig.getMaxConcurrents() && shardingConfig.getMaxConcurrents() > 1) {
            threads = shardingConfig.getMaxConcurrents();
        }
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        ArrayList<Future<ShardingResult>> futureResults = new ArrayList<Future<ShardingResult>>();
        for (ShardingGroupModel group : shardingGroups) {
            Future<ShardingResult> future = pool.submit(new DialectExecutor(sqlToyContext, group, handler));
            futureResults.add(future);
        }
        pool.shutdown();
        if (shardingConfig.getMaxWaitSeconds() > 0) {
            pool.awaitTermination(shardingConfig.getMaxWaitSeconds(), TimeUnit.SECONDS);
        } else {
            pool.awaitTermination(SqlToyConstants.PARALLEL_MAXWAIT_SECONDS, TimeUnit.SECONDS);
        }
        try {
            for (Future future : futureResults) {
                ShardingResult item = (ShardingResult)future.get();
                if (item != null && !item.isSuccess() && globalRollback) {
                    throw new RuntimeException(item.getMessage());
                }
                if (item == null || item.getRows() == null || item.getRows().isEmpty()) continue;
                results.addAll(item.getRows());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            pool.shutdownNow();
        }
        return results;
    }
}

