/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins;

import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DbAdapterHandler;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.DialectFactory;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossDbAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(CrossDbAdapter.class);

    public static void redoCountQuery(SqlToyContext sqlToyContext, DialectFactory dialectFactory, QueryExecutor queryExecutor) {
        CrossDbAdapter.doQuery(sqlToyContext, queryExecutor, (sqlToyConfig, dataSource) -> dialectFactory.getCountBySql(sqlToyContext, queryExecutor, sqlToyConfig, dataSource));
    }

    public static void redoPageQuery(SqlToyContext sqlToyContext, DialectFactory dialectFactory, QueryExecutor queryExecutor, Page page) {
        CrossDbAdapter.doQuery(sqlToyContext, queryExecutor, (sqlToyConfig, dataSource) -> {
            if (page.getSkipQueryCount() != null && page.getSkipQueryCount().booleanValue()) {
                dialectFactory.findSkipTotalCountPage(sqlToyContext, queryExecutor, sqlToyConfig, page.getPageNo(), page.getPageSize(), dataSource);
            } else {
                dialectFactory.findPage(sqlToyContext, queryExecutor, sqlToyConfig, page.getPageNo(), page.getPageSize(), page.getOverPageToFirst(), dataSource);
            }
        });
    }

    public static void redoQuery(SqlToyContext sqlToyContext, DialectFactory dialectFactory, QueryExecutor queryExecutor) {
        CrossDbAdapter.doQuery(sqlToyContext, queryExecutor, (sqlToyConfig, dataSource) -> dialectFactory.findByQuery(sqlToyContext, queryExecutor, sqlToyConfig, null, dataSource));
    }

    public static void redoTopQuery(SqlToyContext sqlToyContext, DialectFactory dialectFactory, QueryExecutor queryExecutor, double topSize) {
        CrossDbAdapter.doQuery(sqlToyContext, queryExecutor, (sqlToyConfig, dataSource) -> dialectFactory.findTop(sqlToyContext, queryExecutor, sqlToyConfig, topSize, dataSource));
    }

    public static void redoRandomQuery(SqlToyContext sqlToyContext, DialectFactory dialectFactory, QueryExecutor queryExecutor, double randomCount) {
        CrossDbAdapter.doQuery(sqlToyContext, queryExecutor, (sqlToyConfig, dataSource) -> dialectFactory.getRandomResult(sqlToyContext, queryExecutor, sqlToyConfig, randomCount, dataSource));
    }

    private static void doQuery(SqlToyContext sqlToyContext, QueryExecutor queryExecutor, DbAdapterHandler dbAdapterHandler) {
        if (null == sqlToyContext.getRedoDataSources() || sqlToyContext.getRedoDataSources().length == 0) {
            return;
        }
        SqlToyConfig sqlToyConfig = null;
        String dataSourceName = null;
        for (int i = 0; i < sqlToyContext.getRedoDataSources().length; ++i) {
            dataSourceName = sqlToyContext.getRedoDataSources()[i];
            DataSource dataSource = sqlToyContext.getDataSourceSelector().getDataSourceBean(sqlToyContext.getAppContext(), dataSourceName);
            if (null == dataSource) {
                throw new IllegalArgumentException("\u8de8\u5e93\u67e5\u8be2\u9002\u914d\u9a8c\u8bc1,\u6570\u636e\u6e90:" + dataSourceName + " \u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u914d\u7f6e!");
            }
            String dialect = DataSourceUtils.getDialect(sqlToyContext, dataSource);
            sqlToyConfig = sqlToyContext.getSqlToyConfig(queryExecutor.getInnerModel().sql, SqlType.search, dialect);
            try {
                dbAdapterHandler.query(sqlToyConfig, dataSource);
                continue;
            }
            catch (Exception e) {
                String errMsg = "\u67e5\u8be2\u8bed\u53e5:" + sqlToyConfig.getId() + " \u4e0d\u9002\u914d:" + dialect + " \u7684\u6570\u636e\u6e90:" + dataSourceName + ";errorMsg=" + e.getMessage();
                logger.error(errMsg);
                throw new DataAccessException(errMsg);
            }
        }
    }
}

