/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.util.List;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.InsertRowCallbackHandler;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.utils.StringUtil;

public class Batch
extends BaseLink {
    private static final long serialVersionUID = -3564526241047940595L;
    private List<?> dataSet;
    private int batchSize;
    private InsertRowCallbackHandler insertCallhandler;
    private Boolean autoCommit = false;
    private String sql;

    public Batch(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Batch dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultDataSource = false;
        return this;
    }

    public Batch sql(String sql) {
        this.sql = sql;
        return this;
    }

    public Batch dataSet(List<?> dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    public Batch batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Batch autoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public Batch insertHandler(InsertRowCallbackHandler insertCallhandler) {
        this.insertCallhandler = insertCallhandler;
        return this;
    }

    public Long submit() {
        if (StringUtil.isBlank(this.sql)) {
            throw new IllegalArgumentException("batch execute sql is null!");
        }
        int realBatchSize = this.batchSize > 0 ? this.batchSize : this.sqlToyContext.getBatchSize();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.update, super.getDialect());
        return this.dialectFactory.batchUpdate(this.sqlToyContext, sqlToyConfig, this.dataSet, realBatchSize, null, this.insertCallhandler, this.autoCommit, this.getDataSource(sqlToyConfig));
    }
}

