/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DataSourceCallbackHandler;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.InsertRowCallbackHandler;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.StreamResultHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PageOptimize;
import org.sagacity.sqltoy.config.model.ShardingModel;
import org.sagacity.sqltoy.config.model.SqlParamsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlWithAnalysis;
import org.sagacity.sqltoy.dialect.Dialect;
import org.sagacity.sqltoy.dialect.impl.ClickHouseDialect;
import org.sagacity.sqltoy.dialect.impl.DB2Dialect;
import org.sagacity.sqltoy.dialect.impl.DMDialect;
import org.sagacity.sqltoy.dialect.impl.DefaultDialect;
import org.sagacity.sqltoy.dialect.impl.GuassDBDialect;
import org.sagacity.sqltoy.dialect.impl.H2Dialect;
import org.sagacity.sqltoy.dialect.impl.ImpalaDialect;
import org.sagacity.sqltoy.dialect.impl.KingbaseDialect;
import org.sagacity.sqltoy.dialect.impl.MySqlDialect;
import org.sagacity.sqltoy.dialect.impl.OceanBaseDialect;
import org.sagacity.sqltoy.dialect.impl.Oracle11gDialect;
import org.sagacity.sqltoy.dialect.impl.OracleDialect;
import org.sagacity.sqltoy.dialect.impl.PostgreSqlDialect;
import org.sagacity.sqltoy.dialect.impl.SqlServerDialect;
import org.sagacity.sqltoy.dialect.impl.SqliteDialect;
import org.sagacity.sqltoy.dialect.impl.TDengineDialect;
import org.sagacity.sqltoy.dialect.impl.TidbDialect;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.dialect.utils.PageOptimizeUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.TreeTableModel;
import org.sagacity.sqltoy.model.UniqueExecutor;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.secure.FieldsSecureProvider;
import org.sagacity.sqltoy.plugins.sharding.ShardingUtils;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.ParallelUtils;
import org.sagacity.sqltoy.utils.QueryExecutorBuilder;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectFactory {
    protected final Logger logger = LoggerFactory.getLogger(DialectFactory.class);
    private static HashMap<Integer, Dialect> dialects = new HashMap();
    private static DialectFactory me = new DialectFactory();
    private static Pattern STORE_PATTERN = Pattern.compile("^(\\s*\\{)?\\s*\\?");
    private static Pattern ARG_PATTERN = Pattern.compile("\\?");

    private DialectFactory() {
    }

    public static DialectFactory getInstance() {
        return me;
    }

    private Dialect getDialectSqlWrapper(Integer dbType) throws Exception {
        if (dialects.containsKey(dbType)) {
            return dialects.get(dbType);
        }
        Dialect dialectSqlWrapper = null;
        switch (dbType) {
            case 10: {
                dialectSqlWrapper = new OracleDialect();
                break;
            }
            case 40: 
            case 42: {
                dialectSqlWrapper = new MySqlDialect();
                break;
            }
            case 30: {
                dialectSqlWrapper = new SqlServerDialect();
                break;
            }
            case 50: 
            case 51: {
                dialectSqlWrapper = new PostgreSqlDialect();
                break;
            }
            case 100: {
                dialectSqlWrapper = new OceanBaseDialect();
                break;
            }
            case 20: {
                dialectSqlWrapper = new DB2Dialect();
                break;
            }
            case 60: {
                dialectSqlWrapper = new ClickHouseDialect();
                break;
            }
            case 90: {
                dialectSqlWrapper = new TidbDialect();
                break;
            }
            case 70: {
                dialectSqlWrapper = new GuassDBDialect();
                break;
            }
            case 160: {
                dialectSqlWrapper = new ImpalaDialect();
                break;
            }
            case 110: {
                dialectSqlWrapper = new DMDialect();
                break;
            }
            case 80: {
                dialectSqlWrapper = new SqliteDialect();
                break;
            }
            case 11: {
                dialectSqlWrapper = new Oracle11gDialect();
                break;
            }
            case 120: {
                dialectSqlWrapper = new KingbaseDialect();
                break;
            }
            case 170: {
                dialectSqlWrapper = new H2Dialect();
                break;
            }
            case 150: {
                dialectSqlWrapper = new TDengineDialect();
                break;
            }
            default: {
                dialectSqlWrapper = new DefaultDialect();
            }
        }
        dialects.put(dbType, dialectSqlWrapper);
        return dialectSqlWrapper;
    }

    public Long batchUpdate(final SqlToyContext sqlToyContext, final SqlToyConfig sqlToyConfig, final List dataSet, final int batchSize, final ReflectPropsHandler reflectPropsHandler, final InsertRowCallbackHandler insertCallhandler, final Boolean autoCommit, DataSource dataSource) {
        if (dataSet == null || dataSet.isEmpty()) {
            this.logger.warn("batchUpdate dataSet is null or empty,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(sqlToyConfig.getId(), "batchUpdate:[" + dataSet.size() + "]\u6761\u8bb0\u5f55!", sqlToyConfig.isShowSql());
            Long updateTotalCnt = (Long)DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    String realSql = sqlToyConfig.getSql(dialect);
                    Integer[] fieldTypes = null;
                    List values = dataSet;
                    if (sqlToyConfig.getParamsName() != null) {
                        SqlParamsModel sqlParamsModel = SqlConfigParseUtils.processNamedParamsQuery(realSql);
                        realSql = sqlParamsModel.getSql();
                        ReflectPropsHandler realPropsHandler = DialectUtils.wrapReflectWithUnifyFields(realSql, reflectPropsHandler, sqlToyContext.getUnifyFieldsHandler());
                        values = BeanUtil.reflectBeansToList(dataSet, sqlParamsModel.getParamsName(), realPropsHandler);
                        fieldTypes = BeanUtil.matchMethodsType(dataSet.get(0).getClass(), sqlParamsModel.getParamsName());
                    }
                    realSql = SqlUtilsExt.signSql(realSql, dbType, sqlToyConfig);
                    SqlExecuteStat.showSql("\u6279\u91cfsql\u6267\u884c", realSql, null);
                    this.setResult(SqlUtil.batchUpdateByJdbc(sqlToyContext.getTypeHandler(), realSql, values, batchSize, insertCallhandler, fieldTypes, autoCommit, conn, dbType));
                }
            });
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "batchUpdate\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "batchUpdate\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long executeSql(final SqlToyContext sqlToyContext, final SqlToyConfig sqlToyConfig, final QueryExecutor queryExecutor, final Integer[] paramsTypes, final Boolean autoCommit, DataSource dataSource) {
        try {
            final QueryExecutorExtend extend = queryExecutor.getInnerModel();
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
            SqlExecuteStat.start(sqlToyConfig.getId(), "executeSql", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            Long updateTotalCnt = (Long)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, false);
                    SqlToyResult queryParam = SqlConfigParseUtils.processSql(realSqlToyConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, realSqlToyConfig), dialect);
                    queryParam = DialectUtils.doInterceptors(sqlToyContext, realSqlToyConfig, extend.entityClass == null ? OperateType.execute : OperateType.singleTable, queryParam, extend.entityClass, dbType);
                    String executeSql = SqlUtilsExt.signSql(queryParam.getSql(), dbType, realSqlToyConfig);
                    if (paramsTypes != null && queryParam.getParamsValue() != null && queryParam.getParamsValue().length != paramsTypes.length) {
                        this.setResult(SqlUtil.executeSql(sqlToyContext.getTypeHandler(), executeSql, queryParam.getParamsValue(), null, conn, dbType, autoCommit, false));
                    } else {
                        this.setResult(SqlUtil.executeSql(sqlToyContext.getTypeHandler(), executeSql, queryParam.getParamsValue(), paramsTypes, conn, dbType, autoCommit, false));
                    }
                }
            });
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "executeSql\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "executeSql\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public boolean isUnique(final SqlToyContext sqlToyContext, final UniqueExecutor uniqueExecutor, DataSource dataSource) {
        if (uniqueExecutor.getEntity() == null) {
            throw new IllegalArgumentException("unique judge entity object is null,please check!");
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(uniqueExecutor.getEntity().getClass()).getName(), "isUnique", sqlToyContext.isDebug());
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, uniqueExecutor.getEntity(), false, dataSource);
            Boolean isUnique = (Boolean)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).isUnique(sqlToyContext, uniqueExecutor.getEntity(), uniqueExecutor.getUniqueFields(), conn, dbType, shardingModel.getTableName()));
                }
            });
            SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u552f\u4e00\u6027\u9a8c\u8bc1\u8fd4\u56de\u7ed3\u679c={}!", isUnique);
            boolean bl = isUnique;
            return bl;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public QueryResult getRandomResult(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final Double randomCount, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (extend.sql == null) {
            throw new IllegalArgumentException("getRandomResult operate sql is null!");
        }
        try {
            Long startTime = System.currentTimeMillis();
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, randomCount < 1.0);
            SqlExecuteStat.start(sqlToyConfig.getId(), "getRandomResult", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            QueryResult result = (QueryResult)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    Long randomCnt;
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, randomCount < 1.0);
                    Long totalCount = null;
                    if (randomCount >= 1.0) {
                        randomCnt = randomCount.longValue();
                    } else {
                        long countRunTime = 0L;
                        if (totalCount == null) {
                            long preTime = System.currentTimeMillis();
                            totalCount = DialectFactory.this.getCountBySql(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                            countRunTime = System.currentTimeMillis() - preTime;
                        }
                        randomCnt = Double.valueOf((double)totalCount.longValue() * randomCount).longValue();
                        if (countRunTime == 0L) {
                            SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "\u6309\u6bd4\u4f8b\u63d0\u53d6\u603b\u8bb0\u5f55\u6570:{}\u6761,\u9700\u53d6\u968f\u673a\u8bb0\u5f55:{}\u6761!", totalCount, randomCnt);
                        } else {
                            SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "\u6309\u6bd4\u4f8b\u63d0\u53d6\u603b\u8bb0\u5f55\u6570:{}\u6761,\u9700\u53d6\u968f\u673a\u8bb0\u5f55:{}\u6761,\u6267\u884ccount\u67e5\u8be2\u8017\u65f6:{}\u6beb\u79d2!", totalCount, randomCnt, countRunTime);
                        }
                        if (totalCount >= 1L && randomCnt < 1L) {
                            randomCnt = 1L;
                        }
                    }
                    if (totalCount != null && totalCount == 0L) {
                        QueryResult queryResult = new QueryResult();
                        queryResult.setRows(new ArrayList());
                        this.setResult(queryResult);
                        DialectFactory.this.logger.warn("getRandom,total Records is zero,please check sql!sqlId={}", (Object)sqlToyConfig.getIdOrSql());
                        return;
                    }
                    QueryResult queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).getRandomResult(sqlToyContext, realSqlToyConfig, queryExecutor, DialectFactory.this.wrapDecryptHandler(sqlToyContext, extend.resultType), totalCount, randomCnt, conn, dbType, dialect, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                    if (queryResult.getRows() != null && !queryResult.getRows().isEmpty()) {
                        List pivotCategorySet = ResultUtils.getPivotCategory(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), realSqlToyConfig, queryResult, pivotCategorySet, extend);
                        if (extend.resultType != null) {
                            queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), (Class)extend.resultType, changedCols, extend.humpMapLabel, extend.hiberarchy, extend.hiberarchyClasses, extend.fieldsMap));
                        }
                    }
                    SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u53d6\u5f97\u968f\u673a\u8bb0\u5f55\u6570:{}\u6761!", queryResult.getRecordCount());
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public boolean wrapTreeTableRoute(final SqlToyContext sqlToyContext, final TreeTableModel treeModel, DataSource dataSource) {
        if (treeModel == null || StringUtil.isBlank(treeModel.getPidField())) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5pidField\u8d4b\u503c\u662f\u5426\u6b63\u786e!");
        }
        if (StringUtil.isBlank(treeModel.getLeafField()) || StringUtil.isBlank(treeModel.getNodeRouteField()) || StringUtil.isBlank(treeModel.getNodeLevelField())) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5isLeafField\nodeRouteField\nodeLevelField \u8d4b\u503c\u662f\u5426\u6b63\u786e!");
        }
        try {
            if (null != treeModel.getEntity()) {
                EntityMeta entityMeta = null;
                entityMeta = treeModel.getEntity() instanceof Type ? sqlToyContext.getEntityMeta((Class)treeModel.getEntity()) : sqlToyContext.getEntityMeta(treeModel.getEntity().getClass());
                String columnName = entityMeta.getColumnName(treeModel.getPidField());
                if (columnName != null) {
                    treeModel.pidField(columnName);
                }
                if ((columnName = entityMeta.getColumnName(treeModel.getLeafField())) != null) {
                    treeModel.isLeafField(columnName);
                }
                if ((columnName = entityMeta.getColumnName(treeModel.getNodeLevelField())) != null) {
                    treeModel.nodeLevelField(columnName);
                }
                if ((columnName = entityMeta.getColumnName(treeModel.getNodeRouteField())) != null) {
                    treeModel.nodeRouteField(columnName);
                }
                HashMap<String, String> columnMap = new HashMap<String, String>();
                for (FieldMeta column : entityMeta.getFieldsMeta().values()) {
                    columnMap.put(column.getColumnName().toUpperCase(), "");
                }
                if (!columnMap.containsKey(treeModel.getNodeRouteField().toUpperCase())) {
                    throw new IllegalArgumentException("\u6811\u5f62\u8868:\u8282\u70b9\u8def\u5f84\u5b57\u6bb5\u540d\u79f0:" + treeModel.getNodeRouteField() + "\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5!");
                }
                if (!columnMap.containsKey(treeModel.getLeafField().toUpperCase())) {
                    throw new IllegalArgumentException("\u6811\u5f62\u8868:\u662f\u5426\u53f6\u5b50\u8282\u70b9\u5b57\u6bb5\u540d\u79f0:" + treeModel.getLeafField() + "\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5!");
                }
                if (!columnMap.containsKey(treeModel.getNodeLevelField().toUpperCase())) {
                    throw new IllegalArgumentException("\u6811\u5f62\u8868:\u8282\u70b9\u7b49\u7ea7\u5b57\u6bb5\u540d\u79f0:" + treeModel.getNodeLevelField() + "\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5!");
                }
                FieldMeta idMeta = entityMeta.getFieldMeta(entityMeta.getIdArray()[0]);
                if (StringUtil.isBlank(treeModel.getIdField())) {
                    treeModel.idField(idMeta.getColumnName());
                } else {
                    columnName = entityMeta.getColumnName(treeModel.getIdField());
                    if (columnName != null) {
                        treeModel.idField(columnName);
                    }
                }
                if (StringUtil.isBlank(treeModel.getTableName())) {
                    treeModel.table(entityMeta.getSchemaTable(null, null));
                }
                if (!(treeModel.getEntity() instanceof Type)) {
                    if (null == treeModel.getRootId()) {
                        Object pidValue = BeanUtil.getProperty(treeModel.getEntity(), StringUtil.toHumpStr(treeModel.getPidField(), false));
                        treeModel.rootId(pidValue);
                    }
                    if (null == treeModel.getIdValue()) {
                        Object idValue = BeanUtil.getProperty(treeModel.getEntity(), StringUtil.toHumpStr(treeModel.getIdField(), false));
                        treeModel.setIdValue(idValue);
                    }
                }
                if (treeModel.isChar() == null) {
                    if (!treeModel.getIdField().equalsIgnoreCase(idMeta.getColumnName())) {
                        idMeta = entityMeta.getFieldMeta(entityMeta.getColumnFieldMap().get(treeModel.getIdField().toLowerCase()));
                    }
                    if (idMeta.getType() == 4 || idMeta.getType() == 3 || idMeta.getType() == 8 || idMeta.getType() == 6 || idMeta.getType() == 2 || idMeta.getType() == -5) {
                        treeModel.idTypeIsChar(false);
                    } else if (idMeta.getType() == 12 || idMeta.getType() == -9 || idMeta.getType() == 1 || idMeta.getType() == -15 || idMeta.getType() == -1) {
                        treeModel.idTypeIsChar(true);
                    }
                }
            }
            SqlExecuteStat.start(treeModel.getTableName(), "wrapTreeTableRoute", sqlToyContext.isDebug());
            boolean entityMeta = (Boolean)DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(SqlUtil.wrapTreeTableRoute(sqlToyContext.getTypeHandler(), treeModel, conn, dbType));
                }
            });
            return entityMeta;
        }
        catch (Exception e) {
            this.logger.error("\u5c01\u88c5\u6811\u5f62\u8868\u8282\u70b9\u8def\u5f84\u64cd\u4f5c:wrapTreeTableRoute\u53d1\u751f\u9519\u8bef,{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public QueryResult findSkipTotalCountPage(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final long pageNo, final Integer pageSize, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (StringUtil.isBlank(extend.sql)) {
            throw new IllegalArgumentException("findSkipTotalCountPage operate sql is null!");
        }
        if (pageNo < 1L || pageSize < 1) {
            throw new IllegalArgumentException("findSkipTotalCountPage operate  pageSize:" + pageSize + "<1 or pageNo:" + pageNo + " < 1!");
        }
        int limitSize = sqlToyContext.getPageFetchSizeLimit();
        if (pageSize >= limitSize) {
            throw new IllegalArgumentException("findSkipTotalCountPage operate args is Illegal,pageSize={" + pageSize + "}>= limit:{" + limitSize + "}!");
        }
        try {
            Long startTime = System.currentTimeMillis();
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
            SqlExecuteStat.start(sqlToyConfig.getId(), "findSkipTotalCountPage", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            QueryResult result = (QueryResult)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, false);
                    QueryResult queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).findPageBySql(sqlToyContext, realSqlToyConfig, queryExecutor, DialectFactory.this.wrapDecryptHandler(sqlToyContext, extend.resultType), pageNo, pageSize, conn, dbType, dialect, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                    queryResult.setPageNo(pageNo);
                    queryResult.setPageSize(pageSize);
                    if (queryResult.getRows() != null && !queryResult.getRows().isEmpty()) {
                        List pivotCategorySet = ResultUtils.getPivotCategory(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), realSqlToyConfig, queryResult, pivotCategorySet, extend);
                        if (extend.resultType != null) {
                            queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), (Class)extend.resultType, changedCols, extend.humpMapLabel, extend.hiberarchy, extend.hiberarchyClasses, extend.fieldsMap));
                        }
                    }
                    queryResult.setSkipQueryCount(true);
                    SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u5206\u9875\u67e5\u8be2\u51fa\u8bb0\u5f55\u6570\u91cf:{}\u6761!", queryResult.getRecordCount());
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public QueryResult findPage(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final long pageNo, final Integer pageSize, final Boolean overPageToFirst, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (StringUtil.isBlank(extend.sql)) {
            throw new IllegalArgumentException("findPage operate sql is null!");
        }
        try {
            Long startTime = System.currentTimeMillis();
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, true);
            SqlExecuteStat.start(sqlToyConfig.getId(), "findPage", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            final DataSource realDataSource = ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource);
            QueryResult result = (QueryResult)DataSourceUtils.processDataSource(sqlToyContext, realDataSource, new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    boolean isOverPageToFirst = false;
                    if (sqlToyContext.getOverPageToFirst() != null) {
                        isOverPageToFirst = sqlToyContext.getOverPageToFirst();
                    }
                    if (overPageToFirst != null) {
                        isOverPageToFirst = overPageToFirst;
                    }
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, true);
                    QueryResult queryResult = null;
                    PageOptimize pageOptimize = extend.pageOptimize;
                    if (pageOptimize == null) {
                        pageOptimize = realSqlToyConfig.getPageOptimize();
                    }
                    Long recordCnt = null;
                    String pageQueryKey = PageOptimizeUtils.generateOptimizeKey(sqlToyContext, sqlToyConfig, queryExecutor, pageOptimize);
                    if (null != pageQueryKey && (recordCnt = PageOptimizeUtils.getPageTotalCount(realSqlToyConfig, pageOptimize, pageQueryKey)) != null) {
                        SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "\u5206\u9875\u4f18\u5316\u6761\u4ef6\u547d\u4e2d,\u4ece\u7f13\u5b58\u4e2d\u83b7\u5f97\u603b\u8bb0\u5f55\u6570:{}!!", recordCnt);
                    }
                    if (pageOptimize != null && pageOptimize.isParallel() && pageNo != -1L && recordCnt == null) {
                        queryResult = DialectFactory.this.parallelPage(sqlToyContext, queryExecutor, realSqlToyConfig, extend, pageNo, pageSize, isOverPageToFirst, pageOptimize, conn, dbType, dialect, realDataSource);
                        recordCnt = queryResult.getRecordCount();
                        if (null != pageQueryKey) {
                            PageOptimizeUtils.registPageTotalCount(realSqlToyConfig, pageOptimize, pageQueryKey, recordCnt);
                        }
                    } else {
                        boolean illegal;
                        if (recordCnt == null) {
                            long preTime = System.currentTimeMillis();
                            recordCnt = DialectFactory.this.getCountBySql(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                            SqlExecuteStat.debug("\u67e5\u8be2count\u6267\u884c\u8017\u65f6", System.currentTimeMillis() - preTime + "\u6beb\u79d2!", new Object[0]);
                        }
                        if (null != pageQueryKey) {
                            PageOptimizeUtils.registPageTotalCount(realSqlToyConfig, pageOptimize, pageQueryKey, recordCnt);
                        }
                        int limitSize = sqlToyContext.getPageFetchSizeLimit();
                        boolean bl = illegal = pageNo == -1L && limitSize != -1 && recordCnt > (long)limitSize;
                        if (recordCnt == 0L || illegal) {
                            queryResult = new QueryResult();
                            if (recordCnt == 0L && isOverPageToFirst) {
                                queryResult.setPageNo(1L);
                            } else {
                                queryResult.setPageNo(pageNo);
                            }
                            queryResult.setPageSize(pageSize);
                            queryResult.setRecordCount(0L);
                            if (illegal) {
                                SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "\u975e\u6cd5\u5206\u9875\u67e5\u8be2,\u63d0\u53d6\u8bb0\u5f55\u603b\u6570\u4e3a:{}>{}\u4e0a\u9650,\u53ef\u8bbe\u7f6e\u53c2\u6570:spring.sqltoy.pageFetchSizeLimit\u8fdb\u884c\u8c03\u6574(-1\u8868\u793a\u4e0d\u9650\u5236)", recordCnt, limitSize);
                                DialectFactory.this.logger.warn("\u975e\u6cd5\u5206\u9875\u67e5\u8be2,\u63d0\u53d6\u8bb0\u5f55\u603b\u6570\u4e3a:{}>{}\u4e0a\u9650\u53ef\u8bbe\u7f6e\u53c2\u6570:spring.sqltoy.pageFetchSizeLimit\u8fdb\u884c\u8c03\u6574(-1\u8868\u793a\u4e0d\u9650\u5236),sql={}", new Object[]{recordCnt, limitSize, sqlToyConfig.getIdOrSql()});
                            } else {
                                SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "\u5206\u9875\u67e5\u8be2\u63d0\u53d6count\u6570\u4e3a:0", new Object[0]);
                            }
                        } else {
                            long preTime = System.currentTimeMillis();
                            if (pageNo == -1L) {
                                SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "pageNo=-1,\u9875\u9762\u53ef\u80fd\u5728\u505a\u4e0b\u8f7d\u64cd\u4f5c!", new Object[0]);
                                SqlToyResult queryParam = SqlConfigParseUtils.processSql(realSqlToyConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, realSqlToyConfig), dialect);
                                queryParam = DialectUtils.doInterceptors(sqlToyContext, realSqlToyConfig, extend.entityClass == null ? OperateType.search : OperateType.singleTable, queryParam, extend.entityClass, dbType);
                                queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).findBySql(sqlToyContext, realSqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, DialectFactory.this.wrapDecryptHandler(sqlToyContext, extend.resultType), conn, null, dbType, dialect, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                                long totalRecord = queryResult.getRows() == null ? 0L : (long)queryResult.getRows().size();
                                queryResult.setPageNo(1L);
                                queryResult.setPageSize(Long.valueOf(totalRecord).intValue());
                                queryResult.setRecordCount(totalRecord);
                            } else {
                                boolean isOverPage;
                                boolean bl2 = isOverPage = pageNo * (long)pageSize.intValue() >= recordCnt + (long)pageSize.intValue();
                                if (isOverPage && !isOverPageToFirst) {
                                    queryResult = new QueryResult();
                                    queryResult.setPageNo(pageNo);
                                } else {
                                    long realStartPage = isOverPage ? 1L : pageNo;
                                    queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).findPageBySql(sqlToyContext, realSqlToyConfig, queryExecutor, DialectFactory.this.wrapDecryptHandler(sqlToyContext, extend.resultType), realStartPage, pageSize, conn, dbType, dialect, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                                    queryResult.setPageNo(realStartPage);
                                }
                                queryResult.setPageSize(pageSize);
                                queryResult.setRecordCount(recordCnt);
                            }
                            SqlExecuteStat.debug("\u67e5\u8be2\u5206\u9875\u8bb0\u5f55\u8017\u65f6", System.currentTimeMillis() - preTime + "\u6beb\u79d2!", new Object[0]);
                        }
                    }
                    if (queryResult.getRows() != null && !queryResult.getRows().isEmpty()) {
                        List pivotCategorySet = ResultUtils.getPivotCategory(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), realSqlToyConfig, queryResult, pivotCategorySet, extend);
                        if (extend.resultType != null) {
                            queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), (Class)extend.resultType, changedCols, extend.humpMapLabel, extend.hiberarchy, extend.hiberarchyClasses, extend.fieldsMap));
                        }
                    }
                    SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u5206\u9875\u603b\u8bb0\u5f55\u6570:{}\u6761,\u53d6\u5f97\u672c\u9875\u8bb0\u5f55\u6570:{}\u6761!", queryResult.getRecordCount(), queryResult.getRows().size());
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    private QueryResult parallelPage(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, QueryExecutorExtend extend, long pageNo, Integer pageSize, boolean overPageToFirst, PageOptimize pageOptimize, Connection conn, Integer dbType, String dialect, DataSource dataSource) throws Exception {
        final QueryResult queryResult = new QueryResult();
        queryResult.setPageNo(pageNo);
        queryResult.setPageSize(pageSize);
        Executor taskExecutor = sqlToyContext.getTaskExecutor();
        try {
            SqlExecuteStat.debug("\u5f00\u59cb\u5e76\u884c\u67e5\u8be2count\u603b\u8bb0\u5f55\u6570\u548c\u5355\u9875\u8bb0\u5f55\u6570\u636e!", null, new Object[0]);
            CompletableFuture<Void> countCompletableFuture = CompletableFuture.runAsync(() -> {
                try {
                    Long startTime = System.currentTimeMillis();
                    DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

                        @Override
                        public void doConnection(Connection countConn, Integer countDbType, String countDialect) throws Exception {
                            queryResult.setRecordCount(DialectFactory.this.getCountBySql(sqlToyContext, sqlToyConfig, queryExecutor, countConn, countDbType, countDialect));
                        }
                    });
                    SqlExecuteStat.debug("\u67e5\u8be2count\u6267\u884c\u8017\u65f6", System.currentTimeMillis() - startTime + "\u6beb\u79d2!", new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    queryResult.setSuccess(false);
                    queryResult.setMessage("\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u5f02\u5e38:" + e.getMessage());
                }
            }, taskExecutor);
            try {
                Long startTime = System.currentTimeMillis();
                QueryResult result = this.getDialectSqlWrapper(dbType).findPageBySql(sqlToyContext, sqlToyConfig, queryExecutor, this.wrapDecryptHandler(sqlToyContext, extend.resultType), pageNo, pageSize, conn, dbType, dialect, this.getFetchSize(extend.fetchSize), extend.maxRows);
                queryResult.setRows(result.getRows());
                queryResult.setLabelNames(result.getLabelNames());
                queryResult.setLabelTypes(result.getLabelTypes());
                SqlExecuteStat.debug("\u67e5\u8be2\u5206\u9875\u8bb0\u5f55\u8017\u65f6", System.currentTimeMillis() - startTime + "\u6beb\u79d2!", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                queryResult.setSuccess(false);
                queryResult.setMessage("\u67e5\u8be2\u5355\u9875\u8bb0\u5f55\u6570\u636e\u5f02\u5e38:" + e.getMessage());
            }
            if (pageOptimize.getParallelMaxWaitSeconds() > 0L) {
                countCompletableFuture.get(pageOptimize.getParallelMaxWaitSeconds(), TimeUnit.SECONDS);
            } else {
                countCompletableFuture.get(SqlToyConstants.PARALLEL_MAXWAIT_SECONDS, TimeUnit.SECONDS);
            }
            if (!queryResult.isSuccess()) {
                throw new DataAccessException("\u5e76\u884c\u67e5\u8be2\u6267\u884c\u9519\u8bef:" + queryResult.getMessage());
            }
            int rowSize = queryResult.getRows() == null ? 0 : queryResult.getRows().size();
            long minCount = (queryResult.getPageNo() - 1L) * (long)queryResult.getPageSize().intValue() + (long)rowSize;
            if (queryResult.getRecordCount() < minCount && minCount >= 0L && rowSize <= queryResult.getPageSize()) {
                queryResult.setRecordCount(minCount);
            }
            if (rowSize < queryResult.getPageSize() && queryResult.getRecordCount() > minCount && minCount >= 0L) {
                queryResult.setRecordCount(minCount);
            }
            if (queryResult.getRecordCount() == 0L && overPageToFirst) {
                queryResult.setPageNo(1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException("\u5e76\u884c\u67e5\u8be2\u6267\u884c\u9519\u8bef:" + e.getMessage(), e);
        }
        return queryResult;
    }

    public QueryResult findTop(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final double topSize, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (StringUtil.isBlank(extend.sql)) {
            throw new IllegalArgumentException("findTop operate sql is null!");
        }
        try {
            Long startTime = System.currentTimeMillis();
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, topSize < 1.0);
            SqlExecuteStat.start(sqlToyConfig.getId(), "findTop", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            QueryResult result = (QueryResult)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    Integer realTopSize;
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, topSize < 1.0);
                    if (topSize < 1.0) {
                        long preTime = System.currentTimeMillis();
                        Long totalCount = DialectFactory.this.getCountBySql(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                        realTopSize = Double.valueOf(topSize * (double)totalCount.longValue()).intValue();
                        SqlExecuteStat.debug("\u8fc7\u7a0b\u63d0\u793a", "\u6309\u6bd4\u4f8b\u63d0\u53d6,\u603b\u8bb0\u5f55\u6570:{}\u6761,\u6309\u6bd4\u4f8btop\u8bb0\u5f55\u8981\u53d6:{} \u6761,\u6267\u884ccount\u8bb0\u5f55\u6570\u8017\u65f6:{}\u6beb\u79d2!", totalCount, realTopSize, System.currentTimeMillis() - preTime);
                    } else {
                        realTopSize = Double.valueOf(topSize).intValue();
                    }
                    if (realTopSize == 0) {
                        this.setResult(new QueryResult());
                        SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u5b9e\u9645\u53d6\u5f97top\u8bb0\u5f55\u6570:0 \u6761!", new Object[0]);
                        return;
                    }
                    QueryResult queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).findTopBySql(sqlToyContext, realSqlToyConfig, queryExecutor, DialectFactory.this.wrapDecryptHandler(sqlToyContext, extend.resultType), realTopSize, conn, dbType, dialect, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                    if (queryResult.getRows() != null && !queryResult.getRows().isEmpty()) {
                        List pivotCategorySet = ResultUtils.getPivotCategory(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), realSqlToyConfig, queryResult, pivotCategorySet, extend);
                        if (extend.resultType != null) {
                            queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), (Class)extend.resultType, changedCols, extend.humpMapLabel, extend.hiberarchy, extend.hiberarchyClasses, extend.fieldsMap));
                        }
                    }
                    SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u5b9e\u9645\u53d6\u5f97top\u8bb0\u5f55\u6570: {}\u6761!", queryResult.getRecordCount());
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public QueryResult findByQuery(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final LockMode lockMode, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (StringUtil.isBlank(extend.sql)) {
            throw new IllegalArgumentException("findByQuery operate sql is null!");
        }
        try {
            Long startTime = System.currentTimeMillis();
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
            SqlExecuteStat.start(sqlToyConfig.getId(), "findByQuery", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            QueryResult result = (QueryResult)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, false);
                    SqlToyResult queryParam = SqlConfigParseUtils.processSql(realSqlToyConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, realSqlToyConfig), dialect);
                    queryParam = DialectUtils.doInterceptors(sqlToyContext, realSqlToyConfig, extend.entityClass == null ? OperateType.search : OperateType.singleTable, queryParam, extend.entityClass, dbType);
                    QueryResult queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).findBySql(sqlToyContext, realSqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, DialectFactory.this.wrapDecryptHandler(sqlToyContext, extend.resultType), conn, lockMode, dbType, dialect, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                    if (queryResult.getRows() != null && !queryResult.getRows().isEmpty()) {
                        List pivotCategorySet = ResultUtils.getPivotCategory(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect);
                        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), realSqlToyConfig, queryResult, pivotCategorySet, extend);
                        if (extend.resultType != null) {
                            queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), (Class)extend.resultType, changedCols, extend.humpMapLabel, extend.hiberarchy, extend.hiberarchyClasses, extend.fieldsMap));
                        }
                    }
                    SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "\u5171\u67e5\u8be2\u51fa\u8bb0\u5f55\u6570={}\u6761!", queryResult.getRecordCount());
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long getCountBySql(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, DataSource dataSource) {
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (StringUtil.isBlank(extend.sql)) {
            throw new IllegalArgumentException("getCountBySql operate sql is null!");
        }
        try {
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
            SqlExecuteStat.start(sqlToyConfig.getId(), "getCountBySql", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            Long count = (Long)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, false);
                    this.setResult(DialectFactory.this.getCountBySql(sqlToyContext, realSqlToyConfig, queryExecutor, conn, dbType, dialect));
                }
            });
            SqlExecuteStat.debug("\u67e5\u8be2\u7ed3\u679c", "count\u67e5\u8be2\u7ed3\u679c={}!", count);
            Long l = count;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    private Long getCountBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, Connection conn, Integer dbType, String dialect) throws Exception {
        String sql;
        boolean isLastSql = false;
        String tmp = sqlToyConfig.getCountSql(dialect);
        if (tmp != null) {
            sql = tmp;
            isLastSql = true;
        } else {
            String fastWithSql;
            sql = !sqlToyConfig.isHasFast() ? sqlToyConfig.getSql(dialect) : ((fastWithSql = sqlToyConfig.getFastWithSql(dialect)) == null ? "" : fastWithSql).concat(" ").concat(sqlToyConfig.getFastSql(dialect));
            String rejectWithSql = sql;
            String withSql = "";
            boolean hasUnion = false;
            if (sqlToyConfig.isHasUnion() && sqlToyConfig.isUnionAllCount()) {
                if (sqlToyConfig.isHasWith()) {
                    SqlWithAnalysis sqlWith = new SqlWithAnalysis(sql);
                    rejectWithSql = sqlWith.getRejectWithSql();
                    withSql = sqlWith.getWithSql();
                }
                hasUnion = SqlUtil.hasUnion(rejectWithSql, false);
            }
            if (hasUnion && StringUtil.matches(rejectWithSql, SqlToyConstants.UNION_ALL_REGEX)) {
                isLastSql = true;
                String[] unionSqls = rejectWithSql.split(SqlToyConstants.UNION_ALL_REGEX);
                StringBuilder countSql = new StringBuilder();
                countSql.append(withSql);
                countSql.append(" select sum(row_count) from (");
                int unionSqlSize = unionSqls.length;
                String countPart = dbType.equals(140) ? " count(*) " : " count(1) ";
                for (int i = 0; i < unionSqlSize; ++i) {
                    int sql_from_index = StringUtil.getSymMarkMatchIndex("(?i)select\\s+", "(?i)\\s+from[\\(\\s+]", unionSqls[i], 0);
                    countSql.append(" select ").append(countPart).append(" row_count ").append(sql_from_index != -1 ? unionSqls[i].substring(sql_from_index) : unionSqls[i]);
                    if (i >= unionSqlSize - 1) continue;
                    countSql.append(" union all ");
                }
                countSql.append(" ) ");
                sql = countSql.toString();
            }
        }
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        SqlToyResult queryParam = SqlConfigParseUtils.processSql(sql, extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig), dialect);
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.count : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return this.getDialectSqlWrapper(dbType).getCountBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), isLastSql, conn, dbType, dialect);
    }

    public Long saveOrUpdate(final SqlToyContext sqlToyContext, final Serializable entity, final String[] forceUpdateProps, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("saveOrUpdate entity is null,please check!");
            return 0L;
        }
        if (DialectUtils.isEmptyPK(sqlToyContext, entity)) {
            this.logger.debug("\u4e3b\u952e\u5b57\u6bb5\u5bf9\u5e94\u503c\u5b58\u5728null\uff0c\u56e0\u6b64saveOrUpdate\u8f6c\u6267\u884csave\u64cd\u4f5c!");
            this.save(sqlToyContext, entity, dataSource);
            return 1L;
        }
        try {
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, entity, true, dataSource);
            SqlExecuteStat.start(entity.getClass().getName(), "saveOrUpdate", sqlToyContext.isDebug());
            Long updateTotalCnt = (Long)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).saveOrUpdate(sqlToyContext, entity, forceUpdateProps, conn, dbType, dialect, null, shardingModel.getTableName()));
                }
            });
            SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveOrUpdate\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long saveOrUpdateAll(SqlToyContext sqlToyContext, List<?> entities, final int batchSize, final String[] forceUpdateProps, final ReflectPropsHandler reflectPropsHandler, DataSource dataSource, final Boolean autoCommit) {
        if (entities == null || entities.isEmpty()) {
            this.logger.warn("saveOrUpdateAll entities is null or empty,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entities.get(0).getClass()).getName(), "saveOrUpdateAll:[" + entities.size() + "]\u6761\u8bb0\u5f55!", sqlToyContext.isDebug());
            List result = ParallelUtils.execute(sqlToyContext, entities, true, dataSource, (context, batchModel) -> {
                final ShardingModel shardingModel = batchModel.getShardingModel();
                Long updateCnt = (Long)DataSourceUtils.processDataSource(context, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                    @Override
                    public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                        SqlExecuteStat.setDialect(dialect);
                        this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).saveOrUpdateAll(context, batchModel.getEntities(), batchSize, reflectPropsHandler, forceUpdateProps, conn, dbType, dialect, autoCommit, shardingModel.getTableName()));
                    }
                });
                ArrayList<Long> tmp = new ArrayList<Long>();
                tmp.add(updateCnt);
                return tmp;
            });
            long updateTotalCnt = 0L;
            if (result != null) {
                for (Long cnt : result) {
                    updateTotalCnt += cnt.longValue();
                }
            }
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveOrUpdateAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveOrUpdateAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long saveAllIgnoreExist(SqlToyContext sqlToyContext, List<?> entities, final int batchSize, final ReflectPropsHandler reflectPropsHandler, DataSource dataSource, final Boolean autoCommit) {
        if (entities == null || entities.isEmpty()) {
            this.logger.warn("saveAllIgnoreExist entities is null or empty,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entities.get(0).getClass()).getName(), "saveAllNotExist:[" + entities.size() + "]\u6761\u8bb0\u5f55!", sqlToyContext.isDebug());
            List result = ParallelUtils.execute(sqlToyContext, entities, true, dataSource, (context, batchModel) -> {
                final ShardingModel shardingModel = batchModel.getShardingModel();
                Long updateCnt = (Long)DataSourceUtils.processDataSource(context, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                    @Override
                    public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                        SqlExecuteStat.setDialect(dialect);
                        this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).saveAllIgnoreExist(context, batchModel.getEntities(), batchSize, reflectPropsHandler, conn, dbType, dialect, autoCommit, shardingModel.getTableName()));
                    }
                });
                ArrayList<Long> tmp = new ArrayList<Long>();
                tmp.add(updateCnt);
                return tmp;
            });
            long updateTotalCnt = 0L;
            if (result != null) {
                for (Long cnt : result) {
                    updateTotalCnt += cnt.longValue();
                }
            }
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveAllIgnoreExist\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveAllIgnoreExist\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public <T extends Serializable> T load(final SqlToyContext sqlToyContext, final T entity, final Class[] cascadeTypes, final LockMode lockMode, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("load entity is null,please check!");
            return null;
        }
        try {
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, entity, false, dataSource);
            SqlExecuteStat.start(BeanUtil.getEntityClass(entity.getClass()).getName(), "load", sqlToyContext.isDebug());
            Serializable serializable = (Serializable)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).load(sqlToyContext, entity, cascadeTypes == null ? null : CollectionUtil.arrayToList(cascadeTypes), lockMode, conn, dbType, dialect, shardingModel.getTableName()));
                }
            });
            return (T)serializable;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public <T extends Serializable> List<T> loadAll(SqlToyContext sqlToyContext, List<T> entities, final Class[] cascadeTypes, final LockMode lockMode, DataSource dataSource) {
        if (entities == null || entities.isEmpty()) {
            this.logger.warn("loadAll entities is null or empty,please check!");
            return entities;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(((Serializable)entities.get(0)).getClass()).getName(), "loadAll:[" + entities.size() + "]\u6761\u8bb0\u5f55!", sqlToyContext.isDebug());
            int batchSize = SqlToyConstants.getLoadAllBatchSize();
            if (batchSize > 1000 || batchSize < 1) {
                batchSize = 1000;
            }
            int totalSize = entities.size();
            int batch = (totalSize + batchSize - 1) / batchSize;
            ArrayList result = new ArrayList();
            for (int i = 0; i < batch; ++i) {
                List<T> batchEntities = entities.subList(i * batchSize, i == batch - 1 ? totalSize : (i + 1) * batchSize);
                result.addAll(ParallelUtils.execute(sqlToyContext, batchEntities, false, dataSource, (context, batchModel) -> {
                    final ShardingModel shardingModel = batchModel.getShardingModel();
                    return (List)DataSourceUtils.processDataSource(context, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                        @Override
                        public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                            SqlExecuteStat.setDialect(dialect);
                            this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).loadAll(context, batchModel.getEntities(), cascadeTypes == null ? null : CollectionUtil.arrayToList(cascadeTypes), lockMode, conn, dbType, dialect, shardingModel.getTableName(), DialectFactory.this.getFetchSize(-1), -1));
                        }
                    });
                }));
            }
            SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "\u67e5\u8be2\u7ed3\u679c\u8bb0\u5f55:{} \u6761!", result.size());
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Serializable save(final SqlToyContext sqlToyContext, final Serializable entity, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("save entity is null,please check!");
            return null;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entity.getClass()).getName(), "save", sqlToyContext.isDebug());
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, entity, true, dataSource);
            Serializable result = (Serializable)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).save(sqlToyContext, entity, conn, dbType, dialect, shardingModel.getTableName()));
                }
            });
            SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "\u5355\u5bf9\u8c61\u4fdd\u5b58\u8fd4\u56de\u4e3b\u952e\u503c:{}", result);
            Serializable serializable = result;
            return serializable;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, final int batchSize, final ReflectPropsHandler reflectPropsHandler, DataSource dataSource, final Boolean autoCommit) {
        if (entities == null || entities.isEmpty()) {
            this.logger.warn("saveAll entities is null or empty,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entities.get(0).getClass()).getName(), "saveAll:[" + entities.size() + "]\u6761\u8bb0\u5f55!", sqlToyContext.isDebug());
            List result = ParallelUtils.execute(sqlToyContext, entities, true, dataSource, (context, batchModel) -> {
                final ShardingModel shardingModel = batchModel.getShardingModel();
                Long updateCnt = (Long)DataSourceUtils.processDataSource(context, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                    @Override
                    public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                        SqlExecuteStat.setDialect(dialect);
                        this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).saveAll(context, batchModel.getEntities(), batchSize, reflectPropsHandler, conn, dbType, dialect, autoCommit, shardingModel.getTableName()));
                    }
                });
                ArrayList<Long> tmp = new ArrayList<Long>();
                tmp.add(updateCnt);
                return tmp;
            });
            long updateTotalCnt = 0L;
            if (result != null) {
                for (Long cnt : result) {
                    updateTotalCnt += cnt.longValue();
                }
            }
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{}\u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "saveAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{}\u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long update(final SqlToyContext sqlToyContext, final Serializable entity, final String[] forceUpdateFields, final boolean cascade, final Class[] forceCascadeClass, final HashMap<Class, String[]> subTableForceUpdateProps, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("update entity is null,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entity.getClass()).getName(), "update", sqlToyContext.isDebug());
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, entity, false, dataSource);
            Long updateTotalCnt = (Long)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).update(sqlToyContext, entity, forceUpdateFields, cascade, forceCascadeClass, subTableForceUpdateProps, conn, dbType, dialect, shardingModel.getTableName()));
                }
            });
            SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "update\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Serializable updateSaveFetch(final SqlToyContext sqlToyContext, final Serializable entity, final UpdateRowHandler updateRowHandler, final String[] uniqueProps, DataSource dataSource) {
        if (entity == null || updateRowHandler == null) {
            this.logger.warn("updateSaveFetch entity or updateRowHandler is null,please check!");
            return null;
        }
        try {
            Serializable result;
            SqlExecuteStat.start(BeanUtil.getEntityClass(entity.getClass()).getName(), "updateSaveFetch", sqlToyContext.isDebug());
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, entity, false, dataSource);
            Serializable serializable = result = (Serializable)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).updateSaveFetch(sqlToyContext, entity, updateRowHandler, uniqueProps, conn, dbType, dialect, shardingModel.getTableName()));
                }
            });
            return serializable;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long updateAll(SqlToyContext sqlToyContext, List<?> entities, final int batchSize, final String[] uniqueFields, final String[] forceUpdateFields, final ReflectPropsHandler reflectPropsHandler, DataSource dataSource, final Boolean autoCommit) {
        if (entities == null || entities.isEmpty()) {
            this.logger.warn("updateAll entities is null or empty,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entities.get(0).getClass()).getName(), "updateAll:[" + entities.size() + "]\u6761\u8bb0\u5f55!", sqlToyContext.isDebug());
            List result = ParallelUtils.execute(sqlToyContext, entities, false, dataSource, (context, batchModel) -> {
                final ShardingModel shardingModel = batchModel.getShardingModel();
                Long updateCnt = (Long)DataSourceUtils.processDataSource(context, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                    @Override
                    public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                        SqlExecuteStat.setDialect(dialect);
                        this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).updateAll(context, batchModel.getEntities(), batchSize, uniqueFields, forceUpdateFields, reflectPropsHandler, conn, dbType, dialect, autoCommit, shardingModel.getTableName()));
                    }
                });
                ArrayList<Long> tmp = new ArrayList<Long>();
                tmp.add(updateCnt);
                return tmp;
            });
            long updateTotalCnt = 0L;
            if (result != null) {
                for (Long cnt : result) {
                    updateTotalCnt += cnt.longValue();
                }
            }
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "updateAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "updateAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public Long delete(final SqlToyContext sqlToyContext, final Serializable entity, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("delete entity is null,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(entity.getClass()).getName(), "delete", sqlToyContext.isDebug());
            final ShardingModel shardingModel = ShardingUtils.getSharding(sqlToyContext, entity, false, dataSource);
            Long updateTotalCnt = (Long)DataSourceUtils.processDataSource(sqlToyContext, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).delete(sqlToyContext, entity, conn, dbType, dialect, shardingModel.getTableName()));
                }
            });
            SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "\u5355\u8bb0\u5f55\u5220\u9664\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public <T extends Serializable> Long deleteAll(SqlToyContext sqlToyContext, List<T> entities, final int batchSize, DataSource dataSource, final Boolean autoCommit) {
        if (entities == null || entities.isEmpty()) {
            this.logger.warn("deleteAll entities is null or empty,please check!");
            return 0L;
        }
        try {
            SqlExecuteStat.start(BeanUtil.getEntityClass(((Serializable)entities.get(0)).getClass()).getName(), "deleteAll:[" + entities.size() + "]\u6761\u8bb0\u5f55!", sqlToyContext.isDebug());
            List result = ParallelUtils.execute(sqlToyContext, entities, false, dataSource, (context, batchModel) -> {
                final ShardingModel shardingModel = batchModel.getShardingModel();
                Long updateCnt = (Long)DataSourceUtils.processDataSource(context, shardingModel.getDataSource(), new DataSourceCallbackHandler(){

                    @Override
                    public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                        SqlExecuteStat.setDialect(dialect);
                        this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).deleteAll(context, batchModel.getEntities(), batchSize, conn, dbType, dialect, autoCommit, shardingModel.getTableName()));
                    }
                });
                ArrayList<Long> tmp = new ArrayList<Long>();
                tmp.add(updateCnt);
                return tmp;
            });
            long updateTotalCnt = 0L;
            if (result != null) {
                for (Long cnt : result) {
                    updateTotalCnt += cnt.longValue();
                }
            }
            if (updateTotalCnt > (long)sqlToyContext.getUpdateTipCount()) {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "deleteAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", updateTotalCnt, sqlToyContext.getUpdateTipCount());
            } else {
                SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "deleteAll\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", updateTotalCnt);
            }
            Long l = updateTotalCnt;
            return l;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public QueryResult updateFetch(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final UpdateRowHandler updateRowHandler, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        try {
            Long startTime = System.currentTimeMillis();
            SqlExecuteStat.start(sqlToyConfig.getId(), "updateFetch", sqlToyConfig.isShowSql());
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
            QueryResult result = (QueryResult)DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, false);
                    SqlToyResult queryParam = SqlConfigParseUtils.processSql(realSqlToyConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, realSqlToyConfig), dialect);
                    queryParam = DialectUtils.doInterceptors(sqlToyContext, realSqlToyConfig, OperateType.fetchUpdate, queryParam, null, dbType);
                    QueryResult queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).updateFetch(sqlToyContext, realSqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), updateRowHandler, conn, dbType, dialect, extend.lockMode == null ? LockMode.UPGRADE : extend.lockMode, DialectFactory.this.getFetchSize(extend.fetchSize), extend.maxRows);
                    if (extend.resultType != null) {
                        queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), (Class)extend.resultType, false, extend.humpMapLabel, extend.hiberarchy, extend.hiberarchyClasses, extend.fieldsMap));
                    }
                    if (queryResult.getRecordCount() > (long)sqlToyContext.getUpdateTipCount()) {
                        SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "updateFetch\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", queryResult.getRecordCount(), sqlToyContext.getUpdateTipCount());
                    } else {
                        SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "updateFetch\u64cd\u4f5c\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", queryResult.getRecordCount());
                    }
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = result;
            return queryResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public StoreResult executeStore(final SqlToyContext sqlToyContext, final SqlToyConfig sqlToyConfig, final Object[] inParamsValue, final Integer[] outParamsType, final Class resultType, DataSource dataSource) {
        try {
            Long startTime = System.currentTimeMillis();
            SqlExecuteStat.start(sqlToyConfig.getId(), "executeStore", sqlToyConfig.isShowSql());
            StoreResult result = (StoreResult)DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

                @Override
                public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    String dialectSql = sqlToyConfig.getSql(dialect);
                    int inCount = inParamsValue == null ? 0 : inParamsValue.length;
                    int outCount = outParamsType == null ? 0 : outParamsType.length;
                    int paramCnt = StringUtil.matchCnt(dialectSql, ARG_PATTERN);
                    if (paramCnt != inCount + outCount) {
                        throw new IllegalArgumentException("\u5b58\u50a8\u8fc7\u7a0b\u8bed\u53e5\u4e2d\u7684\u8f93\u5165\u548c\u8f93\u51fa\u53c2\u6570\u8ddf\u5b9e\u9645\u8c03\u7528\u4f20\u9012\u7684\u6570\u91cf\u4e0d\u7b49!");
                    }
                    SqlToyResult sqlToyResult = new SqlToyResult(dialectSql, inParamsValue);
                    boolean isFirstResult = StringUtil.matches(dialectSql, STORE_PATTERN);
                    SqlConfigParseUtils.replaceNull(sqlToyResult, isFirstResult ? 1 : 0);
                    SqlExecuteStat.showSql("\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c", sqlToyResult.getSql(), sqlToyResult.getParamsValue());
                    StoreResult queryResult = DialectFactory.this.getDialectSqlWrapper(dbType).executeStore(sqlToyContext, sqlToyConfig, sqlToyResult.getSql(), sqlToyResult.getParamsValue(), outParamsType, conn, dbType, dialect, -1);
                    QueryExecutor queryExecutor = new QueryExecutor(null, sqlToyConfig.getParamsName(), inParamsValue);
                    List pivotCategorySet = ResultUtils.getPivotCategory(sqlToyContext, sqlToyConfig, queryExecutor, conn, dbType, dialect);
                    boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), sqlToyConfig, queryResult, pivotCategorySet, null);
                    if (resultType != null) {
                        queryResult.setRows(ResultUtils.wrapQueryResult(sqlToyContext, queryResult.getRows(), queryResult.getLabelNames(), resultType, changedCols, null, false, null, null));
                    }
                    if (queryResult.getRecordCount() > (long)sqlToyContext.getUpdateTipCount()) {
                        SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "executeStore\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761,\u5927\u4e8e\u6570\u636e\u4fee\u6539\u63d0\u793a\u9608\u503c:{}\u6761!", queryResult.getRecordCount(), sqlToyContext.getUpdateTipCount());
                    } else {
                        SqlExecuteStat.debug("\u6267\u884c\u7ed3\u679c", "executeStore\u5f71\u54cd\u8bb0\u5f55\u91cf:{} \u6761!", queryResult.getRecordCount());
                    }
                    this.setResult(queryResult);
                }
            });
            result.setExecuteTime(System.currentTimeMillis() - startTime);
            StoreResult storeResult = result;
            return storeResult;
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public void fetchStream(final SqlToyContext sqlToyContext, final QueryExecutor queryExecutor, final SqlToyConfig sqlToyConfig, final StreamResultHandler streamResultHandler, DataSource dataSource) {
        final QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (StringUtil.isBlank(extend.sql)) {
            throw new IllegalArgumentException("fetchStream operate sql is null!");
        }
        try {
            QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
            SqlExecuteStat.start(sqlToyConfig.getId(), "fetchStream", extend.showSql != null ? extend.showSql : sqlToyConfig.isShowSql());
            DataSourceUtils.processDataSource(sqlToyContext, ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, queryExecutor, dataSource), new DataSourceCallbackHandler(){

                @Override
                public void doConnection(final Connection conn, final Integer dbType, String dialect) throws Exception {
                    SqlExecuteStat.setDialect(dialect);
                    SqlToyConfig realSqlToyConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyConfig, queryExecutor, dialect, false);
                    SqlToyResult queryParam = SqlConfigParseUtils.processSql(realSqlToyConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, realSqlToyConfig), dialect);
                    queryParam = DialectUtils.doInterceptors(sqlToyContext, realSqlToyConfig, OperateType.search, queryParam, null, dbType);
                    String lastSql = SqlUtilsExt.signSql(queryParam.getSql(), dbType, realSqlToyConfig);
                    final Object[] paramsValue = queryParam.getParamsValue();
                    SqlExecuteStat.showSql("\u6267\u884c\u67e5\u8be2", lastSql, paramsValue);
                    PreparedStatement pst = conn.prepareStatement(lastSql, 1003, 1007);
                    if (extend.fetchSize != -1) {
                        pst.setFetchSize(extend.fetchSize);
                    } else if (dbType == 40 || dbType == 42) {
                        pst.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        pst.setFetchSize(1000);
                    }
                    pst.setFetchDirection(1000);
                    ResultSet rs = null;
                    SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

                        @Override
                        public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws Exception {
                            SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, paramsValue, null, 0);
                            rs = pst.executeQuery();
                            ResultUtils.consumeResult(sqlToyContext, extend, sqlToyConfig, conn, rs, streamResultHandler, (Class)extend.resultType, extend.humpMapLabel, extend.fieldsMap);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            throw new DataAccessException(e);
        }
        finally {
            SqlExecuteStat.destroy();
        }
    }

    public List<ColumnMeta> getTableColumns(SqlToyContext sqlToyContext, final String catalog, final String schema, final String tableName, DataSource dataSource) {
        if (StringUtil.isBlank(tableName)) {
            throw new IllegalArgumentException("getTableColumns method tableName is null,please check!");
        }
        return (List)DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

            @Override
            public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).getTableColumns(catalog, schema, tableName, conn, dbType, dialect));
            }
        });
    }

    public List<TableMeta> getTables(SqlToyContext sqlToyContext, final String catalog, final String schema, final String tableName, DataSource dataSource) {
        return (List)DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

            @Override
            public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                this.setResult(DialectFactory.this.getDialectSqlWrapper(dbType).getTables(catalog, schema, tableName, conn, dbType, dialect));
            }
        });
    }

    private int getFetchSize(int fetchSize) {
        if (fetchSize > 0) {
            return fetchSize;
        }
        return SqlToyConstants.FETCH_SIZE;
    }

    private DecryptHandler wrapDecryptHandler(SqlToyContext sqlToyContext, Type resultType) {
        if (resultType == null || resultType.equals(Map.class) || resultType.equals(HashMap.class) || resultType.equals(List.class)) {
            return null;
        }
        FieldsSecureProvider fieldsSecureProvider = sqlToyContext.getFieldsSecureProvider();
        if (fieldsSecureProvider == null) {
            return null;
        }
        EntityMeta entityMeta = null;
        if (sqlToyContext.isEntity((Class)resultType)) {
            entityMeta = sqlToyContext.getEntityMeta((Class)resultType);
        }
        if (entityMeta == null || entityMeta.getSecureColumns() == null) {
            return null;
        }
        return new DecryptHandler(fieldsSecureProvider, entityMeta.getSecureColumns());
    }
}

