/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.functions.OLuceneNearFunction;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OLuceneFunctionsFactory
implements OSQLFunctionFactory {
    private static final Map<String, Object> FUNCTIONS = new HashMap<String, Object>();

    public boolean hasFunction(String iName) {
        return FUNCTIONS.containsKey(iName);
    }

    public Set<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    public OSQLFunction createFunction(String name) throws OCommandExecutionException {
        Object obj = FUNCTIONS.get(name);
        if (obj == null) {
            throw new OCommandExecutionException("Unknown function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors", (Throwable)e);
        }
    }

    public static void register(String iName, Object iImplementation) {
        FUNCTIONS.put(iName.toLowerCase(), iImplementation);
    }

    static {
        OLuceneFunctionsFactory.register("near", OLuceneNearFunction.class);
    }
}

