/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.ORemoteConnectionPool;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelListener;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ORemoteConnectionPushListener
implements ORemoteServerEventListener {
    private Set<ORemoteServerEventListener> listeners = Collections.synchronizedSet(new HashSet());
    private ConcurrentMap<ORemoteServerEventListener, Set<OChannelBinaryAsynchClient>> conns = new ConcurrentHashMap<ORemoteServerEventListener, Set<OChannelBinaryAsynchClient>>();

    public void addListener(final ORemoteConnectionPool pool, final OChannelBinaryAsynchClient connection, final OStorageRemoteAsynchEventListener listener) {
        Set putRet;
        this.listeners.add(listener);
        Set<OChannelBinaryAsynchClient> ans = (Set<OChannelBinaryAsynchClient>)this.conns.get(listener);
        if (ans == null && (putRet = this.conns.putIfAbsent(listener, ans = Collections.synchronizedSet(new HashSet()))) != null) {
            ans = putRet;
        }
        if (!ans.contains((Object)connection)) {
            ans.add(connection);
            connection.registerListener(new OChannelListener(){

                public void onChannelClose(OChannel iChannel) {
                    Set all = (Set)ORemoteConnectionPushListener.this.conns.get(listener);
                    all.remove(iChannel);
                    if (all.isEmpty()) {
                        listener.onEndUsedConnections(pool);
                    }
                    connection.unregisterListener(this);
                }
            });
        }
    }

    public void removeListener(ORemoteServerEventListener listener) {
        this.listeners.remove(listener);
    }

    public void onRequest(byte iRequestCode, Object obj) {
        for (ORemoteServerEventListener listener : this.listeners) {
            listener.onRequest(iRequestCode, obj);
        }
    }
}

