/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    private static final String CLASS_NAME = OracleTypeCOLLECTION.class.getName();
    int userCode = 0;
    long maxSize = 0L;
    OracleType elementType = null;
    private int collectionFlag = 0;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_SYNONYM_10g = 2;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
    static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
    static final int POSSIBLY_OTHER_USER_OBJECT = 5;
    static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
    static final int OTHER_USER_OBJECT = 7;
    static final int OTHER_USER_SYNONYM = 8;
    static final int PUBLIC_SYNONYM = 9;
    static final int PUBLIC_SYNONYM_10g = 10;
    static final int BREAK = 11;
    static final String[] sqlString = new String[]{"SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME = :1", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM USER_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM USER_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM ALL_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM ALL_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = :1 AND TYPE_NAME = :2", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = (SELECT DISTINCT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT DISTINCT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); BEGIN  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); BEGIN  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};

    public OracleTypeCOLLECTION(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, (Connection)conn);
    }

    public OracleTypeCOLLECTION(OracleTypeADT parent, int idx, OracleConnection conn) throws SQLException {
        super(parent, idx, (Connection)conn);
    }

    public OracleTypeCOLLECTION(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        super(sqlName, typoid, version, tds, conn);
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (value != null) {
            if (value instanceof ARRAY) {
                return (Datum)value;
            }
            ArrayDescriptor desc = this.createArrayDescriptor();
            return new ARRAY(desc, this.connection, value);
        }
        return null;
    }

    @Override
    public int getTypeCode() {
        return 2003;
    }

    @Override
    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        if (anOracleType == null) {
            return false;
        }
        if (anOracleType == this) {
            return true;
        }
        if (anOracleType.getClass() != this.getClass()) {
            return false;
        }
        return anOracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        long elementPos = tdsReader.readLong();
        this.maxSize = tdsReader.readLong();
        this.userCode = tdsReader.readByte();
        tdsReader.addSimplePatch(elementPos, this);
    }

    @Override
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        return this.unlinearize(pickled_bytes, offset, container, 1L, -1, type, objmap);
    }

    @Override
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        OracleConnection mc = this.getConnection();
        Datum ret = null;
        if (mc == null) {
            ret = this.unlinearizeInternal(pickled_bytes, offset, container, idx, cnt, style, objmap);
        } else {
            try (Monitor.CloseableLock lock = mc.acquireCloseableLock();){
                ret = this.unlinearizeInternal(pickled_bytes, offset, container, idx, cnt, style, objmap);
            }
        }
        return ret;
    }

    public Datum unlinearizeInternal(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pickled_bytes == null) {
                Datum datum = null;
                return datum;
            }
            PickleContext context = new PickleContext(pickled_bytes, offset);
            Datum datum = (Datum)((Object)this.unpickle81(context, (OracleArray)((Object)container), idx, cnt, 1, style, objmap));
            return datum;
        }
    }

    public boolean isInlineImage(byte[] pickled_bytes, int offset) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pickled_bytes == null) {
                boolean bl = false;
                return bl;
            }
            if (PickleContext.isCollectionImage_pctx(pickled_bytes[offset])) {
                boolean bl = true;
                return bl;
            }
            if (PickleContext.isDegenerateImage_pctx(pickled_bytes[offset])) {
                boolean bl = false;
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image").fillInStackTrace();
        }
    }

    @Override
    protected int pickle81(PickleContext ctx, Datum datum) throws SQLException {
        OracleArray data = (OracleArray)((Object)datum);
        boolean inline = data.hasDataSeg();
        int imglen = 0;
        int lenOffset = ctx.offset() + 2;
        if (inline) {
            if (!this.metaDataInitialized) {
                this.copy_properties((OracleTypeCOLLECTION)data.getDescriptor().getPickler());
            }
            Datum[] dataValues = data.getOracleArray();
            if (this.userCode == 3 && (long)dataValues.length > this.maxSize) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 71, null).fillInStackTrace();
            }
            ctx.setCollectionUserCode(this.userCode);
            imglen += ctx.writeCollImageHeader(dataValues.length, this.typeVersion);
            int ctr = 0;
            while (ctr < dataValues.length) {
                if (this.userCode == 1) {
                    AssociativeArrayEntry entry = (AssociativeArrayEntry)dataValues[ctr];
                    Integer index = (Integer)entry.getKey();
                    imglen += ctx.writeUB4(index);
                    Datum value = (Datum)((AssociativeArrayEntry)dataValues[ctr]).getValue();
                    imglen = value == null ? (imglen += ctx.writeElementNull()) : (imglen += this.elementType.pickle81(ctx, value));
                } else {
                    imglen = dataValues[ctr] == null ? (imglen += ctx.writeElementNull()) : (imglen += this.elementType.pickle81(ctx, dataValues[ctr]));
                }
                int idx = ctr++;
                this.debugp(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "pickle81", "idx={0}, bytes={1}", null, null, () -> new Object[]{idx, dataValues[idx] == null ? null : Parameter.arg(Format.Style.BYTE_ARRAY_CLONE, dataValues[idx].shareBytes(), new long[0])});
            }
        } else {
            imglen += ctx.writeCollImageHeader(data.getLocator());
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "pickle81", "imglen={0}", (String)null, null, (Object)imglen);
        ctx.patchImageLen(lenOffset, imglen);
        return imglen;
    }

    OracleArray unpickle81(PickleContext context, OracleArray container, int style, int elemStyle, Map elemMap) throws SQLException {
        return this.unpickle81(context, container, 1L, -1, style, elemStyle, elemMap);
    }

    OracleArray unpickle81(PickleContext context, OracleArray container, long beginIdx, int count, int style, int elemStyle, Map elemMap) throws SQLException {
        OracleArray coll_obj = container;
        if (coll_obj == null) {
            ArrayDescriptor desc = this.createArrayDescriptor();
            coll_obj = new ARRAY(desc, (byte[])null, this.connection);
        }
        if (this.unpickle81ImgHeader(context, coll_obj, style, elemStyle)) {
            this.collectionFlag = context.readByte();
            context.setCollectionUserCode(this.collectionFlag);
            if (beginIdx == 1L && count == -1) {
                this.unpickle81ImgBody(context, coll_obj, elemStyle, elemMap);
            } else {
                this.unpickle81ImgBody(context, coll_obj, beginIdx, count, elemStyle, elemMap);
            }
        }
        return coll_obj;
    }

    boolean unpickle81ImgHeader(PickleContext context, OracleArray container, int style, int elemStyle) throws SQLException {
        boolean inline = true;
        if (style == 3) {
            container.setImage(context.image(), context.absoluteOffset(), 0L);
        }
        byte flags = context.readByte();
        if (!PickleContext.is81format(flags)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format").fillInStackTrace();
        }
        if (!PickleContext.hasPrefix(flags)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment").fillInStackTrace();
        }
        if (PickleContext.isCollectionImage_pctx(flags)) {
            inline = true;
        } else if (PickleContext.isDegenerateImage_pctx(flags)) {
            inline = false;
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image").fillInStackTrace();
        }
        context.readByte();
        if (style == 9) {
            context.skipBytes(context.readLength(true) - 2);
            return false;
        }
        if (style == 3) {
            long length = context.readLength();
            container.setImageLength(length);
            context.skipTo(container.getImageOffset() + length);
            return false;
        }
        context.skipLength();
        int psegLen = context.readLength();
        container.setPrefixFlag(context.readByte());
        if (container.isInline()) {
            context.readDataValue(psegLen - 1);
        } else {
            container.setLocator(context.readDataValue(psegLen - 1));
        }
        return container.isInline();
    }

    void unpickle81ImgBody(PickleContext context, OracleArray container, long beginIdx, int count, int elemStyle, Map elemMap) throws SQLException {
        boolean cacheAll;
        int coll_len = context.readLength();
        container.setLength(coll_len);
        if (elemStyle == 0) {
            return;
        }
        int length = (int)this.getAccessLength(coll_len, beginIdx, count);
        boolean bl = cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
        if (beginIdx > 1L && length > 0) {
            long lastIdx = container.getLastIndex();
            if (lastIdx < beginIdx) {
                if (lastIdx > 0L) {
                    context.skipTo(container.getLastOffset());
                } else {
                    lastIdx = 1L;
                }
                if (cacheAll) {
                    for (long i = lastIdx; i < beginIdx; ++i) {
                        container.setIndexOffset(i, context.offset());
                        this.elementType.unpickle81rec(context, 9, null);
                    }
                } else {
                    for (long i = lastIdx; i < beginIdx; ++i) {
                        this.elementType.unpickle81rec(context, 9, null);
                    }
                }
            } else if (lastIdx > beginIdx) {
                long offset = container.getOffset(beginIdx);
                if (offset != -1L) {
                    context.skipTo(offset);
                } else if (cacheAll) {
                    int i = 1;
                    while ((long)i < beginIdx) {
                        container.setIndexOffset(i, context.offset());
                        this.elementType.unpickle81rec(context, 9, null);
                        ++i;
                    }
                } else {
                    int i = 1;
                    while ((long)i < beginIdx) {
                        this.elementType.unpickle81rec(context, 9, null);
                        ++i;
                    }
                }
            } else {
                context.skipTo(container.getLastOffset());
            }
            container.setLastIndexOffset(beginIdx, context.offset());
        }
        this.unpickle81ImgBodyElements(context, container, (int)beginIdx, length, elemStyle, elemMap);
    }

    void unpickle81ImgBody(PickleContext context, OracleArray container, int elemStyle, Map elemMap) throws SQLException {
        int length = context.readLength();
        container.setLength(length);
        if (elemStyle == 0) {
            return;
        }
        this.unpickle81ImgBodyElements(context, container, 1, length, elemStyle, elemMap);
    }

    private void unpickle81ImgBodyElements(PickleContext context, OracleArray container, int beginIdx, int length, int elemStyle, Map elemMap) throws SQLException {
        boolean cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
        switch (elemStyle) {
            case 1: {
                Datum[] datumArray = new Datum[length];
                if (cacheAll) {
                    for (int i = 0; i < length; ++i) {
                        container.setIndexOffset(beginIdx + i, context.offset());
                        datumArray[i] = (Datum)this.elementType.unpickle81rec(context, elemStyle, elemMap);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        datumArray[i] = (Datum)this.elementType.unpickle81rec(context, elemStyle, elemMap);
                    }
                }
                container.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] darray = ArrayDescriptor.makeJavaArray(length, this.elementType.getTypeCode());
                HashMap<Integer, Object> javaMap = null;
                if (this.userCode == 1) {
                    javaMap = new HashMap<Integer, Object>();
                }
                if (cacheAll) {
                    for (int i = 0; i < length; ++i) {
                        if (this.collectionFlag == PickleContext.KOPI20_CF_INDX) {
                            Integer index = new Integer((int)context.readUB4());
                            container.setIndexOffset(beginIdx + i, context.offset());
                            darray[i] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                            if (javaMap == null) continue;
                            javaMap.put(index, darray[i]);
                            continue;
                        }
                        container.setIndexOffset(beginIdx + i, context.offset());
                        darray[i] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        if (this.collectionFlag == PickleContext.KOPI20_CF_INDX) {
                            Integer index = new Integer((int)context.readUB4());
                            darray[i] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                            if (javaMap == null) continue;
                            javaMap.put(index, darray[i]);
                            continue;
                        }
                        darray[i] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                    }
                }
                container.setObjArray(darray);
                container.setJavaMap(javaMap);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                    container.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(context, 1L, length, elemStyle));
                    break;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection").fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType).fillInStackTrace();
            }
        }
        container.setLastIndexOffset(beginIdx + length, context.offset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollElemTypeName() throws SQLException {
        if (this.connection == null) {
            return;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.sqlName == null) {
                this.getFullName();
            }
            Statement cstmt = null;
            Statement ps = null;
            ResultSet rs = null;
            this.connection.beginNonRequestCalls();
            try {
                int state;
                int n = state = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
                while (state != 11) {
                    switch (state) {
                        case 0: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try CURRENT_USER_OBJECT, bind: {0}, state: {1}", (String)null, null, (Object)this.sqlName.getSimpleName(), (Object)state);
                            ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                            ps.setString(1, this.sqlName.getSimpleName());
                            ps.setFetchSize(1);
                            rs = ps.executeQuery();
                            state = 5;
                            break;
                        }
                        case 1: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                state = 2;
                            }
                        }
                        case 2: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try CURRENT_USER_SYNONYM, bind: {0}, state: {1}", (String)null, null, (Object)this.sqlName.getSimpleName(), (Object)state);
                            cstmt = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[state]);
                            cstmt.setString(1, this.sqlName.getSimpleName());
                            cstmt.setString(3, this.sqlName.getSimpleName());
                            cstmt.registerOutParameter(2, -10);
                            cstmt.execute();
                            rs = ((OracleCallableStatement)cstmt).getCursor(2);
                            rs.setFetchSize(1);
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                state = 4;
                            }
                        }
                        case 4: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try CURRENT_USER_PUBLIC_SYNONYM, bind: {0}, state: {1}", (String)null, null, (Object)this.sqlName.getSimpleName(), (Object)state);
                            ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                            ps.setString(1, this.sqlName.getSimpleName());
                            ps.setString(2, this.sqlName.getSimpleName());
                            ps.setFetchSize(1);
                            rs = ps.executeQuery();
                            state = 8;
                            break;
                        }
                        case 5: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                state = 6;
                            }
                        }
                        case 6: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try POSSIBLY_OTHER_USER_OBJECT, bind: {0}, state: {1}", (String)null, null, (Object)this.sqlName.getSimpleName(), (Object)state);
                            cstmt = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[state]);
                            cstmt.setString(1, this.sqlName.getSimpleName());
                            cstmt.setString(3, this.sqlName.getSimpleName());
                            cstmt.registerOutParameter(2, -10);
                            cstmt.execute();
                            rs = ((OracleCallableStatement)cstmt).getCursor(2);
                            rs.setFetchSize(1);
                            state = 1;
                            break;
                        }
                        case 7: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try OTHER_USER_OBJECT, bind: schema={0} simpleName={1}, state: {2}", (String)null, null, (Object)this.sqlName.getSchema(), (Object)this.sqlName.getSimpleName(), (Object)state);
                            ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                            ps.setString(1, this.sqlName.getSchema());
                            ps.setString(2, this.sqlName.getSimpleName());
                            ps.setFetchSize(1);
                            rs = ps.executeQuery();
                            state = 8;
                            break;
                        }
                        case 8: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try OTHER_USER_SYNONYM, bind: {0}, state: {1}", (String)null, null, (Object)this.sqlName.getSimpleName(), (Object)state);
                            ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                            ps.setString(1, this.sqlName.getSimpleName());
                            ps.setString(2, this.sqlName.getSimpleName());
                            ps.setFetchSize(1);
                            rs = ps.executeQuery();
                            state = 9;
                            break;
                        }
                        case 9: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                state = 10;
                            }
                        }
                        case 10: {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCollElemTypeName", "try PUBLIC_SYNONYM, bind: {0}, state: {1}", (String)null, null, (Object)this.sqlName.getSimpleName(), (Object)state);
                            cstmt = this.connection.prepareCall(this.getSqlHint() + sqlString[state]);
                            cstmt.setString(1, this.sqlName.getSimpleName());
                            cstmt.registerOutParameter(2, -10);
                            cstmt.execute();
                            rs = ((OracleCallableStatement)cstmt).getCursor(2);
                            state = 11;
                        }
                    }
                    if (rs != null && rs.next()) {
                        if (this.attrTypeNames == null) {
                            this.attrTypeNames = new String[1];
                        }
                        String owner = rs.getString(2);
                        String type = rs.getString(1);
                        this.attrTypeNames[0] = owner == null || owner.isEmpty() ? type : SQLName.getTypeName(owner, type);
                        state = 11;
                    } else if (state == 11) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (cstmt == null) continue;
                    cstmt.close();
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (cstmt != null) {
                    cstmt.close();
                }
                this.connection.endNonRequestCalls();
            }
        }
    }

    @Override
    public String getAttributeName(int idx) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
    }

    @Override
    public String getAttributeName(int idx, boolean force) throws SQLException {
        return this.getAttributeName(idx);
    }

    @Override
    public String getAttributeType(int idx) throws SQLException {
        if (idx != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.attrTypeNames[0];
    }

    @Override
    public String getAttributeType(int idx, boolean force) throws SQLException {
        if (force) {
            return this.getAttributeType(idx);
        }
        if (idx != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (this.sqlName != null && this.attrTypeNames != null) {
            return this.attrTypeNames[0];
        }
        return null;
    }

    @Override
    public int getNumAttrs() throws SQLException {
        return 0;
    }

    @Override
    public OracleType getAttrTypeAt(int idx) throws SQLException {
        return null;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        return new ArrayDescriptor(this, (Connection)this.connection);
    }

    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        }
        return (ArrayDescriptor)this.descriptor;
    }

    public OracleType getElementType() throws SQLException {
        return this.elementType;
    }

    public int getUserCode() throws SQLException {
        return this.userCode;
    }

    public long getMaxLength() throws SQLException {
        return this.maxSize;
    }

    private long getAccessLength(long coll_len, long beginIdx, int count) throws SQLException {
        if (beginIdx > coll_len) {
            return 0L;
        }
        if (count < 0) {
            return coll_len - beginIdx + 1L;
        }
        return Math.min(coll_len - beginIdx + 1L, (long)count);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.userCode);
        out.writeLong(this.maxSize);
        out.writeObject(this.elementType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.userCode = in.readInt();
        this.maxSize = in.readLong();
        this.elementType = (OracleType)in.readObject();
    }

    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        this.connection = conn;
        this.elementType.setConnection(conn);
    }

    @Override
    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.elementType != null) {
            this.elementType.initMetadataRecursively();
        }
    }

    @Override
    public void initChildNamesRecursively(Map typesMap) throws SQLException {
        TypeTreeElement element = (TypeTreeElement)typesMap.get(this.sqlName);
        if (this.elementType != null) {
            this.elementType.setNames(element.getChildSchemaName(0), element.getChildTypeName(0));
            this.elementType.initChildNamesRecursively(typesMap);
            this.elementType.cacheDescriptor();
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
        this.descriptor = ArrayDescriptor.createDescriptor(this);
    }

    @Override
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        this.printXML(pw, indent, false);
    }

    @Override
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        int i;
        for (i = 0; i < indent; ++i) {
            pw.print("  ");
        }
        pw.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" >");
        if (this.elementType != null) {
            this.elementType.printXML(pw, indent + 1, fetchAllMetaDataAsNeeded);
        }
        for (i = 0; i < indent; ++i) {
            pw.print("  ");
        }
        pw.println("</OracleTypeCOLLECTION>");
    }
}

