/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.time.DateTimeException;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Map;

public final class OracleTemporalField {
    public static final TemporalField SIGNED_YEAR_OF_ERA = Field.SIGNED_YEAR_OF_ERA;

    private OracleTemporalField() {
        throw new AssertionError((Object)"Not instantiable");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Field implements TemporalField
    {
        SIGNED_YEAR_OF_ERA{

            @Override
            public TemporalUnit getBaseUnit() {
                return ChronoUnit.YEARS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return ChronoUnit.FOREVER;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(-9223372036854775807L, Long.MAX_VALUE);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporal) {
                return temporal.isSupported(ChronoField.YEAR) && Field.isIso(temporal);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                if (!this.isSupportedBy(temporal)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: SignedYearOfEra");
                }
                return this.range();
            }

            @Override
            public long getFrom(TemporalAccessor temporal) {
                if (!this.isSupportedBy(temporal)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: SignedYearOfEra");
                }
                long year = temporal.getLong(ChronoField.YEAR);
                return year < 1L ? year - 1L : year;
            }

            @Override
            public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                long curValue = this.getFrom(temporal);
                if (newValue == 0L) {
                    throw new DateTimeException("0 is not a valid SignedYearOfEra");
                }
                return (R)temporal.with(ChronoField.YEAR, newValue < 1L ? newValue + 1L : newValue);
            }

            @Override
            public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
                Long signedYear = fieldValues.get(this);
                if (signedYear != null) {
                    if (signedYear == 0L) {
                        new DateTimeException("0 is not a valid SignedYearOfEra");
                    }
                    if (!Field.isIso(partialTemporal)) {
                        throw new DateTimeException("Resolve requires IsoChronology");
                    }
                    fieldValues.remove(this);
                    fieldValues.put(ChronoField.YEAR, signedYear < 1L ? signedYear + 1L : signedYear);
                }
                return null;
            }

            @Override
            public String toString() {
                return "SignedYearOfEra";
            }
        };


        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        private static boolean isIso(TemporalAccessor temporal) {
            return Chronology.from(temporal).equals(IsoChronology.INSTANCE);
        }
    }
}

