/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostPair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostPairRequest
extends BaseRequest<HostPair> {
    public HostPairRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPair.class);
    }

    @Nonnull
    public CompletableFuture<HostPair> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public HostPair get() throws ClientException {
        return (HostPair)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<HostPair> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public HostPair delete() throws ClientException {
        return (HostPair)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<HostPair> patchAsync(@Nonnull HostPair sourceHostPair) {
        return this.sendAsync(HttpMethod.PATCH, sourceHostPair);
    }

    @Nullable
    public HostPair patch(@Nonnull HostPair sourceHostPair) throws ClientException {
        return (HostPair)this.send(HttpMethod.PATCH, sourceHostPair);
    }

    @Nonnull
    public CompletableFuture<HostPair> postAsync(@Nonnull HostPair newHostPair) {
        return this.sendAsync(HttpMethod.POST, newHostPair);
    }

    @Nullable
    public HostPair post(@Nonnull HostPair newHostPair) throws ClientException {
        return (HostPair)this.send(HttpMethod.POST, newHostPair);
    }

    @Nonnull
    public CompletableFuture<HostPair> putAsync(@Nonnull HostPair newHostPair) {
        return this.sendAsync(HttpMethod.PUT, newHostPair);
    }

    @Nullable
    public HostPair put(@Nonnull HostPair newHostPair) throws ClientException {
        return (HostPair)this.send(HttpMethod.PUT, newHostPair);
    }

    @Nonnull
    public HostPairRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostPairRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

