/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.DirectoryDefinition;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryDefinitionRequest
extends BaseRequest<DirectoryDefinition> {
    public DirectoryDefinitionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryDefinition.class);
    }

    @Nonnull
    public CompletableFuture<DirectoryDefinition> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public DirectoryDefinition get() throws ClientException {
        return (DirectoryDefinition)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<DirectoryDefinition> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public DirectoryDefinition delete() throws ClientException {
        return (DirectoryDefinition)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<DirectoryDefinition> patchAsync(@Nonnull DirectoryDefinition sourceDirectoryDefinition) {
        return this.sendAsync(HttpMethod.PATCH, sourceDirectoryDefinition);
    }

    @Nullable
    public DirectoryDefinition patch(@Nonnull DirectoryDefinition sourceDirectoryDefinition) throws ClientException {
        return (DirectoryDefinition)this.send(HttpMethod.PATCH, sourceDirectoryDefinition);
    }

    @Nonnull
    public CompletableFuture<DirectoryDefinition> postAsync(@Nonnull DirectoryDefinition newDirectoryDefinition) {
        return this.sendAsync(HttpMethod.POST, newDirectoryDefinition);
    }

    @Nullable
    public DirectoryDefinition post(@Nonnull DirectoryDefinition newDirectoryDefinition) throws ClientException {
        return (DirectoryDefinition)this.send(HttpMethod.POST, newDirectoryDefinition);
    }

    @Nonnull
    public CompletableFuture<DirectoryDefinition> putAsync(@Nonnull DirectoryDefinition newDirectoryDefinition) {
        return this.sendAsync(HttpMethod.PUT, newDirectoryDefinition);
    }

    @Nullable
    public DirectoryDefinition put(@Nonnull DirectoryDefinition newDirectoryDefinition) throws ClientException {
        return (DirectoryDefinition)this.send(HttpMethod.PUT, newDirectoryDefinition);
    }

    @Nonnull
    public DirectoryDefinitionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

