/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.JndiRefDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.DataSource;

final class JndiRefForwardingDataSource
extends JndiRefDataSourceBase
implements DataSource {
    static final MLogger logger = MLog.getLogger(JndiRefForwardingDataSource.class);
    transient DataSource cachedInner;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    public JndiRefForwardingDataSource() {
        this(true);
    }

    public JndiRefForwardingDataSource(boolean bl) {
        super(bl);
        this.setUpPropertyListeners();
    }

    private void setUpPropertyListeners() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                Object object = propertyChangeEvent.getNewValue();
                if ("jndiName".equals(propertyChangeEvent.getPropertyName())) {
                    try {
                        C3P0ImplUtils.jndiAssertNameIsAcceptable(object);
                    }
                    catch (NamingException namingException) {
                        throw new PropertyVetoException(namingException.getMessage(), propertyChangeEvent);
                    }
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JndiRefForwardingDataSource.this.cachedInner = null;
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    private DataSource dereference() throws SQLException {
        Object object = this.getJndiName();
        Hashtable hashtable = this.getJndiEnv();
        try {
            C3P0ImplUtils.jndiAssertNameIsAcceptable(object);
            InitialContext initialContext = hashtable != null ? new InitialContext(hashtable) : new InitialContext();
            if (object instanceof String) {
                String string = (String)object;
                return (DataSource)initialContext.lookup(string);
            }
            if (object instanceof Name) {
                Name name = (Name)object;
                return (DataSource)initialContext.lookup(name);
            }
            throw new SQLException("Could not find ConnectionPoolDataSource with putative JNDI name, which is neither a String nor a javax.naming.Name: " + object);
        }
        catch (NamingException namingException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to look up a target DataSource via JNDI!", (Throwable)namingException);
            }
            throw SqlUtils.toSQLException((Throwable)namingException);
        }
    }

    private synchronized DataSource inner() throws SQLException {
        if (this.cachedInner != null) {
            return this.cachedInner;
        }
        DataSource dataSource = this.dereference();
        if (this.isCaching()) {
            this.cachedInner = dataSource;
        }
        return dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.inner().getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.inner().getConnection(string, string2);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.inner().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.inner().setLogWriter(printWriter);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.inner().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.inner().setLoginTimeout(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.setUpPropertyListeners();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException(this + " is not a Wrapper for " + clazz.getName());
    }
}

