/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FormTypeNodeLoadors.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/loadors/FormTypeNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.loadors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyExtension;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class FormTypeNodeLoadors extends NavTreeNodeChildLoador<String, WikittyExtension, VradiTreeNode> {

    /** Logger. */
    static private final Log log = LogFactory.getLog(FormTypeNodeLoadors.class);

    /** serialVersionUID. */
    private static final long serialVersionUID = 6346950208157931299L;

    public FormTypeNodeLoadors() {
        super(WikittyExtension.class);
    }

    public VradiDataService getDataService(NavDataProvider dataProvider) {
        return ((VradiDataProvider) dataProvider).getVradiDataService();
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        VradiDataService dataService = getDataService(dataProvider);
        List<WikittyExtension> formTypes = dataService.getAllFormTypes();
        Collections.sort(formTypes,  VradiComparators.EXTENSION_COMPARATOR);
        return extractNames(formTypes);
    }

    @Override
    public VradiTreeNode createNode(String name, NavDataProvider dataProvider) {

        if (log.isDebugEnabled()) {
            log.debug("Create node with name " + name);
        }

        return new VradiTreeNode(
                getBeanType(),
                name,
                null,
                null);
    }

    public List<String> extractNames(List<WikittyExtension> entities) {
        List<String> names = new ArrayList<String>();
        for (WikittyExtension e : entities) {
            names.add(e.getName());
        }
        return names;
    }
}