/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestListUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JPanel content;
    protected javax.swing.JScrollPane contentScroll;
    protected jaxx.runtime.swing.Table header;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RequestListUI $JPanel0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        content.setVisible(false);
        content.removeAll();
        content.setAlignmentY(TOP_ALIGNMENT);
        
        if (bean != null && bean.getQueries() != null) {
            for (String query : bean.getQueries()) {
                createRequest(query);
            }
        }
        content.setVisible(true);    
    }
    
    protected void createRequest(final String query) {
        RequestSelectUI requestUI = new RequestSelectUI(RequestListUI.this);
        requestUI.setAlignmentY(TOP_ALIGNMENT);
    
        if (log.isDebugEnabled()){
            log.debug("Open query " + query);
        }
        
        try {
            requestUI.setBean(new QueryBean(query));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return;
        }
        
        requestUI.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RequestSelectUI query = (RequestSelectUI) evt.getSource();
    
                QueryBean oldValue = (QueryBean) evt.getOldValue();
                QueryBean newValue = (QueryBean) evt.getNewValue();
    
                if (log.isDebugEnabled()
                    && oldValue != null
                    && newValue != null) {
                    log.debug("Update query from '" + oldValue.getQueryLine() + "' to '" + newValue.getQueryLine() + "'");
                }
    
                bean.removeQueries(oldValue.getQueryLine());
    
                if (newValue == null) {
                    // this means remove
                    content.setVisible(false);
                    content.remove(query);
                    content.setVisible(true);
                } else {
                    // this means update
                    bean.addQueries(newValue.getQueryLine());
                }
            }
        });
        requestUI.setAlignmentY(Component.TOP_ALIGNMENT);
        content.add(requestUI);
        validate();
    }
    
    protected void showHistory() {
        AdminHandler handler = getContextValue(AdminHandler.class);
        handler.showHistory(bean.getWikittyId());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestListUI() {
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        showHistory();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        createRequest("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JScrollPane getContentScroll() {
        return contentScroll;
    }

    public jaxx.runtime.swing.Table getHeader() {
        return header;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContentScroll() {
        if (!allComponentsCreated) {
            return;
        }
        contentScroll.getViewport().add(content);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createContentScroll() {
        $objectMap.put("contentScroll", contentScroll = new javax.swing.JScrollPane());
        
        contentScroll.setName("contentScroll");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new jaxx.runtime.swing.Table());
        
        header.setName("header");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(header);
        add(contentScroll, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToContentScroll();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("history"));
        contentScroll.setColumnHeaderView(header);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createBean();
        createHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminRequest.title"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.history.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.new"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContentScroll();
        createContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new GridLayout(0,1));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
    }

}