/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_THESAURUS_SELECTED = "thesaurusSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected javax.swing.JButton create;
    protected javax.swing.JButton createNewRoot;
    protected javax.swing.JButton delete;
    protected javax.swing.JButton edit;
    protected javax.swing.JCheckBox expandByDefault;
    protected javax.swing.JToolBar headerPanel;
    protected java.lang.Boolean modified;
    protected java.lang.Boolean selected;
    protected javax.swing.JButton sortButton;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected java.lang.Boolean thesaurusSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeTableHelper helper;
    
    
    public  AdminThesaurusUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
    //    setContextValue(new ModifThesaurusModel(this, helper));
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new AdminThesaurusHandler.CopyToClipboard(this);
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
    
    
                JPopupMenu popup = new JPopupMenu();
    
                // Add mouse listener to enable menus
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
    
                    // Add mouse listener to enable menus
                    JMenuItem menuAddRootChild = new JMenuItem();
                    menuAddRootChild.setText(_("vradi.menu.addRootChildThesaurus"));
                    menuAddRootChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                             createNewRoot();
                        }
                    });
                    popup.add(menuAddRootChild);
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    if (isThesaurusSelected()) {
                        JMenuItem menuMoveSeleted = new JMenuItem();
                        menuMoveSeleted.setText(_("vradi.menu.moveThesaurusSelected"));
                        menuMoveSeleted.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                moveSelected();
                            }
                        });
                        popup.add(menuMoveSeleted);
                    }
    
                    JMenuItem menuChangeColorSeleted = new JMenuItem();
                    menuChangeColorSeleted.setText(_("vradi.menu.menuChangeColorSeleted"));
                    menuChangeColorSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            changeColorSelected();
                        }
                    });
                    popup.add(menuChangeColorSeleted);
    
                    popup.add(copyToClipboard);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = (VradiTreeTableNode)e.getPath().getLastPathComponent();
    
                boolean selectionEmpty = thesaurus.getTreeSelectionModel().isSelectionEmpty();
    
                // Set as selected
                setSelected(!selectionEmpty);
    
                // Is thesaurus
                if (selectedNode != null) {
                    setThesaurusSelected(isSelected() &&
                            Thesaurus.class.equals(selectedNode.getInternalClass()));
                }
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
    
        // Single selection mode
        thesaurus.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
        // Expend on click
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT));
    }
    
    protected void createNewRoot(){
        // Ajout dun nouveau root thesaurus
        getThesaurusHandler().createRootThesaurus(this);
    }
    
    protected void addChildToSelected(){
        // Ajout dun nouveau thesaurus
        getThesaurusHandler().addChildThesaurusToSelected(this, helper);
    }
    
    protected void editSelected(){
        // Edition dun thesaurus
        getThesaurusHandler().editThesaurusSelected(this, helper);
    }
    
    protected void deleteSelected(){
        // Suppression dun thesaurus
        getThesaurusHandler().deleteThesaurusSelected(this, helper);
    }
    
    protected void moveSelected(){
        // Move thesaurus
        getThesaurusHandler().moveThesaurusSelected(this, helper);
    }
    
    protected void changeColorSelected(){
        // Change color af selected detph
        getThesaurusHandler().changeThesaurusColor(this, helper);
    }
    
    protected void setExpandByDefault(){
        VradiHelper.storeOnClickThesaurusExpanded(expandByDefault.isSelected());
    }
    
    protected void sort() {
        thesaurus.setTreeTableModel(helper.createTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getThesaurusHandler().importCSV(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getThesaurusHandler().exportThesaurusCSV(this);
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        addChildToSelected();
    }

    public void doActionPerformed__on__createNewRoot(java.awt.event.ActionEvent event) {
        createNewRoot();
    }

    public void doActionPerformed__on__delete(java.awt.event.ActionEvent event) {
        deleteSelected();
    }

    public void doActionPerformed__on__edit(java.awt.event.ActionEvent event) {
        editSelected();
    }

    public void doActionPerformed__on__expandByDefault(java.awt.event.ActionEvent event) {
        setExpandByDefault();
    }

    public void doActionPerformed__on__sortButton(java.awt.event.ActionEvent event) {
        sort();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getCreateNewRoot() {
        return createNewRoot;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JButton getEdit() {
        return edit;
    }

    public javax.swing.JCheckBox getExpandByDefault() {
        return expandByDefault;
    }

    public javax.swing.JToolBar getHeaderPanel() {
        return headerPanel;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public javax.swing.JButton getSortButton() {
        return sortButton;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getThesaurusSelected() {
        return thesaurusSelected;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    public java.lang.Boolean isThesaurusSelected() {
        return thesaurusSelected !=null && thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    public void setThesaurusSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.thesaurusSelected;
        this.thesaurusSelected = newValue;
        firePropertyChange(PROPERTY_THESAURUS_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(headerPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add(createNewRoot);
        headerPanel.add(create);
        headerPanel.add(edit);
        headerPanel.add(delete);
        headerPanel.add(expandByDefault);
        headerPanel.add($JButton0);
        headerPanel.add($JButton1);
        headerPanel.add(sortButton);
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateNewRoot() {
        $objectMap.put("createNewRoot", createNewRoot = new javax.swing.JButton());
        
        createNewRoot.setName("createNewRoot");
        createNewRoot.setText(_("vradi.thesaurus.createNewRoot"));
        createNewRoot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createNewRoot"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new javax.swing.JButton());
        
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new javax.swing.JButton());
        
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createExpandByDefault() {
        $objectMap.put("expandByDefault", expandByDefault = new javax.swing.JCheckBox());
        
        expandByDefault.setName("expandByDefault");
        expandByDefault.setText(_("vradi.thesaurus.expendByDefault"));
        expandByDefault.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__expandByDefault"));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new javax.swing.JToolBar());
        
        headerPanel.setName("headerPanel");
        headerPanel.setFloatable(false);
        headerPanel.setLayout(new BoxLayout(headerPanel, BoxLayout.X_AXIS));
        headerPanel.setOpaque(false);
        headerPanel.setBorderPainted(false);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createSortButton() {
        $objectMap.put("sortButton", sortButton = new javax.swing.JButton());
        
        sortButton.setName("sortButton");
        sortButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sortButton"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminThesaurusUI();
        addChildrenToHeaderPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        createNewRoot.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        expandByDefault.setSelected(VradiHelper.isOnClickThesaurusExpanded());
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("import"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("export"));
        sortButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("sort"));
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminThesaurusUI", this);
        createModified();
        createSelected();
        createThesaurusSelected();
        createHeaderPanel();
        createCreateNewRoot();
        createCreate();
        createEdit();
        createDelete();
        createExpandByDefault();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminThesaurus.importThesaurusCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminThesaurus.exportThesaurusCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSortButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
    }

}