/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class DateTimeEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<Date, DateEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_HOUR_SELECTED_ITEM = "hour.selectedItem";
    public static final String BINDING_MINUTE_SELECTED_ITEM = "minute.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz08TQRTHp7UtFKgKCIGApiiJB+IUL3qAAAoSIUXRGkLoQafdgU7Z3RlnZ2HxYPwT/BP07sXEmyfjwbMHL8Z/wRgPXo1vdkt/4FrWbA+723nvfd533r43++Y7SjsSTdWJ52Hp2opZFK/f2t6+X6nTqlqhTlUyobhEwS+RRMky6jea645CV8pFHV5ohBeWuSW4Te226Lki6nPUkUmdGqVKoYudEVXHKZSa5jlPuPKY2hQVRn3180fypfHidRIhT4C6LGwlf1pUayepIkoyQ6EhyHRACiax90CGZPYe6M3ptWWTOM49YtGn6DnqKaKMIBJgCl2OvmWf4cd7QqHc9JYkBrtjMPCZVehGlVu47krmWERWa9TBB9qOXYb57i6VmPqeDl4hij6CXEGkED4yo1Da4gY1Fbr5P6AAsqEjW6TsATGZQcCg0ExHFZsG7BxCdXBJX7eOF1uEXJBjmdvKr9KQrqHXCFrfJHZ7ukzgrFCeyz1ch5baV1wEzh5e39Y6N1l1n0odMNSM650OSLP6/4VOW6rGXSCOdOSFl1Pht7mnfcbaMUVSAcxJmf5qp2/GYrar/CaYbFgkmugoEbQwbrVwq8cSZZSWLiwrNFb+u+sfgino97ET/a6BvvX36PCX99/erR43+SDkHgl1bZtRaD4huaBSMZ36XNDhrmJmYYOIuTKMCjVhwP0BngwRVmqYQRzkG9ThWIfju8SpASLd8/XDx9Enn8+g5CrqMzkxVon2X0NZVZNQBW4anlhc8hUNHPbC9bzWBsU0yRF3oTvOzkP7kHyF2QYUfsGDIkyGFKGppJL99Gu49HbpuBAJEDb+T/dWMdI7KMNsk9nUn/fGKIfOd79wqGvw1siGDXFC34dFo5Ov+teZsJ32W8RjlmuV2DM/AfZcfSv42vXT9cioFJSqG2M0khxmR5ATBZUTksKZIqkRG6aXr3UhjEciLHYhTETYUHCKxoLo5ZWYMnrh62JQGRx5MTgDwXRTY01RKyYrpainz/L5YIbyRMEnsgLH4UI481LsFzYVifAgNqHb24pG2IlNeHwK4Q9a+KtXoQkAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.DateTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.jdesktop.swingx.JXDatePicker editor;
    protected javax.swing.JComboBox hour;
    protected javax.swing.JComboBox minute;
    protected com.jurismarches.vradi.ui.offer.editors.DateEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.DateEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditor $VradiEditor0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditor() {
        super();
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.DateEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editor(java.awt.event.ActionEvent event) {
        setValue(editor.getDate());
    }

    public void doActionPerformed__on__hour(java.awt.event.ActionEvent event) {
        model.setHour((Integer)hour.getSelectedItem());
    }

    public void doActionPerformed__on__minute(java.awt.event.ActionEvent event) {
        model.setMinute((Integer)minute.getSelectedItem());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.jdesktop.swingx.JXDatePicker getEditor() {
        return editor;
    }

    public javax.swing.JComboBox getHour() {
        return hour;
    }

    public javax.swing.JComboBox getMinute() {
        return minute;
    }

    public com.jurismarches.vradi.ui.offer.editors.DateEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("value", editor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
        editorContent.add($JPanel0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new org.jdesktop.swingx.JXDatePicker());
        
        editor.setName("editor");
        editor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createHour() {
        $objectMap.put("hour", hour = new javax.swing.JComboBox());
        
        hour.setName("hour");
        hour.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hour"));
    }

    protected void createMinute() {
        $objectMap.put("minute", minute = new javax.swing.JComboBox());
        
        minute.setName("minute");
        minute.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minute"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.DateEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.DateEditorModel >(com.jurismarches.vradi.ui.offer.editors.DateEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        // inline complete setup of $JPanel0
        $JPanel0.add(hour, BorderLayout.WEST);
        $JPanel0.add($JLabel0, BorderLayout.CENTER);
        $JPanel0.add(minute, BorderLayout.EAST);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        ((javax.swing.JPanel) editorContent).setMaximumSize(new Dimension(0, 28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setPreferredSize(new Dimension(0,28));
        hour.setMinimumSize(new Dimension(0,28));
        hour.setModel(UIHelper.getHourModel());
        hour.setPreferredSize(new Dimension(60,28));
        hour.setRenderer(UIHelper.get2DigitsRenderer());
        minute.setMinimumSize(new Dimension(0,28));
        minute.setModel(UIHelper.getMinuteModel());
        minute.setPreferredSize(new Dimension(60,28));
        minute.setRenderer(UIHelper.get2DigitsRenderer());
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createHour();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.common.timeseparator"));
        createMinute();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setDate(model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("hour", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hour.setSelectedItem(model.getHour());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("hour", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minute.setSelectedItem(model.getMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minutes", this);
                }
            }
        });
    }

}