/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferListUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVANCED_SEARCH_COLLAPSED = "advancedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean advancedSearchCollapsed;
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JButton exportButton;
    protected com.jurismarches.vradi.ui.offer.OfferTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JPanel paginationPanel;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected SearchUI searchUI;
    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setSearchUI(SearchUI searchUI) {
        this.searchUI = searchUI;
        searchPanel.add(searchUI, BorderLayout.CENTER);
    }
    
    public SearchUI getSearchUI() {
        return searchUI;
    }
    
    void $afterCompleteSetup() {
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1) {
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String fqName = offerListTableModel.getColumnFqName(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(fqName);
                } 
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(java.awt.event.ActionEvent event) {
        getSearchHandler().exportToCSV(searchUI);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAdvancedSearchCollapsed() {
        return advancedSearchCollapsed;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JButton getExportButton() {
        return exportButton;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isAdvancedSearchCollapsed() {
        return advancedSearchCollapsed !=null && advancedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvancedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advancedSearchCollapsed;
        this.advancedSearchCollapsed = newValue;
        firePropertyChange(PROPERTY_ADVANCED_SEARCH_COLLAPSED, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
    }

    protected void createAdvancedSearchCollapsed() {
        $objectMap.put("advancedSearchCollapsed", advancedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new javax.swing.JButton());
        
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new javax.swing.JPanel());
        
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 16 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createAdvancedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createPaginationUI();
        createExportButton();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}