/*
 * #%L
 * Vradi :: Swing
 * *
 * $Id: RequestFieldMenu.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/models/RequestFieldMenu.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Infogene;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.search.SearchUI;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

import javax.swing.*;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * @author letellier
 */
public class RequestFieldMenu extends JMenu implements WikittyServiceListener {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(FormMenu.class);

    public static final String FIELD_NAME_SUFFIX = ":\"\"";

    protected SearchUI searchUI;
    protected Map<String, JMenu> formTypesMenu;
    protected Map<String, JMenuItem> formTypesFieldMenu;

    public RequestFieldMenu(SearchUI searchUI){
        super(_("vradi.request.keywords"));

        this.searchUI = searchUI;

        // Fill infogene fields
        fillInfogeneMenu();

        // Get all formsType
        List<WikittyExtension> formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        } catch (VradiException eee) {
            log.error("cant get all forms type", eee);
            ErrorDialogUI.showError(eee);
        }

        // Sort
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);

        formTypesMenu = new HashMap<String, JMenu>();
        formTypesFieldMenu = new HashMap<String, JMenuItem>();

        // Fill for all formTypes
        if (formTypes != null) {
            for (final WikittyExtension formType : formTypes){
                fillFormTypeMenu(formType);
            }
        }
        // register each tree on wikitty service
        VradiService.getWikittyService().addWikittyServiceListener(this, WikittyService.ServiceListenerType.ALL);
    }

    protected void fillInfogeneMenu() {
        JMenu infogeneMenu = new JMenu(_("vradi.request.infogene"));

        for (String fieldName : getInfogeneFieldNames()) {
            infogeneMenu.add(new InfogeneMenuItem(fieldName));
        }
        for (String fieldName : getFormFieldNames()) {
            infogeneMenu.add(new FormMenuItem(fieldName));
        }
        add(infogeneMenu);
    }

    protected void fillFormTypeMenu(WikittyExtension formType) {
        String formTypeName = formType.getName();
        JMenu formTypeMenu = new JMenu(formTypeName);

        for (String fieldName : formType.getFieldNames()) {
            FieldMenuItem fieldMenu = new FieldMenuItem(fieldName);
            formTypeMenu.add(fieldMenu);

            formTypesFieldMenu.put(fieldName, fieldMenu);
        }
        formTypesMenu.put(formTypeName, formTypeMenu);
        add(formTypeMenu);
    }

    protected List<String> getInfogeneFieldNames() {
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FIELD_INFOGENE_ID);
        fieldNames.add(Infogene.FIELD_INFOGENE_OBJET);
        fieldNames.add(Infogene.FIELD_INFOGENE_DESCRIPTION);
        fieldNames.add(Infogene.FIELD_INFOGENE_CREATIONDATE);
        fieldNames.add(Infogene.FIELD_INFOGENE_ENTITY);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCETEXT);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCEURL);
        fieldNames.add(Infogene.FIELD_INFOGENE_COUNTRY);
        fieldNames.add(Infogene.FIELD_INFOGENE_DEPARTMENT);

        return fieldNames;
    }

    protected List<String> getFormFieldNames() {
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Form.FIELD_FORM_DATEPUB);
        fieldNames.add(Form.FIELD_FORM_DATEPEREMPTION);

        return fieldNames;
    }

    protected class FieldMenuItem extends JMenuItem implements ActionListener {
        protected String key;

        public FieldMenuItem(String key) {
            this(null, key);
        }

        public FieldMenuItem(String text, String key) {
            super(text == null ? key : (text + " (" + key + ")"));
            this.key = key;

            addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {

            JTextArea requestArea = searchUI.getRequestArea();

            int position = requestArea.getCaretPosition();
            requestArea.insert(key + FIELD_NAME_SUFFIX, position);

            // Put carret under cotes
            requestArea.setCaretPosition(position + key.length() + 2);

            searchUI.setRequest(requestArea.getText());
        }
    }

    protected class InfogeneMenuItem extends FieldMenuItem {

        public InfogeneMenuItem(String key) {
            super(UIHelper.getInfogeneTraduction(key), key);
        }
    }

    protected class FormMenuItem extends FieldMenuItem {

        public FormMenuItem(String key) {
            super(UIHelper.getFormTraduction(key), key);
        }
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {

    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
    }
}
