/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.login;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.VradiUserImpl;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.login.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class LoginUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MAIN_UI_INITIALIZED = "mainUiInitialized";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp5W2FPwFhAqKBpBoTMwWo/ECQQTTCKlCBAyxF6a7YztkdmadmYXFg/FP8E/QuxcTb56MB88evBj/BWM8eDW+2e0PWpfS2B52d+a995nve31v3v5AKSXR1C4OAkv6XFOXWKt3t7fXyrvE1veIsiX1tJAo+iWSKFlCg05jX2l0uVQ04flaeH5ZuJ7ghB+KniuiAaUPGFFVQrRGF1sjbKXyGw3zXOD5sk5tiIqjvv71M/nKefkmiVDggbpBSGXyuKhmJn1FlKSORsNw0h7OM8wrIENSXgG9p8zeMsNKPcQueYZeoEwRpT0sAabRdPcph4wwPvA0yjBRoXxrRaOrtnCtXV9S5WJpV4my9iR2qOVTK/SxipGn54XRaY36ygRzja4dEQjHU01h+dgstxSRzdAhFwOLrnDwwIw+J5D2kMnQMllbS0IwYDf9B0IJ65gTptFYS0nVPhTI2sRlFlYl24jpn1kt4jJhs1BRgw5qrtGucRpu+KZCvka5FsdNEugCJcxpda6Db5j1uTabB9XdFxLyOd/CWq/tx/DSNua2SWykJWLJ11rwNrwkFao0kWY93Wbbg0o6WJPDNokutFQLWttqtnaz9xIllJI+bEN5S/9OwyMwRXMw1jYHBhha/+RGvn74/r5Qb/7TcPZorOuh2YWm9KTwiDSNotGZqPN9TVn+AfbmSiirCIPBDwd7IkbYRs0M4uC8qIVMuHUfqyogUplvHz/ldr6cQMmC6SLsFLDxX0FZXZVQBcGcwLuzGCo6ud8Pz7NGm0ajDnmKfaaXmVBkDSRiTQW0yOl5qDGeLFPuwN+0EEBNJmJq0hBWzn7+PbLxbrFelwToHD/SvVmb1BOUppxRTsJroTbxsdfAoKeI74jmZMfNesK8B7zaTF0Pn7NxiacZPhC+NvabgW9et0LZ5ut215SUKxwMPT08HyUxiTVcZWVfk4UeoHCjRGO++P+QPg1j3YGR64KRsQXzXa46YMaPxZjt1Q6Eia4Iax0Il3rWMNVFMfpdTlzBqd0T5zglM10RdnomdNJwpWcNhvAXsF7SV+UIAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.login.LoginUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.VradiUser bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JTextField login;
    protected jaxx.runtime.swing.Table loginPanel;
    protected LoginUI loginUI = this;
    protected java.lang.Boolean mainUiInitialized;
    protected javax.swing.JPasswordField password;
    protected javax.swing.JButton register;
    protected javax.swing.JButton validate;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected LoginHandler getHandler() {
        return getContextValue(LoginHandler.class);
    }
    
    void $afterCompleteSetup() {
        KeyAdapter keyAdapter = new KeyAdapter(){
                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
                        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                        validate.doClick();
                    }
                }
        };
        login.addKeyListener(keyAdapter);
        password.addKeyListener(keyAdapter);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LoginUI() {
        $initialize();
    }

    public LoginUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        loginUI.dispose(); System.exit(0);
    }

    public void doActionPerformed__on__register(java.awt.event.ActionEvent event) {
        getHandler().register(this);
    }

    public void doActionPerformed__on__validate(java.awt.event.ActionEvent event) {
        getHandler().logUser(this);
    }

    public void doWindowClosing__on__loginUI(java.awt.event.WindowEvent event) {
        dispose(); System.exit(0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.VradiUser getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JTextField getLogin() {
        return login;
    }

    public jaxx.runtime.swing.Table getLoginPanel() {
        return loginPanel;
    }

    public java.lang.Boolean getMainUiInitialized() {
        return mainUiInitialized;
    }

    public javax.swing.JPasswordField getPassword() {
        return password;
    }

    public javax.swing.JButton getRegister() {
        return register;
    }

    public javax.swing.JButton getValidate() {
        return validate;
    }

    public java.lang.Boolean isMainUiInitialized() {
        return mainUiInitialized !=null && mainUiInitialized;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.VradiUser newValue) {
        com.jurismarches.vradi.entities.VradiUser oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setMainUiInitialized(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.mainUiInitialized;
        this.mainUiInitialized = newValue;
        firePropertyChange(PROPERTY_MAIN_UI_INITIALIZED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLoginPanel() {
        if (!allComponentsCreated) {
            return;
        }
        loginPanel.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(login, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(password, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(cancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(register, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(validate, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToLoginUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(loginPanel);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.login.cancel"));
        cancel.setMnemonic(65);
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createLogin() {
        $objectMap.put("login", login = new javax.swing.JTextField());
        
        login.setName("login");
        login.setColumns(15);
        login.setColumns(20);
    }

    protected void createLoginPanel() {
        $objectMap.put("loginPanel", loginPanel = new jaxx.runtime.swing.Table());
        
        loginPanel.setName("loginPanel");
    }

    protected void createMainUiInitialized() {
        $objectMap.put("mainUiInitialized", mainUiInitialized = false);
    }

    protected void createPassword() {
        $objectMap.put("password", password = new javax.swing.JPasswordField());
        
        password.setName("password");
        password.setColumns(15);
        password.setColumns(20);
    }

    protected void createRegister() {
        $objectMap.put("register", register = new javax.swing.JButton());
        
        register.setName("register");
        register.setText(_("vradi.login.register"));
        register.setMnemonic(69);
        register.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__register"));
    }

    protected void createValidate() {
        $objectMap.put("validate", validate = new javax.swing.JButton());
        
        validate.setName("validate");
        validate.setText(_("vradi.login.validate"));
        validate.setMnemonic(86);
        validate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToLoginUI();
        addChildrenToLoginPanel();
        
        // apply 2 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        loginUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("loginUI", this);
        createBean();
        createMainUiInitialized();
        createLoginPanel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.login.login"));
        createLogin();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.login.password"));
        createPassword();
        createCancel();
        createRegister();
        createValidate();
        // inline creation of loginUI
        setName("loginUI");
        loginUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.login.title"));
        loginUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__loginUI"));
        
        $completeSetup();
    }

}