/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: XmlStreamHelper.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/helpers/XmlStreamHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.helpers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;

import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.services.VradiException;

/**
 * XmlStreamHelper.
 *
 * @author $Author: tchemit $
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 5 mars 2010 01:48:29
 */
public class XmlStreamHelper {
    private static final Log log = LogFactory.getLog(XmlStreamHelper.class);
    
    public static Element getFirstElement(String url) throws VradiException {
        return getFirstElementXpp(url);
    }

    protected static Element getFirstElementJDom(String url) throws VradiException {
        try {
            long currentTimeMillis = System.currentTimeMillis();
                
            URL rssUrl = new URL(url);
            
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(rssUrl);

            Element racine = document.getRootElement();
            log.debug("Root element name: " + racine.getName());
            
            Element firstElement = null;
            
            if (racine.getChild(VradiConstants.ITEM) != null) {
                firstElement = racine.getChild(VradiConstants.ITEM);
                
            } else if (racine.getChild(VradiConstants.ENTRY) != null) {
                firstElement = racine.getChild(VradiConstants.ENTRY);
                
            } else if (racine.getChild(VradiConstants.CHANNEL) != null) {
                Element element = racine.getChild(VradiConstants.CHANNEL);
                firstElement = element.getChild(VradiConstants.ITEM);
            }
            
            log.debug(System.currentTimeMillis() - currentTimeMillis);
            return firstElement;
            
        } catch (Exception eee) {
            log.error(eee.getMessage(), eee);
            throw new VradiException("Cant get first element", eee);
        }
    }
    
    protected static Element getFirstElementXpp(String url) throws VradiException {
        InputStream openStream = null;
        try {
            long currentTimeMillis = System.currentTimeMillis();

            URL rssUrl = new URL(url);

            //Change timout
            URLConnection connection = rssUrl.openConnection();
            connection.setConnectTimeout(2000);
            
            openStream = connection.getInputStream();
            InputStreamReader streamReader = new InputStreamReader(openStream);
            BufferedReader bufferedReader = new BufferedReader(streamReader);

            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            // don't check for DTD validity
            inputFactory.setProperty(XMLInputFactory.SUPPORT_DTD, "false");
            XMLStreamReader reader = inputFactory.createXMLStreamReader(bufferedReader);
            
            Element firstElement = null;
            
            while (reader.hasNext()) {
                int type = reader.next();
                
                if (type == XMLStreamConstants.START_ELEMENT) {
                    String localName = reader.getLocalName();
                    
                    if (firstElement == null && (localName.equals(VradiConstants.ITEM) || localName.equals(VradiConstants.ENTRY))) {
                        firstElement = new Element(localName);
                        
                    } else if (firstElement != null) {
                        Element element = new Element(localName);
                        firstElement.addContent(element);
                    }
                    
                } else if (type == XMLStreamConstants.CHARACTERS || type == XMLStreamConstants.CDATA) {
                    if (firstElement != null && firstElement.getContentSize() > 0) {
                        int contentSize = firstElement.getContentSize();
                        Element content = (Element) firstElement.getContent(contentSize - 1);
                        content.setText(content.getTextTrim() + reader.getText());
                    }
                    
                } else if (type == XMLStreamConstants.END_ELEMENT) {
                    String localName = reader.getLocalName();
                    
                    if (firstElement != null && (localName.equals(VradiConstants.ITEM) || localName.equals(VradiConstants.ENTRY))) {
                        break;
                    }
                }
            }
            
            log.debug(System.currentTimeMillis() - currentTimeMillis);
            return firstElement;
            
        } catch (Exception eee) {
            log.error(eee.getMessage(), eee);
            throw new VradiException("Cant get first element", eee);
        } finally {
            IOUtils.closeQuietly(openStream);
        }
    }
    
    public static Set<String> getRSSFields(Element firstElement) {
        if (log.isDebugEnabled()) {
            log.debug("getRSSFields");
        }
        Set<String> result = new LinkedHashSet<String>();

        if (firstElement != null) {
            for (Element elt : (List<Element>) firstElement.getChildren()) {
                result.add(elt.getName());
            }
        }
        return result;
    }

    public static Map<String, String> getFirstElementValues(Element firstElement) {
        Map<String, String> result = new LinkedHashMap<String, String>();

        if (firstElement != null) {
            for (Element elt : (List<Element>) firstElement.getChildren()) {
                result.put(elt.getName(), elt.getText());
            }
        }
        return result;
    }

}
