/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusConfirmDialogUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MSG = "msg";
    public static final String PROPERTY_SAVE = "save";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MSG_LABEL_TEXT = "msgLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRR+FFpo8QdKQIhgQLhwcAvxYgLKzxAhVRPRhNiL0+7YDtndGWfewnIx/gn+CXr3YuLNk/Hg2YMX479gjAevxjfb0m1lwSb0MG3nfe9733vzvbc/IGs0TO+xKHJ0GKDwubO9urv7oLLHq7jBTVULhVJD49OTgUwZBt3WvUGYKZdserGZXlyXvpIBD9qyF0tQMHjocVPnHBEmOzOqxhR3WuHFSIX6iLUlKo319a+fmVfuyzcZgEiRugK1MvW/rKSTvhJkhItwmSrts6LHghrJ0CKokd7z9m7dY8bcZz5/Di+gvwQ5xTSRIVzvvuWYI86PFMIY1rlhoQ7NugyeCe1vCObJ2uMthOWq9J29UAvjM10lmLOvmSucUDjM9UXgKKlCZZxHJzAoFZfJIfT6poYwZDtwbFdOo6sE0FfhLECYO6EiNSJQ8LZSbamG7XOESwn5mpQe0SWQ/tlHrOLxeeq24zHMAYlw4phF5lsJA6S3xCrco7ewvFETuh1fWtBIC5s3dXmwqpR3iDDcAV4LEWXQiW5KWbB/r3QWzc82M+btxaQ9rh0PLrQHNVztaIh86yS+TYzVU4asDumaJlA+bvWHFGqYfOwfk1vCOPpndPjrh+/vN4+cnafaI6nQtsUkxyktFdf27RAuNmwdovCK95haLBML92ir462dSBG20wyTOKrXeGKb7txlpk4U2f5vHz+NPv3SC5lNKHiSuZvM4rcgj3VNU5CeG6nllVjRuYMBOoesNoScxw4lDRQuLLkM2VRFBC492p2IhjCRMoSWkkr+8+/hnXcrR4PoIWHjJ8KTYWSfQE4Engh4vOTN/U1d6kFleOjKZE/TNrfHfhdU0+Rz8XkjrdOsL11mjbzUKD/FkJavEiKnZm3WQtyF/XWza9I+UW04ez6dY7wbDuQRnonDXq/Z41Y6w0RXDLdP0TB9Zg3dMZymYebMGizDX8vgwONZBwAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.ThesaurusConfirmDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Thesaurus bean;
    protected java.lang.String msg;
    protected javax.swing.JLabel msgLabel;
    protected java.lang.Boolean save;
    protected javax.swing.JButton showApply;
    protected ThesaurusConfirmDialogUI thesaurusConfirmDialogUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusHandler getHandler() {
        return getContextValue(AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    public void init(Thesaurus thesaurus, String msg, String title) {
        setBean(thesaurus);
        setTitle(title);
        setMsg(msg);
    
        pack();
        setVisible(true);
    }
    
    protected void showApply() {
        getHandler().showApply(this, getBean());
    }
    
    protected void saveAndClose() {
        setSave(true);
        close();
    }
    
    protected void close() {
       setVisible(false);
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusConfirmDialogUI() {
        $initialize();
    }

    public ThesaurusConfirmDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        saveAndClose();
    }

    public void doActionPerformed__on__showApply(java.awt.event.ActionEvent event) {
        showApply();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Thesaurus getBean() {
        return bean;
    }

    public java.lang.String getMsg() {
        return msg;
    }

    public javax.swing.JLabel getMsgLabel() {
        return msgLabel;
    }

    public java.lang.Boolean getSave() {
        return save;
    }

    public javax.swing.JButton getShowApply() {
        return showApply;
    }

    public java.lang.Boolean isSave() {
        return save !=null && save;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Thesaurus newValue) {
        com.jurismarches.vradi.entities.Thesaurus oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setMsg(java.lang.String newValue) {
        java.lang.String oldValue = this.msg;
        this.msg = newValue;
        firePropertyChange(PROPERTY_MSG, oldValue, newValue);
    }

    public void setSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.save;
        this.save = newValue;
        firePropertyChange(PROPERTY_SAVE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusConfirmDialogUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createMsg() {
        $objectMap.put("msg", msg = "");
    }

    protected void createMsgLabel() {
        $objectMap.put("msgLabel", msgLabel = new javax.swing.JLabel());
        
        msgLabel.setName("msgLabel");
    }

    protected void createSave() {
        $objectMap.put("save", save = false);
    }

    protected void createShowApply() {
        $objectMap.put("showApply", showApply = new javax.swing.JButton());
        
        showApply.setName("showApply");
        showApply.setText(_("vradi.thesaurus.showApply"));
        showApply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showApply"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusConfirmDialogUI();
        // inline complete setup of $Table0
        $Table0.add(msgLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(showApply, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        msgLabel.setIcon(UIManager.getLookAndFeelDefaults().getIcon("OptionPane.warningIcon"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        // late initializer
        thesaurusConfirmDialogUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusConfirmDialogUI", this);
        createMsg();
        createBean();
        createSave();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createMsgLabel();
        createShowApply();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.thesaurus.confirm.save"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusConfirmDialogUI
        setName("thesaurusConfirmDialogUI");
        thesaurusConfirmDialogUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_TEXT, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setText(_(getMsg()));
            }
        });
    }

}