/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminRequestUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CAN_SAVE = "canSave";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.AdminRequestUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminRequestUI adminRequestUI = this;
    protected java.lang.Boolean canSave;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected java.lang.String request;
    protected com.jurismarches.vradi.ui.offer.OfferTable resultTable;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel resultTableModel;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        registerDataBinding(djb);
        djb.applyDataBinding();
        
        validate();
    }
    
    protected void saveAndClose() {
        setRequest(getSearchUI().getRequest());
        close();
    }
    
    protected void close() {
       setVisible(false);
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminRequestUI() {
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        saveAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getCanSave() {
        return canSave;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public java.lang.String getRequest() {
        return request;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getResultTable() {
        return resultTable;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isCanSave() {
        return canSave !=null && canSave;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCanSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.canSave;
        this.canSave = newValue;
        firePropertyChange(PROPERTY_CAN_SAVE, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setRequest(java.lang.String newValue) {
        java.lang.String oldValue = this.request;
        this.request = newValue;
        firePropertyChange(PROPERTY_REQUEST, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminRequestUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createCanSave() {
        $objectMap.put("canSave", canSave = true);
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createRequest() {
        $objectMap.put("request", request = null);
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminRequestUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setShowGrid(true);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("accept"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminRequestUI", this);
        createRequest();
        createCanSave();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.valid"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of adminRequestUI
        setName("adminRequestUI");
        SwingUtil.setComponentHeight(adminRequestUI,600);
        adminRequestUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.adminRequest.title"));
        SwingUtil.setComponentWidth(adminRequestUI,800);
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"canSave") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(isCanSave());
            }
        });
    }

}