/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.importexport;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;

public class WikittyBatchUpdate {
    protected int numberForCommit = 1000;
    protected int currentAdded = 0;
    protected Map<String, WikittyExtension> exts = new HashMap<String, WikittyExtension>();
    protected List<Wikitty> wikitties = new LinkedList<Wikitty>();
    protected WikittyService ws;
    protected WikittyTransaction transaction;
    protected String securityToken;

    public WikittyBatchUpdate(String securityToken, WikittyService ws, WikittyTransaction transaction) {
        this.securityToken = securityToken;
        this.ws = ws;
        this.transaction = transaction;
    }

    public void addExtension(WikittyExtension ext) {
        this.exts.put(ext.getId(), ext);
        this.inc();
    }

    public void addWikitty(Wikitty w) {
        this.wikitties.add(w);
        this.inc();
    }

    public WikittyExtension getExtension(String id) {
        WikittyExtension result = this.exts.get(id);
        if (result == null) {
            result = this.ws.restoreExtension(this.securityToken, this.transaction, id);
        }
        return result;
    }

    public void flush() {
        this.ws.storeExtension(this.securityToken, this.transaction, this.exts.values());
        this.ws.store(this.securityToken, this.transaction, this.wikitties, true);
        this.exts.clear();
        this.wikitties.clear();
        this.currentAdded = 0;
    }

    protected void inc() {
        ++this.currentAdded;
        if (this.currentAdded >= this.numberForCommit) {
            this.flush();
        }
    }
}

