/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.importexport;

import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyImportExportService;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.importexport.ImportExportMethod;
import org.nuiton.wikitty.importexport.ImportTask;
import org.nuiton.wikitty.search.Element;

public class ExportTask
implements Runnable {
    private static Log log = LogFactory.getLog(ImportTask.class);
    protected WikittyService ws;
    protected WikittyTransaction transaction;
    protected WikittyImportExportService.FORMAT format;
    protected Criteria criteria;
    protected Writer writer;
    protected String securityToken;

    public ExportTask(String securityToken, WikittyService ws, WikittyImportExportService.FORMAT format, Criteria criteria, Writer writer) {
        this.securityToken = securityToken;
        this.ws = ws;
        this.transaction = new WikittyTransaction();
        this.format = format;
        this.criteria = criteria;
        this.writer = writer;
    }

    @Override
    public void run() {
        try {
            this.transaction.begin();
            this.criteria.addFacetField(Element.ELT_EXTENSION);
            PagedResult<String> pageResultId = this.ws.findAllByCriteria(this.securityToken, this.transaction, this.criteria);
            long time = 0L;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info((Object)"Export started");
            }
            PagedResult<Wikitty> pageResult = pageResultId.cast(this.securityToken, this.ws, this.transaction);
            ImportExportMethod exporter = this.format.ieporter();
            exporter.exportWriter(this.securityToken, this.writer, this.ws, this.transaction, pageResult);
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info((Object)("Export in (ms)" + time));
            }
            this.transaction.commit();
        }
        catch (Exception eee) {
            this.transaction.rollback();
            throw new WikittyException("Error during export task", eee);
        }
    }
}

