/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.DISCARD_PAYLOAD;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class UNICAST_OOB_Test
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;

    @BeforeMethod
    void setUp() throws Exception {
        this.c1 = this.createChannel(true, 2);
        this.c2 = this.createChannel(this.c1);
    }

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.c2, this.c1);
    }

    public void testRegularMessages() throws Exception {
        this.sendMessages(false);
    }

    public void testOutOfBandMessages() throws Exception {
        this.sendMessages(true);
    }

    private void sendMessages(boolean oob) throws Exception {
        DISCARD_PAYLOAD prot1 = new DISCARD_PAYLOAD();
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        ProtocolStack stack = this.c1.getProtocolStack();
        Protocol neighbor = stack.findProtocol(UNICAST.class, UNICAST2.class);
        System.out.println("Found unicast protocol " + neighbor.getClass().getSimpleName());
        stack.insertProtocolInStack(prot1, neighbor, 2);
        this.c1.connect("UNICAST_OOB_Test");
        this.c2.connect("UNICAST_OOB_Test");
        assert (this.c2.getView().size() == 2) : "ch2.view is " + this.c2.getView();
        Address dest = this.c2.getAddress();
        for (int i = 1; i <= 5; ++i) {
            Message msg = new Message(dest, null, new Long(i));
            if (i == 4 && oob) {
                msg.setFlag((byte)1);
            }
            System.out.println("-- sending message #" + i);
            this.c1.send(msg);
            Util.sleep(100L);
        }
        long target_time = System.currentTimeMillis() + 5000L;
        while (receiver.size() < 5) {
            Util.sleep(500L);
            if (target_time > System.currentTimeMillis()) continue;
        }
        List<Long> seqnos = receiver.getSeqnos();
        System.out.println("sequence numbers: " + seqnos);
        if (!oob) {
            for (int i = 0; i < 5; ++i) {
                assert (seqnos.get(i) == (long)(i + 1)) : " seqno is " + seqnos.get(i) + ", but expected " + i + 1;
            }
        } else {
            int index_3 = -1;
            int index_4 = -1;
            for (int i = 0; i < 5; ++i) {
                if (seqnos.get(i) == 3L) {
                    index_3 = i;
                }
                if (seqnos.get(i) != 4L) continue;
                index_4 = i;
            }
            assert (index_4 < index_3) : "4 must come before 3 in list " + seqnos;
        }
    }

    public static class MyReceiver
    extends ReceiverAdapter {
        List<Long> seqnos = Collections.synchronizedList(new LinkedList());

        public List<Long> getSeqnos() {
            return this.seqnos;
        }

        @Override
        public void receive(Message msg) {
            if (msg != null) {
                Long num = (Long)msg.getObject();
                this.seqnos.add(num);
            }
        }

        public int size() {
            return this.seqnos.size();
        }
    }
}

