/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.util.DefaultThreadFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ThreadFactoryTest {
    private DefaultThreadFactory factory;
    private static final String BASE = "base";
    private static final String ADDR = "192.168.1.5:12345";
    private static final String CLUSTER = "MyCluster";

    public void testNoNumbering() {
        this.factory = new DefaultThreadFactory(null, BASE, true, false);
        Thread thread = this.factory.newThread(new MyRunnable(), BASE);
        String name = thread.getName();
        System.out.println("name = " + name);
        assert (name.equals(BASE));
    }

    public void testNumbering() {
        this.factory = new DefaultThreadFactory(null, BASE, true, true);
        Thread thread = this.factory.newThread(new MyRunnable(), BASE);
        String name = thread.getName();
        System.out.println("name = " + name);
        assert (name.equals("base-1"));
        thread = this.factory.newThread(new MyRunnable(), BASE);
        name = thread.getName();
        System.out.println("name = " + name);
        assert (name.equals("base-2"));
    }

    public void testPatterns() {
        this.factory = new DefaultThreadFactory(null, BASE, true, false);
        this.factory.setAddress(ADDR);
        Thread thread = this.factory.newThread(new MyRunnable(), BASE);
        String name = thread.getName();
        System.out.println("name = " + name);
        assert (name.equals(BASE));
        this.factory.setPattern("l");
        thread = this.factory.newThread(new MyRunnable(), BASE);
        name = thread.getName();
        System.out.println("name = " + name);
        assert (name.equals("base,192.168.1.5:12345"));
        this.factory.setPattern("cl");
        this.factory.setClusterName(CLUSTER);
        thread = this.factory.newThread(new MyRunnable(), BASE);
        name = thread.getName();
        System.out.println("name = " + name);
        assert (name.equals("base,MyCluster,192.168.1.5:12345"));
    }

    static class MyRunnable
    implements Runnable {
        MyRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

