/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.renderers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.renderers.ColorsMap;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class ThesaurusHighlighter
extends AbstractHighlighter
implements TreeCellRenderer,
ListCellRenderer {
    private static final Log log = LogFactory.getLog(ThesaurusHighlighter.class);
    protected DefaultListCellRenderer delegate = null;
    protected HighlighterType type;

    public ThesaurusHighlighter() {
        this(HighlighterType.DEFAULTS);
    }

    public ThesaurusHighlighter(HighlighterType type) {
        this.type = type;
        this.delegate = new DefaultListCellRenderer();
    }

    protected boolean isDefault() {
        return this.type.equals((Object)HighlighterType.DEFAULTS);
    }

    protected boolean isEdit() {
        return this.type.equals((Object)HighlighterType.EDIT);
    }

    protected boolean isMove() {
        return this.type.equals((Object)HighlighterType.MOVE);
    }

    protected boolean isProposition() {
        return this.type.equals((Object)HighlighterType.PROPOSITION);
    }

    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        try {
            int depth = adapter.getDepth();
            Color color = this.getDepthColor(depth);
            if (color != null) {
                component.setForeground(color);
            }
        }
        catch (Exception eee) {
            log.error((Object)"Cant render componant : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        return component;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String tooltip;
        RootThesaurus rootThesaurus;
        Object node;
        int depth = 0;
        String text = null;
        Thesaurus thesaurus = null;
        if (value instanceof VradiTreeNode) {
            node = (VradiTreeNode)((Object)value);
            rootThesaurus = ThesaurusTreeHelper.getRootThesaurus(node);
            if (rootThesaurus == null) {
                thesaurus = ThesaurusTreeHelper.getThesaurus(node);
            }
        } else if (value instanceof VradiTreeTableNode) {
            node = (VradiTreeTableNode)((Object)value);
            rootThesaurus = ThesaurusTreeTableHelper.getRootThesaurus((VradiTreeTableNode)((Object)node));
            if (rootThesaurus == null) {
                thesaurus = ThesaurusTreeTableHelper.getThesaurus((VradiTreeTableNode)((Object)node));
            }
        } else {
            return new JLabel(value.toString());
        }
        if (rootThesaurus != null) {
            text = rootThesaurus.getName();
        }
        if (thesaurus != null) {
            depth = ThesaurusDataHelper.getDepth(thesaurus);
            text = ThesaurusDataHelper.concateOrderName(thesaurus);
        }
        if (text == null) {
            return new JLabel(value.toString());
        }
        Color color = this.getDepthColor(depth);
        JLabel jLabel = new JLabel(text);
        if (color != null) {
            jLabel.setForeground(color);
        }
        if (thesaurus != null && (tooltip = this.isMove() || this.isEdit() ? ToolTipHelper.getThesaurusDescriptionToolTip(thesaurus) : ToolTipHelper.getThesaurusToolTip(thesaurus)) != null && !tooltip.trim().isEmpty()) {
            jLabel.setToolTipText(tooltip);
        }
        return jLabel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        int depth = 0;
        String namePath = null;
        Thesaurus thesaurus = null;
        if (value instanceof VradiTreeNode) {
            VradiTreeNode node = (VradiTreeNode)((Object)value);
            RootThesaurus rootThesaurus = ThesaurusTreeHelper.getRootThesaurus(node);
            if (rootThesaurus != null) {
                text = rootThesaurus.getName();
            } else {
                thesaurus = ThesaurusTreeHelper.getThesaurus(node);
                if (thesaurus == null) {
                    return new JLabel(value.toString());
                }
                depth = ThesaurusDataHelper.getDepth(thesaurus);
                text = ThesaurusDataHelper.concateOrderName(thesaurus);
            }
        } else if (value instanceof Thesaurus) {
            thesaurus = (Thesaurus)value;
            depth = ThesaurusDataHelper.getDepth(thesaurus);
            text = ThesaurusDataHelper.concateOrderName(thesaurus);
            namePath = ThesaurusDataHelper.getNamePath(thesaurus, "/");
        } else {
            return new JLabel(value.toString());
        }
        if (text == null) {
            return new JLabel(value.toString());
        }
        Color color = this.getDepthColor(depth);
        if (this.isProposition()) {
            text = namePath;
        }
        JLabel jLabel = (JLabel)this.delegate.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        if (color != null) {
            jLabel.setForeground(color);
        }
        if (thesaurus != null) {
            jLabel.setToolTipText(ToolTipHelper.getThesaurusToolTip(thesaurus));
        }
        return jLabel;
    }

    public Color getDepthColor(int depth) {
        Color color = ColorsMap.getInstance().get(depth);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public static enum HighlighterType {
        DEFAULTS,
        EDIT,
        PROPOSITION,
        MOVE;

    }
}

