/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class FormTypeModel
extends DefaultComboBoxModel
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(FormTypeModel.class);
    protected boolean firstNull = false;

    public FormTypeModel(boolean firstNull) {
        this.firstNull = firstNull;
        this.init();
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public void init() {
        List formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"Cant get all forms types", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        this.removeAllElements();
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);
        for (WikittyExtension formType : formTypes) {
            this.addElement(formType);
        }
        if (this.firstNull) {
            this.setSelectedItem(null);
        }
    }

    @Override
    public int getSize() {
        if (this.firstNull) {
            return super.getSize() + 1;
        }
        return super.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.firstNull) {
            if (index == 0) {
                return null;
            }
            return super.getElementAt(index - 1);
        }
        return super.getElementAt(index);
    }

    public void putWikitty(WikittyServiceEvent event) {
    }

    public void removeWikitty(WikittyServiceEvent event) {
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        this.init();
    }

    public void removeExtension(WikittyServiceEvent event) {
        this.init();
    }

    public void clearExtension(WikittyServiceEvent event) {
        this.init();
    }
}

