/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public abstract class VradiTreeHelper
extends NavTreeHelper<VradiTreeNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(VradiTreeHelper.class);
    protected List<String> idsLoaded = new ArrayList<String>();

    public void setUI(JTree tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener, TreeWillExpandListener willExpandListener) {
        super.setUI(tree, addExpandTreeListener, addOneClickSelectionListener, listener, willExpandListener);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode)((Object)event.getPath().getLastPathComponent());
                VradiTreeHelper.this.registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode)((Object)event.getPath().getLastPathComponent());
                Enumeration enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeNode child = (VradiTreeNode)((Object)enumeration.nextElement());
                    VradiTreeHelper.this.idsLoaded.remove(child.getId());
                }
            }
        });
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public List<String> getLoadedIds() {
        return this.idsLoaded;
    }

    public boolean isLoadedId(String id) {
        return this.idsLoaded.contains(id);
    }

    public void registerLoadedIds(VradiTreeNode node) {
        this.idsLoaded.add(node.getId());
        Enumeration enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeNode child = (VradiTreeNode)((Object)enumeration.nextElement());
            this.idsLoaded.add(child.getId());
        }
    }

    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put event : " + event));
        }
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            this.putWikitty(wikittyId, wikittyExtensions);
        }
    }

    public void putWikitty(String wikittyId, Set<String> wikittyExtensions) {
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            if (!this.isLoadedId(wikittyId)) continue;
            VradiTreeNode node = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
            this.idsLoaded.remove(wikittyId);
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeNode parent = (VradiTreeNode)node.getParent();
            int index = parent.getIndex((TreeNode)((Object)node));
            node.removeFromParent();
            ((NavTreeBridge)this.getBridge()).nodesWereRemoved((TreeNode)((Object)parent), new int[]{index}, (Object[])new VradiTreeNode[]{node});
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

