/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.widget;

import com.jurismarches.vradi.services.VradiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jaxx.runtime.swing.ListSelectorHandler;
import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public abstract class AdminListSelectorHandler<B extends BusinessEntity>
extends ListSelectorHandler<B>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(AdminListSelectorHandler.class);
    protected List<String> idsInCombo = new ArrayList<String>();
    protected List<String> idsInList = new ArrayList<String>();

    protected AdminListSelectorHandler(ListSelectorUI<B> listSelector) {
        super(listSelector);
    }

    public void init(List<B> toCombo, List<B> toList) {
        this.idsInCombo = this.extractId(toCombo);
        this.idsInList = this.extractId(toList);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
        super.init(toCombo, toList);
    }

    protected List<String> extractId(List<B> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (BusinessEntity bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put event : " + event));
        }
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receive wikitty service put event : " + wikittyId));
            }
            this.putWikitty(wikittyId, wikittyExtensions);
        }
    }

    protected abstract void putWikitty(String var1, Set<String> var2);

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            if (!this.isLoadedId(wikittyId)) continue;
            this.removeWikitty(wikittyId);
        }
    }

    public abstract void removeWikitty(String var1);

    protected boolean isLoadedId(String wikittyId) {
        return this.idsInCombo.contains(wikittyId) || this.idsInList.contains(wikittyId);
    }

    public void clearWikitty(WikittyServiceEvent wikittyServiceEvent) {
    }

    public void putExtension(WikittyServiceEvent wikittyServiceEvent) {
    }

    public void removeExtension(WikittyServiceEvent wikittyServiceEvent) {
    }

    public void clearExtension(WikittyServiceEvent wikittyServiceEvent) {
    }
}

