/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientNavigationTreeHelper
extends AdminNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    public ClientNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.CLIENT.getCategoryName(), null, new ClientsAndUsersNodeLoadors());
    }

    @Override
    public void putWikitty(final String wikittyId, Set<String> wikittyExtensions) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put event : " + wikittyId));
        }
        if (wikittyExtensions.contains("Client")) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    VradiTreeNode existingNode = (VradiTreeNode)ClientNavigationTreeHelper.this.findNode(ClientNavigationTreeHelper.this.getRootNode(), new String[]{wikittyId});
                    if (existingNode != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Client modification occured");
                        }
                        ClientNavigationTreeHelper.this.refresh(existingNode);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Client creation occured");
                        }
                        ClientNavigationTreeHelper.this.createClientNode(wikittyId, true);
                    }
                }
            });
        }
        if (wikittyExtensions.contains("User")) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    VradiTreeNode existingNode = (VradiTreeNode)ClientNavigationTreeHelper.this.findNode(ClientNavigationTreeHelper.this.getRootNode(), new String[]{wikittyId});
                    if (existingNode != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"User modification occured");
                        }
                        ClientNavigationTreeHelper.this.refresh(existingNode);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"User creation occured");
                        }
                        ClientNavigationTreeHelper.this.createUserNode(wikittyId, false);
                    }
                }
            });
        }
    }
}

