/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType itemType;
    private int cardinality;
    private RoleLocator role;
    private int count = 0;
    private int level = 0;
    private HashSet checkedElements = new HashSet(10);

    public void setRequiredType(ItemType itemType, int n, RoleLocator roleLocator) {
        this.itemType = itemType;
        this.cardinality = n;
        this.role = roleLocator;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n3);
            }
            CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(2, n, this.getNamePool()), 23, new ContentTypeTest(2, this.getConfiguration().getSchemaType(n2), this.getConfiguration()));
            this.checkItemType(combinedNodeTest, n3);
        }
        super.attribute(n, n2, charSequence, n3, n4);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n);
            }
            NodeKindTest nodeKindTest = NodeKindTest.TEXT;
            this.checkItemType(nodeKindTest, n);
        }
        super.characters(charSequence, n, n2);
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n);
            }
            NodeKindTest nodeKindTest = NodeKindTest.COMMENT;
            this.checkItemType(nodeKindTest, n);
        }
        super.comment(charSequence, n, n2);
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0);
            }
            NodeKindTest nodeKindTest = NodeKindTest.NAMESPACE;
            this.checkItemType(nodeKindTest, 0);
        }
        super.namespace(n, n2);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n);
            }
            NodeKindTest nodeKindTest = NodeKindTest.PROCESSING_INSTRUCTION;
            this.checkItemType(nodeKindTest, n);
        }
        super.processingInstruction(string, charSequence, n, n2);
    }

    public void startDocument(int n) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0);
            }
            NodeKindTest nodeKindTest = NodeKindTest.DOCUMENT;
            this.checkItemType(nodeKindTest, 0);
        }
        ++this.level;
        super.startDocument(n);
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 1) {
                CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(1, n, this.getNamePool()), 23, new ContentTypeTest(1, this.getConfiguration().getSchemaType(n2), this.getConfiguration()));
                this.checkItemType(combinedNodeTest, n3);
            } else {
                Long l;
                if (this.count == 2) {
                    this.checkAllowsMany(n3);
                }
                if (!this.checkedElements.contains(l = new Long((long)(n & 0xFFFFF) << 32 | (long)(n2 & 0xFFFFF)))) {
                    CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(1, n, this.getNamePool()), 23, new ContentTypeTest(1, this.getConfiguration().getSchemaType(n2), this.getConfiguration()));
                    this.checkItemType(combinedNodeTest, n3);
                    this.checkedElements.add(l);
                }
            }
        }
        ++this.level;
        super.startElement(n, n2, n3, n4);
    }

    public void endDocument() throws XPathException {
        --this.level;
        super.endDocument();
    }

    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
            DynamicError dynamicError = new DynamicError("An empty sequence is not allowed as the " + this.role.getMessage());
            String string = this.role.getErrorCode();
            dynamicError.setErrorCode(string);
            if (!"XPDY0050".equals(string)) {
                dynamicError.setIsTypeError(true);
            }
            throw dynamicError;
        }
    }

    public void append(Item item, int n, int n2) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n);
            }
            this.checkItemType(Value.asValue(item).getItemType(this.getNamePool().getTypeHierarchy()), n);
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, n, n2);
        } else {
            super.append(item, n, n2);
        }
    }

    private void checkItemType(ItemType itemType, int n) throws DynamicError {
        if (!this.getNamePool().getTypeHierarchy().isSubType(itemType, this.itemType)) {
            String string = this.role.composeErrorMessage(this.itemType, itemType, this.getNamePool());
            String string2 = this.role.getErrorCode();
            DynamicError dynamicError = new DynamicError(string);
            dynamicError.setErrorCode(string2);
            if (!"XPDY0050".equals(string2)) {
                dynamicError.setIsTypeError(true);
            }
            dynamicError.setLocator(ExpressionLocation.getSourceLocator(n, this.getPipelineConfiguration().getLocationProvider()));
            throw dynamicError;
        }
    }

    private void checkAllowsMany(int n) throws XPathException {
        if (!Cardinality.allowsMany(this.cardinality)) {
            DynamicError dynamicError = new DynamicError("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            String string = this.role.getErrorCode();
            dynamicError.setErrorCode(string);
            if (!"XPDY0050".equals(string)) {
                dynamicError.setIsTypeError(true);
            }
            dynamicError.setLocator(ExpressionLocation.getSourceLocator(n, this.getPipelineConfiguration().getLocationProvider()));
            throw dynamicError;
        }
    }
}

