/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.variables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;

public class ListVariable
extends Variable {
    private List<Variable> list = new ArrayList<Variable>();
    private String cachedStringRepresentation = null;

    public ListVariable() {
    }

    public ListVariable(List list) {
        if (list != null) {
            for (Object object : list) {
                Variable var = object instanceof Variable ? (Variable)object : new NodeVariable(object);
                if (var.isEmpty()) continue;
                this.list.add(var);
            }
        }
    }

    @Override
    public String toString() {
        if (this.cachedStringRepresentation == null) {
            StringBuffer buffer = new StringBuffer();
            for (Variable var : this.list) {
                String value = var.toString();
                if (value.length() == 0) continue;
                if (buffer.length() != 0) {
                    buffer.append('\n');
                }
                buffer.append(value);
            }
            this.cachedStringRepresentation = buffer.toString();
        }
        return this.cachedStringRepresentation;
    }

    public String toString(String charset, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (Variable var : this.list) {
            String value = var.toString(charset);
            if (value.length() == 0) continue;
            if (buffer.length() != 0) {
                buffer.append(delimiter);
            }
            buffer.append(value);
        }
        return buffer.toString();
    }

    @Override
    public String toString(String charset) {
        return this.toString(charset, "\n");
    }

    @Override
    public byte[] toBinary(String charset) {
        byte[] result = null;
        for (Variable currVar : this.list) {
            byte[] curr = charset == null ? currVar.toBinary() : currVar.toBinary(charset);
            if (curr == null) continue;
            if (result == null) {
                result = curr;
                continue;
            }
            byte[] newResult = new byte[result.length + curr.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(curr, 0, newResult, result.length, curr.length);
            result = newResult;
        }
        return result;
    }

    @Override
    public byte[] toBinary() {
        return this.toBinary(null);
    }

    @Override
    public List toList() {
        return this.list;
    }

    @Override
    public boolean isEmpty() {
        for (Variable var : this.list) {
            if (var.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void addVariable(Variable variable) {
        this.cachedStringRepresentation = null;
        if (variable instanceof ListVariable) {
            this.list.addAll(((ListVariable)variable).getList());
        } else {
            this.list.add(variable == null ? EmptyVariable.INSTANCE : variable);
        }
    }

    private Collection getList() {
        return this.list;
    }

    public boolean contains(Object item) {
        for (Variable currVariable : this.list) {
            if (currVariable == null || !currVariable.toString().equals(item.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getWrappedObject() {
        return this.list;
    }

    public Variable get(int index) {
        return this.list.get(index);
    }
}

