/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.webharvest.definition.FileDef;
import org.webharvest.exception.FileException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class FileProcessor
extends BaseProcessor {
    private FileDef fileDef;

    public FileProcessor(FileDef fileDef) {
        super(fileDef);
        this.fileDef = fileDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        String workingDir = scraper.getWorkingDir();
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        String action = BaseTemplater.execute(this.fileDef.getAction(), scriptEngine);
        String filePath = BaseTemplater.execute(this.fileDef.getPath(), scriptEngine);
        String type = BaseTemplater.execute(this.fileDef.getType(), scriptEngine);
        String charset = BaseTemplater.execute(this.fileDef.getCharset(), scriptEngine);
        if (charset == null) {
            charset = scraper.getConfiguration().getCharset();
        }
        String listFilter = BaseTemplater.execute(this.fileDef.getListFilter(), scriptEngine);
        String listFiles = BaseTemplater.execute(this.fileDef.getListFiles(), scriptEngine);
        boolean isListFiles = CommonUtil.getBooleanValue(listFiles, true);
        String listDirs = BaseTemplater.execute(this.fileDef.getListDirs(), scriptEngine);
        boolean isListDirs = CommonUtil.getBooleanValue(listDirs, true);
        String listRecursive = BaseTemplater.execute(this.fileDef.getListRecursive(), scriptEngine);
        boolean isListRecursive = CommonUtil.getBooleanValue(listRecursive, false);
        this.setProperty("Action", action);
        this.setProperty("File Path", filePath);
        this.setProperty("Type", type);
        this.setProperty("Charset", charset);
        this.setProperty("List Files", isListFiles);
        this.setProperty("List Directories", isListDirs);
        this.setProperty("List Recursive", isListRecursive);
        String fullPath = CommonUtil.getAbsoluteFilename(workingDir, filePath);
        if ("write".equalsIgnoreCase(action)) {
            return this.executeFileWrite(false, scraper, context, fullPath, type, charset);
        }
        if ("append".equalsIgnoreCase(action)) {
            return this.executeFileWrite(true, scraper, context, fullPath, type, charset);
        }
        if ("list".equalsIgnoreCase(action)) {
            return this.executeFileList(filePath, listFilter, isListFiles, isListDirs, isListRecursive);
        }
        return this.executeFileRead(fullPath, type, charset, scraper);
    }

    private Variable executeFileList(String filePath, String listFilter, boolean listFiles, boolean listDirs, boolean listRecursive) {
        File dir = new File(filePath);
        if (!dir.exists()) {
            throw new FileException("Directory \"" + dir + "\" doesn't exist!");
        }
        if (!dir.isDirectory()) {
            throw new FileException("\"" + dir + "\" is not directory!");
        }
        Collection collection = this.listFiles(dir, new CommandPromptFilenameFilter(listFilter), listRecursive);
        TreeSet<String> sortedFileNames = new TreeSet<String>();
        for (File file : collection) {
            boolean isDir = file.isDirectory();
            if (!listDirs && isDir || !listFiles && !isDir) continue;
            sortedFileNames.add(file.getAbsolutePath());
        }
        return new ListVariable(new ArrayList(sortedFileNames));
    }

    private Variable executeFileWrite(boolean append, Scraper scraper, ScraperContext context, String fullPath, String type, String charset) {
        try {
            byte[] data;
            NodeVariable result;
            new File(CommonUtil.getDirectoryFromPath(fullPath)).mkdirs();
            FileOutputStream out = new FileOutputStream(fullPath, append);
            if ("binary".equalsIgnoreCase(type)) {
                Variable bodyListVar = new BodyProcessor(this.fileDef).execute(scraper, context);
                result = this.appendBinary(bodyListVar);
                data = ((Variable)result).toBinary();
            } else {
                Variable body = this.getBodyTextContent(this.fileDef, scraper, context);
                String content = body.toString();
                data = content.getBytes(charset);
                result = new NodeVariable(content);
            }
            out.write(data);
            out.flush();
            out.close();
            return result;
        }
        catch (IOException e) {
            throw new FileException("Error writing data to file: " + fullPath, e);
        }
    }

    private Variable executeFileRead(String fullPath, String type, String charset, Scraper scraper) {
        if ("binary".equalsIgnoreCase(type)) {
            try {
                byte[] data = CommonUtil.readBytesFromFile(new File(fullPath));
                if (scraper.getLogger().isInfoEnabled()) {
                    scraper.getLogger().info((Object)("Binary file read processor: " + data.length + " bytes read."));
                }
                return new NodeVariable(data);
            }
            catch (IOException e) {
                throw new FileException("Error reading file: " + fullPath, e);
            }
        }
        try {
            String content = CommonUtil.readStringFromFile(new File(fullPath), charset);
            if (scraper.getLogger().isInfoEnabled()) {
                scraper.getLogger().info((Object)("Text file read processor: " + (content == null ? 0 : content.length()) + " characters read."));
            }
            return new NodeVariable(content);
        }
        catch (IOException e) {
            throw new FileException("Error reading the file: " + fullPath, e);
        }
    }

    public NodeVariable appendBinary(Variable body) {
        if (body == null) {
            return new NodeVariable("");
        }
        byte[] result = null;
        for (Variable currVariable : body.toList()) {
            byte[] bytes = currVariable.toBinary();
            if (bytes == null) continue;
            if (result == null) {
                result = bytes;
                continue;
            }
            byte[] newResult = new byte[result.length + bytes.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(bytes, 0, newResult, result.length, bytes.length);
            result = newResult;
        }
        return new NodeVariable(result);
    }

    private Collection listFiles(File directory, FilenameFilter filter, boolean recurse) {
        Vector<File> files = new Vector<File>();
        File[] entries = directory.listFiles();
        if (entries != null) {
            for (int f = 0; f < entries.length; ++f) {
                File entry = entries[f];
                if (filter == null || filter.accept(directory, entry.getName())) {
                    files.add(entry);
                }
                if (!recurse || !entry.isDirectory()) continue;
                files.addAll(this.listFiles(entry, filter, recurse));
            }
        }
        return files;
    }

    private class CommandPromptFilenameFilter
    implements FilenameFilter {
        Pattern pattern = Pattern.compile(".*");

        private CommandPromptFilenameFilter(String filter) {
            if (!CommonUtil.isEmpty(filter)) {
                StringBuffer buffer = new StringBuffer();
                block7: for (int i = 0; i < filter.length(); ++i) {
                    char ch = filter.charAt(i);
                    switch (ch) {
                        case '.': {
                            buffer.append("\\.");
                            continue block7;
                        }
                        case '*': {
                            buffer.append(".*");
                            continue block7;
                        }
                        case '?': {
                            buffer.append(".");
                            continue block7;
                        }
                        default: {
                            buffer.append(ch);
                        }
                    }
                }
                try {
                    this.pattern = Pattern.compile(buffer.toString());
                }
                catch (Exception e) {
                    this.pattern = Pattern.compile("");
                }
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).matches();
        }
    }
}

