/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: VradiServiceConfigurationHelper.java 1835 2010-12-21 09:28:19Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-services/src/main/java/com/jurismarches/vradi/VradiServiceConfigurationHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfig;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import static com.jurismarches.vradi.VradiServiceConfiguration.VradiServiceOption;

/**
 * @author sletellier
 */
public class VradiServiceConfigurationHelper {

    /**
     * Get current application version as string.
     *
     * @param config vradi service configuration
     * @return version
     */
    public static String getApplicationVersion(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.APPLICATION_VERSION.key);
    }

    /**
     * Get last saved version as string (last launch).
     *
     * @param config vradi service configuration
     * @return version
     */
    public static String getServiceVersion(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.SERVICE_VERSION.key);
    }

    /**
     * Set service version.
     *
     * @param config vradi service configuration
     * @param version version to set
     */
    public static void setServiceVersion(ApplicationConfig config, String version) {
        config.setOption(VradiServiceOption.SERVICE_VERSION.key, version);
    }

    public static String getDataDir(ApplicationConfig config) {
        String option = config.getOption(VradiServiceOption.DATA_DIR.key);
        return option;
    }
    public static File getDataDirAsFile(ApplicationConfig config) {
        File option = config.getOptionAsFile(VradiServiceOption.DATA_DIR.key);
        return option;
    }

    public static Locale getLocale(ApplicationConfig config) {
        Locale result = config.getOption(Locale.class, VradiServiceOption.LOCALE.key);
        return result;
    }

    public static void setLocale(ApplicationConfig config, Locale locale) {
        config.setOption(VradiServiceOption.LOCALE.key, locale.toString());
    }

    public static File getAttachmentsDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.ATTACHEMENTS_DIR.key);
    }

    public static File getEmbeddedFilesDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.EMBEDDED_DIR.key);
    }

    public static File getQueryHistoryDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.QUERY_HISTORY_DIR.key);
    }

    public static File getTemplatesDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.TEMPLATE_DIR.key);
    }

    public static File getPdfDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.PDF_DIR.key);
    }

    public static File getTempDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.TEMP_DIR.key);
    }

    public static File getExportCSVDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.EXPORT_CSV_DIR.key);
    }

    public static File getImportCSVDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.IMPORT_CSV_DIR.key);
    }

    public static File getWebHarvestPreviewDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.WEB_HARVERT_SCRIPT_PREVIEW_DIR.key);
    }

    public static File getWebHarvestScriptDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceOption.WEB_HARVERT_SCRIPT_DIR.key);
    }

    public static String getOpenOfficeExecDir(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.OOO_DIR.key);
    }

    public static String getSmtpHost(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.SMTP_HOST.key);
    }

    public static int getSmtpPort(ApplicationConfig config) {
        return config.getOptionAsInt(VradiServiceOption.SMTP_PORT.key);
    }

    public static String getImapHost(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.IMAP_HOST.key);
    }

    public static int getImapPort(ApplicationConfig config) {
        return config.getOptionAsInt(VradiServiceOption.IMAP_PORT.key);
    }

    public static String getMailUser(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.MAIL_USER.key);
    }

    public static String getMailFrom(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.MAIL_FROM.key);
    }

    public static String getMailFromName(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.MAIL_FROM_NAME.key);
    }

    public static String getMailPassword(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.MAIL_PASSWORD.key);
    }

    public static String getOfferMailSubject(ApplicationConfig config) {
        String result = config.getOption(VradiServiceOption.MAIL_OFFER_SUBJECT.key);
        return result;
    }

    public static boolean isMailDebug(ApplicationConfig config) {
        return config.getOptionAsBoolean(VradiServiceOption.MAIL_DEBUG.key);
    }

    public static List<String> getMailAdmin(ApplicationConfig config) {
        return getOptionAsList(config, VradiServiceOption.MAIL_ADMIN.key);
    }

    public static void addMailAdmin(ApplicationConfig config, String email) {
        addOptionAsList(config, VradiServiceOption.MAIL_ADMIN.key, email);
    }

    public static String getSessionDefaultParagraph(ApplicationConfig config) {
        return config.getOption(VradiServiceOption.SESSION_DEFAULT_PARAGRAPH.key);
    }

    public static boolean skipMigration(ApplicationConfig config) {
        return config.getOptionAsBoolean(VradiServiceOption.SKIP_MIGRATION.key);
    }
    
    public static List<String> getOptionAsList(ApplicationConfig config, String key) {

        List<String> result = new ArrayList<String>();
        String admins = config.getOption(key);
        if (admins != null && !admins.isEmpty()) {
            if (admins.contains(", ")) {
                String[] strings = admins.split(", ");
                result = Arrays.asList(strings);
            } else {
                result.add(admins);
            }
        }
        return result;
    }

    protected static void addOptionAsList(ApplicationConfig config, String key, String value) {
        List<String> list = getOptionAsList(config, key);
        list.add(value);

        String values = StringUtil.join(list, ", ", false);

        config.setOption(key, values);
    }

    /*
     * TODO sletellier 22/11/10 : Move this in wikitty
     */
    public static void setWikittyEventPropagate(ApplicationConfig config, boolean b) {
        config.setOption(WikittyConfig.WikittyOption.WIKITTY_EVENT_PROPAGATE.key, String.valueOf(b));
    }

    public static Boolean getWikittyEventPropagate(ApplicationConfig config) {
        return config.getOptionAsBoolean(WikittyConfig.WikittyOption.WIKITTY_EVENT_PROPAGATE.key);
    }

    public static String getWikittyEventTransporterXMPPServer(ApplicationConfig config) {
        return config.getOption(WikittyConfig.WikittyOption.WIKITTY_EVENT_TRANSPORTER_XMPP_SERVER.key);
    }

    public static String getWikittyEventTransporterXMPPRoom(ApplicationConfig config) {
        return config.getOption(WikittyConfig.WikittyOption.WIKITTY_EVENT_TRANSPORTER_XMPP_ROOM.key);
    }
}
