/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.Like;
import org.nuiton.wikitty.services.WikittyEvent;

public class ThesaurusManager {
    private static final Log log = LogFactory.getLog(ThesaurusManager.class);
    protected WikittyProxy wikittyProxy;

    public ThesaurusManager(WikittyProxy proxy) {
        this.wikittyProxy = proxy;
    }

    public List<RootThesaurus> getRootThesaurus() throws VradiException {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "RootThesaurus");
        Criteria criteria = search.criteria();
        criteria.addSortAscending("WikittyTreeNode.name");
        PagedResult rootThesaurusResult = this.wikittyProxy.findAllByCriteria(RootThesaurus.class, criteria);
        List rootThesaurus = rootThesaurusResult.getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root thesaurus list : " + rootThesaurus));
        }
        return rootThesaurus;
    }

    public List<Thesaurus> getThesaurusAttachedToForm(Form form) {
        Search searchThesaurus = Search.query();
        searchThesaurus.eq("WikittyTreeNode.attachment", form.getWikittyId());
        Criteria criteria = searchThesaurus.criteria();
        criteria.addSortAscending("WikittyTreeNode.name");
        PagedResult findAllByCriteria = this.wikittyProxy.findAllByCriteria(Thesaurus.class, criteria);
        List thesaurus = findAllByCriteria.getAll();
        return thesaurus;
    }

    public Thesaurus getThesaurus(String thesaurusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusId + ")"));
        }
        Thesaurus node = (Thesaurus)this.wikittyProxy.restore(Thesaurus.class, thesaurusId);
        return node;
    }

    public List<Thesaurus> getThesaurus(List<String> thesaurusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusIds + ")"));
        }
        List nodes = this.wikittyProxy.restore(Thesaurus.class, thesaurusIds);
        return nodes;
    }

    public List<Thesaurus> getChildrenThesaurus(String thesaurusId) throws VradiException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getChildrenThesaurus(" + thesaurusId + ")"));
        }
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Thesaurus");
        query.eq("WikittyTreeNode.parent", thesaurusId);
        Criteria criteria = query.criteria();
        criteria.addSortAscending("Thesaurus.order");
        criteria.addSortAscending("WikittyTreeNode.name");
        PagedResult nodes = this.wikittyProxy.findAllByCriteria(Thesaurus.class, criteria);
        List all = nodes.getAll();
        return all;
    }

    public Collection<String> deleteThesaurus(String thesaurusId) throws VradiException {
        WikittyEvent wikittyEvent = this.wikittyProxy.deleteTree(thesaurusId);
        Map wikittyMap = wikittyEvent.getRemoveDate();
        if (wikittyMap != null) {
            return wikittyMap.keySet();
        }
        return Collections.EMPTY_LIST;
    }

    public void deleteAllThesaurus() throws VradiException {
        List<RootThesaurus> rootThesauruses = this.getRootThesaurus();
        for (RootThesaurus rootThesaurus : rootThesauruses) {
            this.wikittyProxy.deleteTree(rootThesaurus.getWikittyId());
        }
    }

    public int getNbFormsForThesaurus(String thesaurusId) throws VradiException {
        Map.Entry entry;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getNbFormsForThesaurus(" + thesaurusId + ")"));
        }
        if ((entry = this.wikittyProxy.restoreNode(Thesaurus.class, thesaurusId, null)) == null) {
            return 0;
        }
        return (Integer)entry.getValue();
    }

    public List<Thesaurus> proposeThesaurus(String formId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proposeThesaurus(form)");
        }
        Search canditateSearch = Search.query();
        canditateSearch.bw("Thesaurus.tags", "*", "*");
        canditateSearch.neq("WikittyTreeNode.attachment", formId);
        Criteria candidateCriteria = canditateSearch.criteria();
        PagedResult pagedResult = this.wikittyProxy.findAllByCriteria(Thesaurus.class, candidateCriteria);
        List canditateThesauruses = pagedResult.getAll();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Form").eq(Element.ELT_ID, formId).criteria();
        for (Thesaurus canditateThesaurus : canditateThesauruses) {
            Set<String> tags = canditateThesaurus.getTags();
            Search tagSearch = Search.query((Search.KIND)Search.KIND.OR);
            for (String string : tags) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                tagSearch = tagSearch.keyword(string);
            }
            Criteria facetCriteria = tagSearch.criteria(canditateThesaurus.getWikittyId());
            criteria.addFacetCriteria(facetCriteria);
        }
        criteria.setEndIndex(0);
        PagedResult forms = this.wikittyProxy.findAllByCriteria(Form.class, criteria);
        List<Thesaurus> result = new ArrayList<Thesaurus>();
        if (forms != null && forms.getNumFound() > 0) {
            ArrayList<String> thesaurusIds = new ArrayList<String>();
            Map facetsMap = forms.getFacets();
            block2: for (Map.Entry entry : facetsMap.entrySet()) {
                List facetTopics = (List)entry.getValue();
                for (FacetTopic facetTopic : facetTopics) {
                    if (facetTopic.getCount() <= 0) continue;
                    thesaurusIds.add(facetTopic.getTopicName());
                    continue block2;
                }
            }
            if (!thesaurusIds.isEmpty()) {
                result = this.getThesaurus(thesaurusIds);
            }
        }
        return result;
    }

    public Map<Group, List<QueryBean>> getQueriesToModifyAfterThesaurusModification(String rootThesaurusName, String thesaurusName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getQueriesToModifyAfterThesaurusModification(" + rootThesaurusName + ", " + thesaurusName + ")"));
        }
        HashMap<Group, List<QueryBean>> results = new HashMap<Group, List<QueryBean>>();
        if (rootThesaurusName == null) {
            return results;
        }
        String requestPart = rootThesaurusName + ":" + (thesaurusName == null ? "" : thesaurusName);
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Group").like("QueryMaker.queries", requestPart, Like.SearchAs.AsText).criteria();
        PagedResult pagedResult = this.wikittyProxy.findAllByCriteria(Group.class, criteria);
        List groups = pagedResult.getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[getQueriesToModifyAfterThesaurusModification]  " + groups.size() + "Groups found for request part requestPart : " + requestPart));
        }
        for (Group group : groups) {
            Set<String> queries = group.getQueries();
            ArrayList<QueryBean> queriesToModify = new ArrayList<QueryBean>();
            for (String query : queries) {
                try {
                    QueryBean queryBean = new QueryBean(query, group.getWikittyId());
                    FilterList filter = VradiQueryParser.parse(queryBean.getQuery());
                    if (!this.isThesaurusInQuery(filter, rootThesaurusName, thesaurusName)) continue;
                    queriesToModify.add(queryBean);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (queriesToModify.isEmpty()) continue;
            results.put(group, queriesToModify);
        }
        return results;
    }

    protected boolean isThesaurusInQuery(FilterList list, String rootThesaurusName, String thesaurusName) {
        boolean insideQuery = false;
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                insideQuery = this.isThesaurusInQuery((FilterList)filter, rootThesaurusName, thesaurusName);
            } else if (filter instanceof CompareFilter) {
                insideQuery = this.isThesaurusInQuery((CompareFilter)filter, rootThesaurusName, thesaurusName);
            }
            if (!insideQuery) continue;
            break;
        }
        return insideQuery;
    }

    protected boolean isThesaurusInQuery(CompareFilter compareFilter, String rootThesaurusName, String thesaurusName) {
        boolean result;
        String name = compareFilter.getName();
        String value = compareFilter.getValue();
        boolean bl = result = rootThesaurusName.equals(name) && (thesaurusName == null || thesaurusName.equals(value));
        if (log.isDebugEnabled()) {
            log.debug((Object)("[isThesaurusInQuery] Root Thesaurus name : " + rootThesaurusName + " name : " + name + " ThesaurusName : " + thesaurusName + " value : " + value + " result : " + result));
        }
        return result;
    }

    protected void replaceThesaurusInQuery(FilterList list, String oldRootThesaurusName, String newRootThesaurusName, String oldThesaurusName, String newThesaurusName) {
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                this.replaceThesaurusInQuery((FilterList)filter, oldRootThesaurusName, newRootThesaurusName, oldThesaurusName, newThesaurusName);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            this.replaceThesaurusInQuery((CompareFilter)filter, oldRootThesaurusName, newRootThesaurusName, oldThesaurusName, newThesaurusName);
        }
    }

    protected void replaceThesaurusInQuery(CompareFilter compareFilter, String oldRootThesaurusName, String newRootThesaurusName, String oldThesaurusName, String newThesaurusName) {
        String name;
        String value = compareFilter.getValue();
        if (value.equals(oldThesaurusName) && oldRootThesaurusName.equals(name = compareFilter.getName())) {
            compareFilter.setName(newRootThesaurusName);
            compareFilter.setValue(newThesaurusName);
        }
    }

    public RootThesaurus createRootThesaurus(String rootThesaurusName) throws VradiException {
        if (rootThesaurusName == null) {
            throw new VradiException("Null root thesaurus name");
        }
        if (!rootThesaurusName.matches("\\w+")) {
            throw new VradiException("Root thesaurus name contains invalid characters : " + rootThesaurusName);
        }
        if (this.isRootThesaurusNameExists(rootThesaurusName, null)) {
            throw new VradiException("Root thesaurus \"" + rootThesaurusName + "\" already exists");
        }
        RootThesaurus newRootThesaurus = new RootThesaurusImpl();
        newRootThesaurus.setName(rootThesaurusName);
        newRootThesaurus = (RootThesaurus)this.wikittyProxy.store((BusinessEntity)newRootThesaurus);
        return newRootThesaurus;
    }

    public boolean isRootThesaurusNameExists(String rootThesaurusName) {
        return this.isRootThesaurusNameExists(rootThesaurusName, null);
    }

    public boolean isRootThesaurusNameExists(String rootThesaurusName, String exceptedRootThesaurusId) {
        Search query = Search.query();
        query = query.eq(Element.ELT_EXTENSION, "RootThesaurus");
        query = query.eq("WikittyTreeNode.name", rootThesaurusName);
        if (exceptedRootThesaurusId != null) {
            query = query.neq(Element.ELT_ID, exceptedRootThesaurusId);
        }
        Criteria criteria = query.criteria();
        criteria.setFirstIndex(0);
        criteria.setEndIndex(0);
        PagedResult pagedResults = this.wikittyProxy.findAllByCriteria(criteria);
        boolean result = false;
        if (pagedResults.getNumFound() > 0) {
            result = true;
        }
        return result;
    }

    public boolean isThesaurusNameExistsInRootThesaurus(RootThesaurus rootThesaurus, String thesaurusName) {
        return this.isThesaurusNameExistsInRootThesaurus(rootThesaurus, thesaurusName, null);
    }

    public boolean isThesaurusNameExistsInRootThesaurus(RootThesaurus rootThesaurus, String thesaurusName, String exceptedThesaurusId) {
        Search query = Search.query();
        query = query.eq(Element.ELT_EXTENSION, "Thesaurus");
        query = query.eq("Thesaurus.rootThesaurus", rootThesaurus.getWikittyId());
        query = query.eq("WikittyTreeNode.name", thesaurusName);
        if (exceptedThesaurusId != null) {
            query = query.neq(Element.ELT_ID, exceptedThesaurusId);
        }
        Criteria criteria = query.criteria();
        criteria.setFirstIndex(0);
        criteria.setEndIndex(0);
        PagedResult pagedResults = this.wikittyProxy.findAllByCriteria(criteria);
        boolean result = false;
        if (pagedResults.getNumFound() > 0) {
            result = true;
        }
        return result;
    }
}

