/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.solr.Restriction2Solr;
import org.nuiton.wikitty.storage.solr.SolrResource;
import org.nuiton.wikitty.storage.solr.SolrUtil;
import org.nuiton.wikitty.storage.solr.TypeFieldModifier;
import org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr;

public class WikittySearchEngineSolrIndexInTreeNode
implements WikittySearchEngine {
    private static Log log = LogFactory.getLog(WikittySearchEngineSolr.class);
    public static final String[] fieldToCopyPattern = new String[]{"#id", "#extensions", "#not_null_fields", ".*_bi", ".*_b", ".*_dt", ".*_d", ".*_s", ".*_w"};
    public static final String[] fieldToCopyPatternWithExcludeAll = new String[]{"#id", "#extensions", "#not_null_fields", "(?!(#all\\.)).*_bi", "(?!(#all\\.)).*_b", "(?!(#all\\.)).*_dt", "(?!(#all\\.)).*_d", "(?!(#all\\.)).*_s", "(?!(#all\\.)).*_w"};
    protected SolrServer solrServer;
    protected TypeFieldModifier fieldModifier;
    protected SolrResource solrResource;

    public WikittySearchEngineSolrIndexInTreeNode(ApplicationConfig config, WikittyExtensionStorage extensionStorage) {
        if (config != null) {
            String solrDataDirKey;
            String solrDataDir;
            String solrDirFactoryKey = WikittyConfig.WikittyOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY.getKey();
            String solrDirFactory = config.getOption(solrDirFactoryKey);
            if (solrDirFactory != null) {
                System.setProperty(solrDirFactoryKey, solrDirFactory);
            }
            if (solrDirFactory != null && !solrDirFactory.contains("RAMDirectoryFactory") && (solrDataDir = config.getOption(solrDataDirKey = WikittyConfig.WikittyOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_DATA.getKey())) != null) {
                File file = new File(solrDataDir);
                file.mkdirs();
                System.setProperty(solrDataDirKey, solrDataDir);
            }
        }
        try {
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            CoreContainer coreContainer = initializer.initialize();
            this.solrServer = new EmbeddedSolrServer(coreContainer, "");
            this.fieldModifier = new TypeFieldModifier(extensionStorage);
            this.solrResource = new SolrResource(this.solrServer);
        }
        catch (Exception eee) {
            throw new WikittyException("SolR initialization error", (Throwable)eee);
        }
    }

    public void clear(WikittyTransaction transaction) {
        try {
            this.solrResource.init();
            this.solrServer.deleteByQuery("*:*");
        }
        catch (Exception eee) {
            throw new WikittyException("Error during clearing SolR data", (Throwable)eee);
        }
    }

    public void store(WikittyTransaction transaction, Collection<Wikitty> wikitties) {
        try {
            this.solrResource.init();
            LinkedHashSet<String> treeNodeToIndex = new LinkedHashSet<String>();
            for (Wikitty w : wikitties) {
                String id = w.getId();
                SolrInputDocument doc = this.createIndexDocument(w);
                this.solrResource.addDoc(id, doc);
                if (!WikittyTreeNodeHelper.hasExtension((Wikitty)w)) continue;
                if (w.getDirty().contains("WikittyTreeNode.parent") || null == WikittyTreeNodeHelper.getParent((Wikitty)w) || WikittyUtil.versionGreaterThan((String)"1", (String)w.getVersion())) {
                    treeNodeToIndex.add(id);
                    continue;
                }
                SolrDocument oldDoc = SolrUtil.findById(this.solrServer, id);
                String root = (String)oldDoc.getFieldValue("#tree.root");
                Collection parents = oldDoc.getFieldValues("#tree.parents");
                doc.addField("#tree.root", (Object)root);
                for (Object parent : parents) {
                    doc.addField("#tree.parents", parent);
                }
            }
            this.reindexTreeNode(this.solrResource, treeNodeToIndex);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't store wikitty", (Throwable)eee);
        }
    }

    protected String getTreeRoot(SolrResource solrResource, SolrServer solrServer, String node) throws Exception {
        String result = null;
        String parent = node;
        while (parent != null) {
            SolrInputDocument doc = solrResource.getAddedDoc(parent);
            if (doc != null) {
                result = (String)doc.getFieldValue("#tree.root");
                parent = (String)doc.getFieldValue("WikittyTreeNode.parent_w");
                continue;
            }
            SolrDocument parentDoc = SolrUtil.findById(solrServer, parent);
            result = (String)parentDoc.getFirstValue("#tree.root");
            parent = (String)parentDoc.getFieldValue("WikittyTreeNode.parent_w");
        }
        if (result == null) {
            result = node;
        }
        return result;
    }

    protected void reindexTreeNode(SolrResource solrResource, LinkedHashSet<String> treeNodeToIndex) throws Exception {
        LinkedList<String> todo = new LinkedList<String>(treeNodeToIndex);
        HashSet<String> done = new HashSet<String>();
        HashSet<String> deleted = new HashSet<String>(solrResource.getDeletedDocs());
        HashMap<String, String> tree = new HashMap<String, String>();
        while (todo.size() > 0) {
            String id = todo.poll();
            if (done.contains(id)) continue;
            done.add(id);
            SolrQuery query = new SolrQuery("{!wikitty}#tree.parents:" + id);
            QueryResponse response = this.solrServer.query((SolrParams)query);
            SolrDocumentList updateDocs = response.getResults();
            for (SolrDocument solrDocument : updateDocs) {
                String childId = (String)solrDocument.getFieldValue("#id");
                todo.offer(childId);
            }
            if (deleted.contains(id)) continue;
            SolrInputDocument doc = solrResource.getAddedDoc(id);
            if (doc == null) {
                SolrDocument found = SolrUtil.findById(this.solrServer, id);
                if (found != null) {
                    doc = SolrUtil.copySolrDocument(found, true, fieldToCopyPattern);
                    solrResource.addDoc(id, doc);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find wikitty id '" + id + "' in index. Skip this wikitty."));
                }
            }
            String root = this.getTreeRoot(solrResource, this.solrServer, id);
            doc.addField("#tree.root", (Object)root);
            String parent = id;
            while (parent != null) {
                SolrInputDocument parentDoc;
                String oldParent = parent;
                doc.addField("#tree.parents", (Object)parent);
                if (tree.containsKey(parent)) {
                    parent = (String)tree.get(parent);
                } else if (null != solrResource.getAddedDoc(parent)) {
                    parentDoc = solrResource.getAddedDoc(id);
                    parent = (String)parentDoc.getFieldValue("WikittyTreeNode.parent_w");
                } else {
                    parentDoc = SolrUtil.findById(this.solrServer, parent);
                    parent = parentDoc != null ? (String)parentDoc.getFieldValue("WikittyTreeNode.parent_w") : null;
                }
                tree.put(oldParent, parent);
            }
        }
    }

    public void delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        try {
            this.solrResource.init();
            LinkedHashSet<String> treeNodeToIndex = new LinkedHashSet<String>();
            for (String id : ids) {
                SolrDocument doc = SolrUtil.findById(this.solrServer, id);
                if (doc.containsKey((Object)"#tree.root")) {
                    treeNodeToIndex.add(id);
                }
                this.solrResource.deleteDoc(id);
            }
            this.reindexTreeNode(this.solrResource, treeNodeToIndex);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't delete wikitty in index", (Throwable)eee);
        }
    }

    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        try {
            String facetName;
            List sortDescending;
            Restriction2Solr restriction2Solr = new Restriction2Solr(transaction, this.fieldModifier);
            String queryString = restriction2Solr.toSolr(criteria.getRestriction(), this.solrServer);
            SolrQuery query = new SolrQuery("{!wikitty}" + queryString);
            int firstIndex = criteria.getFirstIndex();
            int endIndex = criteria.getEndIndex();
            query.setStart(Integer.valueOf(firstIndex));
            int nbRows = endIndex == -1 ? Integer.MAX_VALUE - firstIndex : endIndex - firstIndex + 1;
            query.setRows(Integer.valueOf(nbRows));
            List sortAscending = criteria.getSortAscending();
            if (sortAscending != null) {
                for (String sort : sortAscending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    query.addSortField(tranform, SolrQuery.ORDER.asc);
                }
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                for (String sort : sortDescending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    query.addSortField(tranform, SolrQuery.ORDER.desc);
                }
            }
            List facetField = criteria.getFacetField();
            log.debug((Object)("facetField : " + facetField));
            List facetCriteria = criteria.getFacetCriteria();
            HashMap<String, String> facetQueryToName = new HashMap<String, String>();
            if (facetField != null && !facetField.isEmpty() || facetCriteria != null && !facetCriteria.isEmpty()) {
                query.setFacet(true);
                query.setFacetMinCount(1);
                if (facetField != null) {
                    for (String fqfieldName : facetField) {
                        String tranform = this.fieldModifier.convertToSolr(transaction, fqfieldName);
                        query.addFacetField(new String[]{tranform});
                    }
                }
                if (facetCriteria != null) {
                    for (Criteria facet : facetCriteria) {
                        String queryFacet = restriction2Solr.toSolr(facet.getRestriction());
                        facetQueryToName.put(queryFacet, facet.getName());
                        query.addFacetQuery(queryFacet);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Try to execute query %s", query));
            }
            QueryResponse resp = this.solrServer.query((SolrParams)query);
            SolrDocumentList solrResults = resp.getResults();
            HashMap facets = new HashMap();
            if (facetField != null && !facetField.isEmpty()) {
                for (FacetField facetField2 : resp.getFacetFields()) {
                    facetName = this.fieldModifier.convertToField(transaction, facetField2.getName());
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    if (facetField2.getValues() != null) {
                        for (FacetField.Count value : facetField2.getValues()) {
                            String topicName = value.getName();
                            int topicCount = (int)value.getCount();
                            FacetTopic topic = new FacetTopic(facetName, topicName, topicCount);
                            topics.add(topic);
                        }
                    }
                    facets.put(facetName, topics);
                }
            }
            if (facetCriteria != null && !facetCriteria.isEmpty()) {
                for (Map.Entry entry : resp.getFacetQuery().entrySet()) {
                    facetName = (String)entry.getKey();
                    if (null != facetQueryToName.get(facetName)) {
                        facetName = (String)facetQueryToName.get(facetName);
                    }
                    Integer count = (Integer)entry.getValue();
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    FacetTopic topic = new FacetTopic(facetName, facetName, count.intValue());
                    topics.add(topic);
                    facets.put(facetName, topics);
                }
            }
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = (String)doc.getFieldValue("#id");
                ids.add(id);
            }
            int n = (int)resp.getResults().getNumFound();
            PagedResult result = new PagedResult(firstIndex, n, queryString, facets, ids);
            return result;
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Error during find", (Throwable)eee);
        }
    }

    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        try {
            int result = 0;
            String id = w.getId();
            HashSet allAttachments = new HashSet();
            SolrQuery query = new SolrQuery("{!wikitty}#tree.parents:" + id);
            QueryResponse response = this.solrServer.query((SolrParams)query);
            SolrDocumentList updateDocs = response.getResults();
            for (SolrDocument solrDocument : updateDocs) {
                Collection attachments = solrDocument.getFieldValues("WikittyTreeNode.attachment_w");
                if (attachments == null) continue;
                allAttachments.addAll(attachments);
            }
            if (filter != null) {
                Search search = Search.query((Criteria)filter);
                Search and = search.and().contains("#id", allAttachments);
                Criteria criteria = search.criteria();
                PagedResult<String> criteriaResult = this.findAllByCriteria(transaction, filter);
                allAttachments.retainAll(criteriaResult.getAll());
            }
            result = allAttachments.size();
            return result;
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Can't find node count", (Throwable)eee);
        }
    }

    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        try {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            String id = w.getId();
            HashMap allAttachments = new HashMap();
            HashSet<String> child = new HashSet<String>();
            SolrQuery query = new SolrQuery("{!wikitty}#tree.parents:" + id);
            QueryResponse response = this.solrServer.query((SolrParams)query);
            SolrDocumentList updateDocs = response.getResults();
            for (SolrDocument solrDocument : updateDocs) {
                String childId = (String)solrDocument.getFieldValue("#id");
                String parentId = (String)solrDocument.getFieldValue("WikittyTreeNode.parent_w");
                Collection attachments = solrDocument.getFieldValues("WikittyTreeNode.attachment_w");
                Collection parents = solrDocument.getFieldValues("#tree.parents");
                if (id.equals(parentId)) {
                    child.add(childId);
                }
                for (Object p : parents) {
                    String parent = (String)p;
                    HashSet col = (HashSet)allAttachments.get(parent);
                    if (col == null) {
                        col = new HashSet();
                        allAttachments.put(parent, col);
                    }
                    if (attachments == null) continue;
                    col.addAll(attachments);
                }
            }
            List filteredId = Collections.EMPTY_LIST;
            if (filter != null) {
                LinkedList attachmentIds = new LinkedList();
                Iterator i = allAttachments.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    if (child.contains(e.getKey())) {
                        attachmentIds.addAll((Collection)e.getValue());
                        continue;
                    }
                    i.remove();
                }
                if (attachmentIds.size() > 0) {
                    Search search = Search.query((Criteria)filter);
                    Search and = search.and().contains("#id", attachmentIds);
                    Criteria criteria = search.criteria();
                    PagedResult<String> criteriaResult = this.findAllByCriteria(transaction, criteria);
                    filteredId = criteriaResult.getAll();
                }
            }
            for (Map.Entry e : allAttachments.entrySet()) {
                if (!child.contains(e.getKey())) continue;
                Collection attachments = (Collection)e.getValue();
                attachments.retainAll(filteredId);
                result.put((String)e.getKey(), attachments.size());
            }
            return result;
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Can't find node count", (Throwable)eee);
        }
    }

    protected SolrInputDocument createIndexDocument(Wikitty w) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("index wikitty " + w.getId()));
        }
        SolrInputDocument doc = new SolrInputDocument();
        String id = w.getId();
        doc.addField("#id", (Object)id);
        for (String name : w.getExtensionNames()) {
            doc.addField("#extensions", (Object)name);
        }
        for (String fqfieldName : w.fieldNames()) {
            FieldType fieldType = w.getFieldType(fqfieldName);
            FieldType.TYPE type = fieldType.getType();
            String solrFqFieldName = SolrUtil.getSolrFieldName(fqfieldName, type);
            String solrAllFieldName = "#all." + WikittyUtil.getFieldNameFromFQFieldName((String)solrFqFieldName);
            Object objectValue = w.getFqField(fqfieldName);
            if (objectValue == null) continue;
            if (fieldType.isCollection()) {
                Collection collectionValue = (Collection)objectValue;
                for (Object itemValue : collectionValue) {
                    if (itemValue == null) continue;
                    doc.addField(solrFqFieldName, itemValue);
                    doc.addField(solrAllFieldName, itemValue);
                    doc.addField("#not_null_fields", (Object)fqfieldName);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("index field " + solrFqFieldName + " with value '" + itemValue + "'"));
                }
                continue;
            }
            doc.addField(solrFqFieldName, objectValue);
            doc.addField(solrAllFieldName, objectValue);
            doc.addField("#not_null_fields", (Object)fqfieldName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("index field " + solrFqFieldName + " with value '" + objectValue + "'"));
        }
        return doc;
    }
}

