/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.util.ByteUtils;

public class CreateUser
extends DefineCommand {
    private String userName;
    private boolean admin;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean ifNotExists;
    private String comment;

    public CreateUser(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(Expression expression) {
        this.password = expression;
    }

    private char[] getCharArray(Expression expression) throws SQLException {
        return expression.optimize(this.session).getValue(this.session).getString().toCharArray();
    }

    private byte[] getByteArray(Expression expression) throws SQLException {
        return ByteUtils.convertStringToBytes(expression.optimize(this.session).getValue(this.session).getString());
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (database.findRole(this.userName) != null) {
            throw Message.getSQLException(90069, this.userName);
        }
        if (database.findUser(this.userName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90033, this.userName);
        }
        int n = this.getObjectId(false, true);
        User user = new User(database, n, this.userName, false);
        user.setAdmin(this.admin);
        user.setComment(this.comment);
        if (this.hash != null && this.salt != null) {
            user.setSaltAndHash(this.getByteArray(this.salt), this.getByteArray(this.hash));
        } else if (this.password != null) {
            SHA256 sHA256 = new SHA256();
            char[] cArray = this.getCharArray(this.password);
            byte[] byArray = sHA256.getKeyPasswordHash(this.userName, cArray);
            user.setUserPasswordHash(byArray);
        } else {
            throw Message.throwInternalError();
        }
        database.addDatabaseObject(this.session, user);
        return 0;
    }

    public void setSalt(Expression expression) {
        this.salt = expression;
    }

    public void setHash(Expression expression) {
        this.hash = expression;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }
}

