/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.entities;

import com.jurismarches.vradi.entities.ThesaurusAbstract;
import java.util.Set;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;

public class ThesaurusHelper {
    private ThesaurusHelper() {
    }

    public static Set<String> getTags(Wikitty wikitty) {
        Set result = wikitty.getFieldAsSet("Thesaurus", "tags", String.class);
        return result;
    }

    public static void setTags(Wikitty wikitty, Set<String> tags) {
        ThesaurusHelper.clearTags(wikitty);
        ThesaurusHelper.addAllTags(wikitty, tags);
    }

    public static void addAllTags(Wikitty wikitty, Set<String> tags) {
        if (tags != null) {
            for (String id : tags) {
                ThesaurusHelper.addTags(wikitty, id);
            }
        }
    }

    public static void addTags(Wikitty wikitty, String element) {
        wikitty.addToField("Thesaurus", "tags", (Object)element);
    }

    public static void removeTags(Wikitty wikitty, String element) {
        wikitty.removeFromField("Thesaurus", "tags", (Object)element);
    }

    public static void clearTags(Wikitty wikitty) {
        wikitty.clearField("Thesaurus", "tags");
    }

    public static int getOrder(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt("Thesaurus", "order");
        return value;
    }

    public static int setOrder(Wikitty wikitty, int order) {
        int oldValue = ThesaurusHelper.getOrder(wikitty);
        wikitty.setField("Thesaurus", "order", (Object)order);
        return oldValue;
    }

    public static String getComment(Wikitty wikitty) {
        String value = wikitty.getFieldAsString("Thesaurus", "comment");
        return value;
    }

    public static String setComment(Wikitty wikitty, String comment) {
        String oldValue = ThesaurusHelper.getComment(wikitty);
        wikitty.setField("Thesaurus", "comment", (Object)comment);
        return oldValue;
    }

    public static String getRootThesaurus(Wikitty wikitty) {
        String value = wikitty.getFieldAsString("Thesaurus", "rootThesaurus");
        return value;
    }

    public static String setRootThesaurus(Wikitty wikitty, String rootThesaurus) {
        String oldValue = ThesaurusHelper.getRootThesaurus(wikitty);
        wikitty.setField("Thesaurus", "rootThesaurus", (Object)rootThesaurus);
        return oldValue;
    }

    public static boolean equals(Wikitty w1, Wikitty w2) {
        Object f2;
        Object f1;
        boolean result = true;
        if (result) {
            f1 = w1.getFieldAsObject("Thesaurus", "tags");
            boolean bl = result = f1 == (f2 = w2.getFieldAsObject("Thesaurus", "tags")) || f1 != null && f1.equals(f2);
        }
        if (result) {
            f1 = w1.getFieldAsObject("Thesaurus", "order");
            boolean bl = result = f1 == (f2 = w2.getFieldAsObject("Thesaurus", "order")) || f1 != null && f1.equals(f2);
        }
        if (result) {
            f1 = w1.getFieldAsObject("Thesaurus", "comment");
            boolean bl = result = f1 == (f2 = w2.getFieldAsObject("Thesaurus", "comment")) || f1 != null && f1.equals(f2);
        }
        if (result) {
            f1 = w1.getFieldAsObject("Thesaurus", "rootThesaurus");
            result = f1 == (f2 = w2.getFieldAsObject("Thesaurus", "rootThesaurus")) || f1 != null && f1.equals(f2);
        }
        return result;
    }

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return ThesaurusHelper.hasExtension(wikitty);
    }

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension("Thesaurus");
    }

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : ThesaurusAbstract.extensions) {
            wikitty.addExtension(ext);
        }
    }
}

