/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingBean;
import com.jurismarches.vradi.services.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiSendingDTO {

    private static final long serialVersionUID = 1L;

    protected static Log log = LogFactory.getLog(VradiSendingDTO.class);

    protected PropertyChangeSupport propertyChange =
            new PropertyChangeSupport(this);

    protected Sending sending;
    protected VradiClientDTO clientDTO;
    protected List<VradiFormDTO> formDTOs = new ArrayList<VradiFormDTO>();

    public VradiSendingDTO(Sending wikitty) {
        sending = wikitty;
        setClientDTO(new VradiClientDTO());
        try {
            getClientDTO().fromWikitty(ServiceHelper.getVradiStorageService()
                    .getClient(wikitty.getClient()));
            sending.setClient(getClientDTO().getWikittyId());
        } catch (TechnicalException eee) {
            log.error(eee);
        }
        try {
            sending.clearForm();
            setFormDTOs(ServiceHelper.getVradiStorageService()
                    .getForms(new ArrayList(wikitty.getForm())));
        } catch (TechnicalException eee) {
            log.error(eee);
        }
        sending.setParagraph(wikitty.getParagraph());
        sending.setReceptionProof(wikitty.getReceptionProof());
        sending.setStatus(wikitty.getStatus());
        sending.setReceptionDate(wikitty.getReceptionDate());
        sending.setSentDate(wikitty.getSentDate());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName,
                                          PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName,
                                             PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(propertyName, listener);
    }

    public VradiClientDTO getClientDTO() {
        return clientDTO;
    }

    public void setClientDTO(VradiClientDTO clientDTO) {
        this.clientDTO = clientDTO;
    }

    public List<VradiFormDTO> getFormDTOs() {
        return formDTOs;
    }

    public void setFormDTOs(List<Form> forms) {
        if (forms != null) {
            this.formDTOs = new ArrayList<VradiFormDTO>();
            for (Form form : forms) {
                sending.addForm(form.getWikittyId());
                VradiFormDTO formDTO = new VradiFormDTO();
                formDTO.fromWikitty(form);
                this.formDTOs.add(formDTO);
            }
        }
    }

    public void removeFormDTO(VradiFormDTO form) {
        if (form != null) {
            formDTOs.remove(form);
            sending.removeForm(form.getWikittyId());
        }
    }

    public void setSentDate(Date value) {
        Object oldValue = getSentDate();
        sending.setSentDate(value);
        propertyChange.firePropertyChange("sentDate", oldValue, value);
    }

    public Date getSentDate() {
        return sending.getSentDate();
    }


    public void setReceptionDate(Date value) {
        Object oldValue = getReceptionDate();
        sending.setReceptionDate(value);
        propertyChange.firePropertyChange("receptionDate", oldValue, value);
    }

    public Date getReceptionDate() {
        return sending.getReceptionDate();
    }


    public void setParagraph(String value) {
        Object oldValue = getParagraph();
        sending.setParagraph(value);
        propertyChange.firePropertyChange("paragraph", oldValue, value);
    }

    public String getParagraph() {
        return sending.getParagraph();
    }


    public void setReceptionProof(boolean value) {
        Object oldValue = getReceptionProof();
        sending.setReceptionProof(value);
        propertyChange.firePropertyChange("receptionProof", oldValue, value);
    }

    public boolean getReceptionProof() {
        return sending.getReceptionProof();
    }


    public void setStatus(int value) {
        Object oldValue = getStatus();
        sending.setStatus(value);
        propertyChange.firePropertyChange("status", oldValue, value);
    }

    public int getStatus() {
        return sending.getStatus();
    }

    public Sending getSending() {
        return sending;
    }

}