/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jidefx.scene.control.field.verifier.PatternVerifier;

public abstract class ValuesPatternVerifier<S, T>
extends PatternVerifier<T>
implements PatternVerifier.Adjustable<T>,
PatternVerifier.Parser<T>,
PatternVerifier.Formatter<T>,
PatternVerifier.Range<T>,
PatternVerifier.Value<S, T>,
PatternVerifier.Enums<T> {
    private List<T> values;
    private S value;

    public ValuesPatternVerifier() {
    }

    public ValuesPatternVerifier(T[] values) {
        this.values = new ArrayList<T>();
        Collections.addAll(this.getValues(), values);
    }

    @Override
    public T getMin() {
        List<T> values = this.getValues();
        return values.size() >= 1 ? (T)values.get(0) : null;
    }

    @Override
    public T getMax() {
        List<T> values = this.getValues();
        return values.size() >= 1 ? (T)values.get(values.size() - 1) : null;
    }

    @Override
    public T getNextPage(T current, boolean restart) {
        return null;
    }

    @Override
    public T getPreviousPage(T current, boolean restart) {
        return null;
    }

    @Override
    public T getHome(T current) {
        return this.getMin();
    }

    @Override
    public T getEnd(T current) {
        return this.getMax();
    }

    @Override
    public T getNextValue(T current, boolean restart) {
        List<T> values = this.getValues();
        int index = values.indexOf(current);
        if (index != -1) {
            if (index + 1 < values.size()) {
                return values.get(index + 1);
            }
            return restart ? values.get(0) : values.get(values.size() - 1);
        }
        for (int i = 0; i < values.size(); ++i) {
            T value = values.get(i);
            if (!this.matches(current, value)) continue;
            if (i + 1 < values.size()) {
                return values.get(i + 1);
            }
            return restart ? values.get(0) : values.get(values.size() - 1);
        }
        return current;
    }

    @Override
    public T getPreviousValue(T current, boolean restart) {
        List<T> values = this.getValues();
        int index = values.indexOf(current);
        if (index != -1) {
            if (index - 1 > 0) {
                return values.get(index - 1);
            }
            return restart ? values.get(values.size() - 1) : values.get(0);
        }
        for (int i = 0; i < values.size(); ++i) {
            T value = values.get(i);
            if (!this.matches(current, value)) continue;
            if (i - 1 >= 0) {
                return values.get(i - 1);
            }
            return restart ? values.get(values.size() - 1) : values.get(0);
        }
        return current;
    }

    protected boolean matches(T current, T value) {
        return false;
    }

    public Boolean call(String text) {
        return this.getValues().contains(this.parse(text));
    }

    @Override
    public List<T> getValues() {
        if (this.values == null) {
            this.values = this.createValues();
        }
        return this.values;
    }

    protected List<T> createValues() {
        return null;
    }

    public void invalidate() {
        this.values = null;
    }

    @Override
    public void setFieldValue(S fieldValue) {
        this.value = fieldValue;
    }

    @Override
    public S getFieldValue() {
        return this.value;
    }
}

