/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;

public abstract class FractionDigitsPatternVerifier<T>
extends NumberValuePatternVerifier<T> {
    public FractionDigitsPatternVerifier(int length) {
        this(length, 1.0);
    }

    public FractionDigitsPatternVerifier(int length, double valueMultiplier) {
        super(0, (int)Math.pow(10.0, length) - 1, 1.0 / Math.pow(10.0, length), valueMultiplier);
        if (length <= 0) {
            throw new IllegalArgumentException("The length must be greater than 1");
        }
    }

    @Override
    protected Number getGroupValue(double targetValue) {
        super.getGroupValue(targetValue);
        double value = targetValue - Math.floor(targetValue);
        return Math.round(value / this.adjustmentMultiplier);
    }

    @Override
    protected double getTargetValue(Number groupValue) {
        double value = this.getMultipliedValue(this.targetValue.doubleValue());
        return this.getDemultipliedValue(Math.floor(value) + (double)groupValue.intValue() * this.adjustmentMultiplier);
    }
}

