/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.util.Calendar;
import java.util.Date;
import jidefx.scene.control.field.verifier.PatternVerifier;

public abstract class DateFieldPatternVerifier
extends PatternVerifier<Date>
implements PatternVerifier.Value<Date, Date>,
PatternVerifier.Adjustable<Integer>,
PatternVerifier.Range<Integer> {
    private final int field;
    private final Calendar value;
    private final int min;
    private final int max;
    private boolean minMaxSet = true;

    public DateFieldPatternVerifier(int field) {
        this(field, Calendar.getInstance().getMinimum(field), Calendar.getInstance().getMaximum(field));
        this.minMaxSet = false;
    }

    DateFieldPatternVerifier(int field, int min, int max) {
        this.field = field;
        this.min = min;
        this.max = max;
        this.value = Calendar.getInstance();
    }

    @Override
    public Integer getMin() {
        return !this.minMaxSet && this.value != null ? this.value.getActualMinimum(this.field) : this.min;
    }

    @Override
    public Integer getMax() {
        return !this.minMaxSet && this.value != null ? this.value.getActualMaximum(this.field) : this.max;
    }

    @Override
    public Integer getEnd(Integer current) {
        if (this.value != null) {
            this.value.set(this.field, this.getMax());
        }
        return null;
    }

    @Override
    public Integer getHome(Integer current) {
        if (this.value != null) {
            this.value.set(this.field, this.getMin());
        }
        return null;
    }

    @Override
    public Integer getPreviousPage(Integer current, boolean restart) {
        if (this.value != null) {
            if (restart) {
                this.value.add(this.field, -10);
            } else if (this.value.get(this.field) - this.getMin() > 10) {
                this.value.add(this.field, -10);
            } else {
                this.value.set(this.field, this.getMin());
            }
        }
        return null;
    }

    @Override
    public Integer getNextPage(Integer current, boolean restart) {
        if (this.value != null) {
            if (restart) {
                this.value.add(this.field, 10);
            } else if (this.getMax() - this.value.get(this.field) > 10) {
                this.value.add(this.field, 10);
            } else {
                this.value.set(this.field, this.getMax());
            }
        }
        return null;
    }

    @Override
    public Integer getNextValue(Integer current, boolean restart) {
        if (this.value != null) {
            if (restart) {
                this.value.add(this.field, 1);
            } else if (this.value.get(this.field) != this.getMax().intValue()) {
                this.value.add(this.field, 1);
            }
        }
        return null;
    }

    @Override
    public Integer getPreviousValue(Integer current, boolean restart) {
        if (this.value != null) {
            if (restart) {
                this.value.add(this.field, -1);
            } else if (this.value.get(this.field) != this.getMin().intValue()) {
                this.value.add(this.field, -1);
            }
        }
        return null;
    }

    @Override
    public void setFieldValue(Date fieldValue) {
        if (fieldValue != null) {
            this.value.setTime(fieldValue);
        }
    }

    @Override
    public Date getFieldValue() {
        return this.value.getTime();
    }

    @Override
    public Date toTargetValue(Date fieldValue) {
        return fieldValue;
    }

    @Override
    public Date fromTargetValue(Date existingValue, Date value) {
        return value;
    }
}

