/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.popup;

import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.IntegerField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.PopupsResource;
import jidefx.utils.converter.javafx.HexColorConverter;

public class ColorPopupContent
extends DecorationPane
implements PopupContent<Color> {
    private static final String STYLE_CLASS_DEFAULT = "popup-content";
    private static final int PICKER_PADDING = 2;
    private static final int RECT_SIZE = 170;
    private static final int ARROW_SIZE = 10;
    private static final int PICKER_WIDTH = 220;
    private static final int PICKER_HEIGHT = 280;
    private boolean changeIsLocal = false;
    private DoubleProperty hue = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (!ColorPopupContent.this.changeIsLocal) {
                ColorPopupContent.this.changeIsLocal = true;
                ColorPopupContent.this._colorProperty.set((Object)Color.hsb((double)ColorPopupContent.this.hue.get(), (double)ColorPopupContent.clamp(ColorPopupContent.this.sat.get() / 100.0), (double)ColorPopupContent.clamp(ColorPopupContent.this.bright.get() / 100.0)));
                ColorPopupContent.this.changeIsLocal = false;
            }
        }
    };
    private DoubleProperty sat = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (!ColorPopupContent.this.changeIsLocal) {
                ColorPopupContent.this.changeIsLocal = true;
                ColorPopupContent.this._colorProperty.set((Object)Color.hsb((double)ColorPopupContent.this.hue.get(), (double)ColorPopupContent.clamp(ColorPopupContent.this.sat.get() / 100.0), (double)ColorPopupContent.clamp(ColorPopupContent.this.bright.get() / 100.0)));
                ColorPopupContent.this.changeIsLocal = false;
            }
        }
    };
    private DoubleProperty bright = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (!ColorPopupContent.this.changeIsLocal) {
                ColorPopupContent.this.changeIsLocal = true;
                ColorPopupContent.this._colorProperty.set((Object)Color.hsb((double)ColorPopupContent.this.hue.get(), (double)ColorPopupContent.clamp(ColorPopupContent.this.sat.get() / 100.0), (double)ColorPopupContent.clamp(ColorPopupContent.this.bright.get() / 100.0)));
                ColorPopupContent.this.changeIsLocal = false;
            }
        }
    };
    private ObjectProperty<Color> _colorProperty = new SimpleObjectProperty<Color>(Color.RED){

        protected void invalidated() {
            if (!ColorPopupContent.this.changeIsLocal) {
                ColorPopupContent.this.changeIsLocal = true;
                Color c = (Color)this.get();
                if (c == null) {
                    c = Color.WHITE;
                }
                ColorPopupContent.this.hue.set(c.getHue());
                ColorPopupContent.this.sat.set(c.getSaturation() * 100.0);
                ColorPopupContent.this.bright.set(c.getBrightness() * 100.0);
                ColorPopupContent.this.changeIsLocal = false;
            }
        }
    };

    @Override
    public final ObjectProperty<Color> valueProperty() {
        return this._colorProperty;
    }

    @Override
    public final Color getValue() {
        return (Color)this._colorProperty.get();
    }

    @Override
    public final void setValue(Color value) {
        this._colorProperty.set((Object)value);
    }

    public ColorPopupContent() {
        super((Parent)new Group());
        this.getStylesheets().add((Object)PopupContent.class.getResource("PopupContent.css").toExternalForm());
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
        Rectangle windowClickRect = new Rectangle(224.0, 284.0);
        windowClickRect.setFill((Paint)Color.TRANSPARENT);
        Circle colorRectIndicator = new Circle(60.0, 60.0, 5.0);
        colorRectIndicator.setStroke((Paint)Color.WHITE);
        colorRectIndicator.setFill(null);
        colorRectIndicator.setEffect((Effect)new DropShadow(2.0, 0.0, 1.0, Color.BLACK));
        colorRectIndicator.centerXProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{ColorPopupContent.this.sat});
            }

            protected double computeValue() {
                return 12.0 + 170.0 * (ColorPopupContent.this.sat.get() / 100.0);
            }
        });
        colorRectIndicator.centerYProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{ColorPopupContent.this.bright});
            }

            protected double computeValue() {
                return 22.0 + 170.0 * (1.0 - ColorPopupContent.this.bright.get() / 100.0);
            }
        });
        final Rectangle colorRect = new Rectangle(12.0, 22.0, 170.0, 170.0);
        colorRect.setStroke((Paint)Color.GRAY);
        colorRect.fillProperty().bind((ObservableValue)new ObjectBinding<Paint>(){
            {
                this.bind(new Observable[]{ColorPopupContent.this._colorProperty});
            }

            protected Paint computeValue() {
                return Color.hsb((double)ColorPopupContent.this.hue.getValue(), (double)1.0, (double)1.0);
            }
        });
        Rectangle colorRectOverlayOne = new Rectangle(12.0, 22.0, 170.0, 170.0);
        colorRectOverlayOne.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)1.0)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.0))}));
        EventHandler<MouseEvent> rectMouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double x = event.getX() - colorRect.getX();
                double y = event.getY() - colorRect.getY();
                ColorPopupContent.this.sat.set(ColorPopupContent.clamp(x / 170.0) * 100.0);
                ColorPopupContent.this.bright.set(100.0 - ColorPopupContent.clamp(y / 170.0) * 100.0);
            }
        };
        Rectangle colorRectOverlayTwo = new Rectangle(12.0, 22.0, 170.0, 170.0);
        colorRectOverlayTwo.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.0)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)1.0))}));
        colorRectOverlayTwo.setOnMouseDragged((EventHandler)rectMouseHandler);
        colorRectOverlayTwo.setOnMouseClicked((EventHandler)rectMouseHandler);
        final Rectangle colorBar = new Rectangle(192.0, 22.0, 20.0, 170.0);
        colorBar.setStroke((Paint)Color.GRAY);
        colorBar.setFill((Paint)ColorPopupContent.createHueGradient());
        Rectangle colorBarIndicator = new Rectangle(190.0, 27.0, 24.0, 10.0);
        colorBarIndicator.setArcWidth(4.0);
        colorBarIndicator.setArcHeight(4.0);
        colorBarIndicator.setStroke((Paint)Color.WHITE);
        colorBarIndicator.setFill(null);
        colorBarIndicator.setEffect((Effect)new DropShadow(2.0, 0.0, 1.0, Color.BLACK));
        colorBarIndicator.yProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{ColorPopupContent.this.hue});
            }

            protected double computeValue() {
                return 17.0 + 170.0 * (ColorPopupContent.this.hue.get() / 360.0);
            }
        });
        EventHandler<MouseEvent> barMouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double y = event.getY() - colorBar.getY();
                ColorPopupContent.this.hue.set(ColorPopupContent.clamp(y / 170.0) * 360.0);
            }
        };
        colorBar.setOnMouseDragged((EventHandler)barMouseHandler);
        colorBar.setOnMouseClicked((EventHandler)barMouseHandler);
        Label brightnessLabel = new Label(this.getResourceString("brightness"));
        brightnessLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPane.setConstraints((Node)brightnessLabel, (int)0, (int)0);
        Slider brightnessSlider = new Slider();
        brightnessSlider.setMin(0.0);
        brightnessSlider.setMax(100.0);
        brightnessSlider.setId("BrightnessSlider");
        brightnessSlider.valueProperty().bindBidirectional((Property)this.bright);
        GridPane.setConstraints((Node)brightnessSlider, (int)1, (int)0);
        IntegerField brightnessField = new IntegerField();
        brightnessField.setSpinnersVisible(true);
        brightnessField.setPrefColumnCount(7);
        brightnessField.installAdjustmentMouseHandler((Node)brightnessLabel);
        this.bindBidirectional(brightnessField.valueProperty(), this.bright);
        GridPane.setConstraints((Node)brightnessField, (int)2, (int)0);
        Label saturationLabel = new Label(this.getResourceString("saturation"));
        saturationLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPane.setConstraints((Node)saturationLabel, (int)0, (int)1);
        Slider saturationSlider = new Slider();
        saturationSlider.setMin(0.0);
        saturationSlider.setMax(100.0);
        saturationSlider.setId("SaturationSlider");
        saturationSlider.valueProperty().bindBidirectional((Property)this.sat);
        GridPane.setConstraints((Node)saturationSlider, (int)1, (int)1);
        saturationSlider.styleProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{ColorPopupContent.this._colorProperty});
            }

            protected String computeValue() {
                return "picker-color: hsb(" + ColorPopupContent.this.hue.get() + ",100%,100%);";
            }
        });
        IntegerField saturationField = new IntegerField();
        saturationField.setSpinnersVisible(true);
        saturationField.setPrefColumnCount(7);
        saturationField.setValue(0);
        saturationField.installAdjustmentMouseHandler((Node)saturationLabel);
        this.bindBidirectional(saturationField.valueProperty(), this.sat);
        GridPane.setConstraints((Node)saturationField, (int)2, (int)1);
        Label webLabel = new Label(this.getResourceString("web"));
        webLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPane.setConstraints((Node)webLabel, (int)0, (int)2);
        FormattedTextField webField = new FormattedTextField();
        webField.setStringConverter(new HexColorConverter().toStringConverter());
        webField.valueProperty().bindBidirectional(this._colorProperty);
        webField.setComboBoxLike(false);
        webField.setEditable(false);
        GridPane.setConstraints(webField, (int)1, (int)2, (int)2, (int)1);
        GridPane controls = new GridPane();
        controls.setVgap(5.0);
        controls.setHgap(5.0);
        controls.getChildren().addAll((Object[])new Node[]{brightnessLabel, brightnessSlider, brightnessField, saturationLabel, saturationSlider, saturationField, webLabel, webField});
        controls.setManaged(false);
        controls.resizeRelocate(12.0, 202.0, 200.0, 80.0);
        ((Group)this.getContent()).getChildren().addAll((Object[])new Node[]{windowClickRect, colorRect, colorRectOverlayOne, colorRectOverlayTwo, colorBar, colorRectIndicator, colorBarIndicator, controls});
    }

    private void bindBidirectional(final ObjectProperty<Integer> objectProperty, final DoubleProperty doubleProperty) {
        doubleProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                objectProperty.set((Object)newValue.intValue());
            }
        });
        objectProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                doubleProperty.setValue((Number)newValue.doubleValue());
            }
        });
    }

    private static double clamp(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    private static LinearGradient createHueGradient() {
        Stop[] stops = new Stop[255];
        for (int y = 0; y < 255; ++y) {
            double offset = 1.0 - 0.00392156862745098 * (double)y;
            int h = (int)((double)y / 255.0 * 360.0);
            stops[y] = new Stop(offset, Color.hsb((double)h, (double)1.0, (double)1.0));
        }
        return new LinearGradient(0.0, 1.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public String getResourceString(String key) {
        if (key == null) {
            return "";
        }
        return PopupsResource.getResourceBundle(Locale.getDefault()).getString(key);
    }
}

