/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.popup;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.traversal.Direction;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DateCell;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jidefx.scene.control.field.popup.PopupContent;

public abstract class AbstractDatePopupContent<T>
extends VBox
implements PopupContent<T> {
    protected AbstractDatePopupContent<T> datePicker;
    private Button backMonthButton;
    private Button forwardMonthButton;
    private Button backYearButton;
    private Button forwardYearButton;
    private Label monthLabel;
    private Label yearLabel;
    protected GridPane gridPane;
    private int daysPerWeek;
    private List<DateCell> dayNameCells = new ArrayList<DateCell>();
    private List<DateCell> weekNumberCells = new ArrayList<DateCell>();
    protected List<DateCell> dayCells = new ArrayList<DateCell>();
    private LocalDate[] dayCellDates;
    private DateCell lastFocusedDayCell = null;
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter monthFormatterSO = DateTimeFormatter.ofPattern("LLLL");
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter yearWithEraFormatter = DateTimeFormatter.ofPattern("GGGGy");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    final ContextMenu contextMenu = new ContextMenu();
    private ObjectProperty<YearMonth> displayedYearMonth = new SimpleObjectProperty((Object)this, "displayedYearMonth");
    private ObjectProperty<Callback<AbstractDatePopupContent, DateCell>> dayCellFactory;
    private ObjectProperty<Chronology> chronology = new SimpleObjectProperty((Object)this, "chronology", null);
    private BooleanProperty showWeekNumbers;
    private ObjectProperty<T> value = new SimpleObjectProperty<T>(this, "value"){

        protected void invalidated() {
            super.invalidated();
            AbstractDatePopupContent.this.updateDisplayedYearMonth();
            AbstractDatePopupContent.this.updateDayCells();
            AbstractDatePopupContent.this.clearFocus();
        }
    };
    static final Text helper = new Text();
    static final double DEFAULT_WRAPPING_WIDTH = helper.getWrappingWidth();
    static final double DEFAULT_LINE_SPACING = helper.getLineSpacing();
    static final String DEFAULT_TEXT = helper.getText();

    static String getString(String key) {
        return ControlResources.getString((String)("DatePicker." + key));
    }

    public AbstractDatePopupContent() {
        DateCell cell;
        int i;
        this.datePicker = this;
        this.getStyleClass().add((Object)"date-picker-popup");
        this.daysPerWeek = this.getDaysPerWeek();
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{new MenuItem(AbstractDatePopupContent.getString("contextMenu.showToday")){
            {
                this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        AbstractDatePopupContent.this.displayedYearMonth.set((Object)YearMonth.now());
                    }
                });
            }
        }, new SeparatorMenuItem(), new CheckMenuItem(AbstractDatePopupContent.getString("contextMenu.showWeekNumbers")){
            {
                this.selectedProperty().bindBidirectional((Property)AbstractDatePopupContent.this.datePicker.showWeekNumbersProperty());
            }
        }});
        this.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent me) {
                AbstractDatePopupContent.this.contextMenu.show((Node)AbstractDatePopupContent.this, me.getScreenX(), me.getScreenY());
                me.consume();
            }
        });
        T date = this.datePicker.getValue();
        this.displayedYearMonth.set((Object)(date != null ? YearMonth.from(this.toLocalDate(date)) : YearMonth.now()));
        this.displayedYearMonth.addListener((ChangeListener)new ChangeListener<YearMonth>(){

            public void changed(ObservableValue<? extends YearMonth> observable, YearMonth oldValue, YearMonth newValue) {
                AbstractDatePopupContent.this.updateValues();
            }
        });
        this.getChildren().add((Object)this.createMonthYearPane());
        this.gridPane = new GridPane(){

            protected double computePrefWidth(double height) {
                double width = super.computePrefWidth(height);
                int nCols = AbstractDatePopupContent.this.daysPerWeek + (AbstractDatePopupContent.this.datePicker.isShowWeekNumbers() ? 1 : 0);
                double snaphgap = this.snapSpace(this.getHgap());
                double left = this.snapSpace(this.getInsets().getLeft());
                double right = this.snapSpace(this.getInsets().getRight());
                double hgaps = snaphgap * (double)(nCols - 1);
                double contentWidth = width - left - right - hgaps;
                return this.snapSize(contentWidth / (double)nCols) * (double)nCols + left + right + hgaps;
            }
        };
        this.gridPane.setFocusTraversable(true);
        this.gridPane.getStyleClass().add((Object)"calendar-grid");
        this.gridPane.setVgap(-1.0);
        this.gridPane.setHgap(-1.0);
        this.gridPane.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean hasFocus) {
                if (hasFocus.booleanValue()) {
                    if (AbstractDatePopupContent.this.lastFocusedDayCell != null) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractDatePopupContent.this.lastFocusedDayCell.requestFocus();
                            }
                        });
                    } else {
                        AbstractDatePopupContent.this.clearFocus();
                    }
                }
            }
        });
        for (i = 0; i < this.daysPerWeek; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add((Object)"day-name-cell");
            this.dayNameCells.add(cell);
        }
        for (i = 0; i < 6; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add((Object)"week-number-cell");
            this.weekNumberCells.add(cell);
        }
        this.createDayCells();
        this.updateGrid();
        this.getChildren().add((Object)this.gridPane);
        this.refresh();
        this.addEventHandler(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                Node node = AbstractDatePopupContent.this.getScene().getFocusOwner();
                if (node instanceof DateCell) {
                    AbstractDatePopupContent.this.lastFocusedDayCell = (DateCell)node;
                }
                if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                    switch (e.getCode()) {
                        case TAB: {
                            node.impl_traverse(e.isShiftDown() ? Direction.PREVIOUS : Direction.NEXT);
                            e.consume();
                            break;
                        }
                        case UP: {
                            if (e.isAltDown()) break;
                            node.impl_traverse(Direction.UP);
                            e.consume();
                            break;
                        }
                        case DOWN: {
                            if (e.isAltDown()) break;
                            node.impl_traverse(Direction.DOWN);
                            e.consume();
                            break;
                        }
                        case LEFT: {
                            node.impl_traverse(Direction.LEFT);
                            e.consume();
                            break;
                        }
                        case RIGHT: {
                            node.impl_traverse(Direction.RIGHT);
                            e.consume();
                            break;
                        }
                        case PAGE_UP: {
                            if (PlatformUtil.isMac() && e.isMetaDown() || !PlatformUtil.isMac() && e.isControlDown()) {
                                if (!AbstractDatePopupContent.this.backYearButton.isDisabled()) {
                                    AbstractDatePopupContent.this.forward(-1, ChronoUnit.YEARS);
                                }
                            } else if (!AbstractDatePopupContent.this.backMonthButton.isDisabled()) {
                                AbstractDatePopupContent.this.forward(-1, ChronoUnit.MONTHS);
                            }
                            e.consume();
                            break;
                        }
                        case PAGE_DOWN: {
                            if (PlatformUtil.isMac() && e.isMetaDown() || !PlatformUtil.isMac() && e.isControlDown()) {
                                if (!AbstractDatePopupContent.this.forwardYearButton.isDisabled()) {
                                    AbstractDatePopupContent.this.forward(1, ChronoUnit.YEARS);
                                }
                            } else if (!AbstractDatePopupContent.this.forwardMonthButton.isDisabled()) {
                                AbstractDatePopupContent.this.forward(1, ChronoUnit.MONTHS);
                            }
                            e.consume();
                        }
                    }
                    node = AbstractDatePopupContent.this.getScene().getFocusOwner();
                    if (node instanceof DateCell) {
                        AbstractDatePopupContent.this.lastFocusedDayCell = (DateCell)node;
                    }
                }
                switch (e.getCode()) {
                    case UP: 
                    case DOWN: 
                    case ESCAPE: 
                    case F4: 
                    case F10: {
                        break;
                    }
                    default: {
                        e.consume();
                    }
                }
            }
        });
    }

    ObjectProperty<YearMonth> displayedYearMonthProperty() {
        return this.displayedYearMonth;
    }

    protected BorderPane createMonthYearPane() {
        BorderPane monthYearPane = new BorderPane();
        monthYearPane.getStyleClass().add((Object)"month-year-pane");
        HBox monthSpinner = new HBox();
        monthSpinner.getStyleClass().add((Object)"spinner");
        this.backMonthButton = new Button();
        this.backMonthButton.getStyleClass().add((Object)"left-button");
        this.forwardMonthButton = new Button();
        this.forwardMonthButton.getStyleClass().add((Object)"right-button");
        StackPane leftMonthArrow = new StackPane();
        leftMonthArrow.getStyleClass().add((Object)"left-arrow");
        leftMonthArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backMonthButton.setGraphic((Node)leftMonthArrow);
        StackPane rightMonthArrow = new StackPane();
        rightMonthArrow.getStyleClass().add((Object)"right-arrow");
        rightMonthArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardMonthButton.setGraphic((Node)rightMonthArrow);
        this.backMonthButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                AbstractDatePopupContent.this.forward(-1, ChronoUnit.MONTHS);
            }
        });
        this.monthLabel = new Label();
        this.monthLabel.getStyleClass().add((Object)"spinner-label");
        this.forwardMonthButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                AbstractDatePopupContent.this.forward(1, ChronoUnit.MONTHS);
            }
        });
        monthSpinner.getChildren().addAll((Object[])new Node[]{this.backMonthButton, this.monthLabel, this.forwardMonthButton});
        monthYearPane.setLeft((Node)monthSpinner);
        HBox yearSpinner = new HBox();
        yearSpinner.getStyleClass().add((Object)"spinner");
        this.backYearButton = new Button();
        this.backYearButton.getStyleClass().add((Object)"left-button");
        this.forwardYearButton = new Button();
        this.forwardYearButton.getStyleClass().add((Object)"right-button");
        StackPane leftYearArrow = new StackPane();
        leftYearArrow.getStyleClass().add((Object)"left-arrow");
        leftYearArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backYearButton.setGraphic((Node)leftYearArrow);
        StackPane rightYearArrow = new StackPane();
        rightYearArrow.getStyleClass().add((Object)"right-arrow");
        rightYearArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardYearButton.setGraphic((Node)rightYearArrow);
        this.backYearButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                AbstractDatePopupContent.this.forward(-1, ChronoUnit.YEARS);
            }
        });
        this.yearLabel = new Label();
        this.yearLabel.getStyleClass().add((Object)"spinner-label");
        this.forwardYearButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                AbstractDatePopupContent.this.forward(1, ChronoUnit.YEARS);
            }
        });
        yearSpinner.getChildren().addAll((Object[])new Node[]{this.backYearButton, this.yearLabel, this.forwardYearButton});
        yearSpinner.setFillHeight(false);
        monthYearPane.setRight((Node)yearSpinner);
        return monthYearPane;
    }

    private void refresh() {
        this.updateMonthLabelWidth();
        this.updateDayNameCells();
        this.updateValues();
    }

    void updateValues() {
        this.updateWeeknumberDateCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    void updateGrid() {
        int i;
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getChildren().clear();
        int nCols = this.daysPerWeek + (this.datePicker.isShowWeekNumbers() ? 1 : 0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        for (i = 0; i < nCols; ++i) {
            this.gridPane.getColumnConstraints().add((Object)columnConstraints);
        }
        for (i = 0; i < this.daysPerWeek; ++i) {
            this.gridPane.add((Node)this.dayNameCells.get(i), i + nCols - this.daysPerWeek, 1);
        }
        if (this.datePicker.isShowWeekNumbers()) {
            for (i = 0; i < 6; ++i) {
                this.gridPane.add((Node)this.weekNumberCells.get(i), 0, i + 2);
            }
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                this.gridPane.add((Node)this.dayCells.get(row * this.daysPerWeek + col), col + nCols - this.daysPerWeek, row + 2);
            }
        }
    }

    void updateDayNameCells() {
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate date = LocalDate.of(2009, 7, 12 + firstDayOfWeek);
        for (int i = 0; i < this.daysPerWeek; ++i) {
            String name = this.weekDayNameFormatter.withLocale(this.getLocale()).format(date.plus(i, ChronoUnit.DAYS));
            this.dayNameCells.get(i).setText(this.titleCaseWord(name));
        }
    }

    void updateWeeknumberDateCells() {
        if (this.datePicker.isShowWeekNumbers()) {
            Locale locale = this.getLocale();
            int maxWeeksPerMonth = 6;
            LocalDate firstOfMonth = ((YearMonth)this.displayedYearMonth.get()).atDay(1);
            for (int i = 0; i < 6; ++i) {
                LocalDate date = firstOfMonth.plus(i, ChronoUnit.WEEKS);
                String cellText = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(date);
                this.weekNumberCells.get(i).setText(cellText);
            }
        }
    }

    void updateDayCells() {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        int firstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        YearMonth curMonth = (YearMonth)this.displayedYearMonth.get();
        YearMonth prevMonth = curMonth.minusMonths(1L);
        YearMonth nextMonth = curMonth.plusMonths(1L);
        int daysInCurMonth = this.determineDaysInMonth(curMonth);
        int daysInPrevMonth = this.determineDaysInMonth(prevMonth);
        int daysInNextMonth = this.determineDaysInMonth(nextMonth);
        for (int i = 0; i < 6 * this.daysPerWeek; ++i) {
            DateCell dayCell = this.dayCells.get(i);
            dayCell.getStyleClass().setAll((Object[])new String[]{"cell", "day-cell"});
            dayCell.setDisable(false);
            dayCell.setStyle(null);
            dayCell.setGraphic(null);
            dayCell.setTooltip(null);
            try {
                LocalDate date;
                YearMonth month = curMonth;
                int day = i - firstOfMonthIdx + 1;
                if (i < firstOfMonthIdx) {
                    month = prevMonth;
                    day = i + daysInPrevMonth - firstOfMonthIdx + 1;
                    dayCell.getStyleClass().add((Object)"previous-month");
                } else if (i >= firstOfMonthIdx + daysInCurMonth) {
                    month = nextMonth;
                    day = i - daysInCurMonth - firstOfMonthIdx + 1;
                    dayCell.getStyleClass().add((Object)"next-month");
                }
                this.dayCellDates[i] = date = month.atDay(day);
                ChronoLocalDate cDate = chrono.date(date);
                dayCell.setDisable(false);
                if (this.isToday(date)) {
                    dayCell.getStyleClass().add((Object)"today");
                }
                if (date.equals(this.datePicker.getValue())) {
                    dayCell.getStyleClass().add((Object)"selected");
                }
                String cellText = this.dayCellFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                dayCell.setText(cellText);
                dayCell.updateItem(date, false);
                continue;
            }
            catch (DateTimeException ex) {
                dayCell.setText(" ");
                dayCell.setDisable(true);
            }
        }
    }

    private int getDaysPerWeek() {
        ValueRange range = this.getPrimaryChronology().range(ChronoField.DAY_OF_WEEK);
        return (int)(range.getMaximum() - range.getMinimum() + 1L);
    }

    private int getMonthsPerYear() {
        ValueRange range = this.getPrimaryChronology().range(ChronoField.MONTH_OF_YEAR);
        return (int)(range.getMaximum() - range.getMinimum() + 1L);
    }

    private void updateMonthLabelWidth() {
        if (this.monthLabel != null) {
            int monthsPerYear = this.getMonthsPerYear();
            double width = 0.0;
            for (int i = 0; i < monthsPerYear; ++i) {
                YearMonth yearMonth = ((YearMonth)this.displayedYearMonth.get()).withMonth(i + 1);
                String name = this.monthFormatterSO.withLocale(this.getLocale()).format(yearMonth);
                if (Character.isDigit(name.charAt(0))) {
                    name = this.monthFormatter.withLocale(this.getLocale()).format(yearMonth);
                }
                width = Math.max(width, AbstractDatePopupContent.computeTextWidth(this.monthLabel.getFont(), name, 0.0));
            }
            this.monthLabel.setMinWidth(width);
        }
    }

    protected void updateMonthYearPane() {
        LocalDate firstDayOfMonth;
        Chronology chrono;
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        String str = this.formatMonth(yearMonth);
        this.monthLabel.setText(str);
        str = this.formatYear(yearMonth);
        this.yearLabel.setText(str);
        double width = AbstractDatePopupContent.computeTextWidth(this.yearLabel.getFont(), str, 0.0);
        if (width > this.yearLabel.getMinWidth()) {
            this.yearLabel.setMinWidth(width);
        }
        this.backMonthButton.setDisable(!this.isValidDate(chrono = this.datePicker.getChronology(), (firstDayOfMonth = yearMonth.atDay(1)).minusDays(1L)));
        this.forwardMonthButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth.plusMonths(1L)));
        this.backYearButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth.minusYears(1L)));
        this.forwardYearButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth.plusYears(1L)));
    }

    private String formatMonth(YearMonth yearMonth) {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        try {
            ChronoLocalDate cDate = chrono.date(yearMonth.atDay(1));
            String str = this.monthFormatterSO.withLocale(this.getLocale()).withChronology(chrono).format(cDate);
            if (Character.isDigit(str.charAt(0))) {
                str = this.monthFormatter.withLocale(this.getLocale()).withChronology(chrono).format(cDate);
            }
            return this.titleCaseWord(str);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    private String formatYear(YearMonth yearMonth) {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        try {
            DateTimeFormatter formatter = this.yearFormatter;
            ChronoLocalDate cDate = chrono.date(yearMonth.atDay(1));
            int era = cDate.getEra().getValue();
            int nEras = chrono.eras().size();
            if (nEras == 2 && era == 0 || nEras > 2) {
                formatter = this.yearWithEraFormatter;
            }
            String str = formatter.withLocale(this.getLocale()).withChronology(chrono).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(cDate);
            return str;
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    private String titleCaseWord(String str) {
        int firstChar;
        if (str.length() > 0 && !Character.isTitleCase(firstChar = str.codePointAt(0))) {
            str = new String(new int[]{Character.toTitleCase(firstChar)}, 0, 1) + str.substring(Character.offsetByCodePoints(str, 0, 1));
        }
        return str;
    }

    private int determineFirstOfMonthDayOfWeek() {
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        int firstOfMonthIdx = ((YearMonth)this.displayedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - firstDayOfWeek;
        if (firstOfMonthIdx < 0) {
            firstOfMonthIdx += this.daysPerWeek;
        }
        return firstOfMonthIdx;
    }

    private int determineDaysInMonth(YearMonth month) {
        return month.atDay(1).plusMonths(1L).minusDays(1L).getDayOfMonth();
    }

    private boolean isToday(LocalDate localDate) {
        return localDate.equals(LocalDate.now());
    }

    protected LocalDate dayCellDate(DateCell dateCell) {
        assert (this.dayCellDates != null);
        return this.dayCellDates[this.dayCells.indexOf(dateCell)];
    }

    public void goToDayCell(DateCell dateCell, int offset, ChronoUnit unit) {
        this.goToDate(this.dayCellDate(dateCell).plus(offset, unit));
    }

    protected void forward(int offset, ChronoUnit unit) {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        DateCell dateCell = this.lastFocusedDayCell;
        if (dateCell == null || !this.dayCellDate(dateCell).getMonth().equals(yearMonth.getMonth())) {
            dateCell = this.findDayCellForDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dateCell, offset, unit);
    }

    public void goToDate(LocalDate date) {
        if (this.isValidDate(this.datePicker.getChronology(), date)) {
            this.displayedYearMonth.set((Object)YearMonth.from(date));
            this.findDayCellForDate(date).requestFocus();
        }
    }

    public void selectDayCell(DateCell dateCell) {
        this.datePicker.setValue(this.fromLocalDate(this.dayCellDate(dateCell)));
    }

    private DateCell findDayCellForDate(LocalDate date) {
        for (int i = 0; i < this.dayCellDates.length; ++i) {
            if (!date.equals(this.dayCellDates[i])) continue;
            return this.dayCells.get(i);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    void clearFocus() {
        LocalDate focusDate = this.toLocalDate(this.datePicker.getValue());
        if (focusDate == null) {
            focusDate = LocalDate.now();
        }
        if (YearMonth.from(focusDate).equals(this.displayedYearMonth.get())) {
            this.goToDate(focusDate);
        } else {
            this.backMonthButton.requestFocus();
        }
        if (this.backMonthButton.getWidth() == 0.0) {
            this.backMonthButton.requestLayout();
            this.forwardMonthButton.requestLayout();
            this.backYearButton.requestLayout();
            this.forwardYearButton.requestLayout();
        }
    }

    protected void createDayCells() {
        EventHandler<MouseEvent> dayCellActionHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ev) {
                if (ev.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                DateCell dayCell = (DateCell)ev.getSource();
                AbstractDatePopupContent.this.selectDayCell(dayCell);
                AbstractDatePopupContent.this.lastFocusedDayCell = dayCell;
            }
        };
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                DateCell dayCell = this.createDayCell();
                dayCell.setOnMouseClicked((EventHandler)dayCellActionHandler);
                this.dayCells.add(dayCell);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
    }

    private DateCell createDayCell() {
        DateCell cell = null;
        if (this.datePicker.getDayCellFactory() != null) {
            cell = (DateCell)this.datePicker.getDayCellFactory().call(this.datePicker);
        }
        if (cell == null) {
            cell = new DateCell();
        }
        return cell;
    }

    protected Locale getLocale() {
        return Locale.getDefault(Locale.Category.FORMAT);
    }

    protected Chronology getPrimaryChronology() {
        return this.datePicker.getChronology();
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date) {
        try {
            if (date != null) {
                chrono.date(date);
            }
            return true;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }

    public final void setDayCellFactory(Callback<AbstractDatePopupContent, DateCell> value) {
        this.dayCellFactoryProperty().set(value);
    }

    public final Callback<AbstractDatePopupContent, DateCell> getDayCellFactory() {
        return this.dayCellFactory != null ? (Callback)this.dayCellFactory.get() : null;
    }

    public final ObjectProperty<Callback<AbstractDatePopupContent, DateCell>> dayCellFactoryProperty() {
        if (this.dayCellFactory == null) {
            this.dayCellFactory = new SimpleObjectProperty<Callback<AbstractDatePopupContent, DateCell>>((Object)this, "dayCellFactory"){

                protected void invalidated() {
                    super.invalidated();
                    AbstractDatePopupContent.this.updateGrid();
                }
            };
        }
        return this.dayCellFactory;
    }

    public final ObjectProperty<Chronology> chronologyProperty() {
        return this.chronology;
    }

    public final Chronology getChronology() {
        Chronology chrono = (Chronology)this.chronology.get();
        if (chrono == null) {
            try {
                chrono = Chronology.ofLocale(Locale.getDefault(Locale.Category.FORMAT));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            if (chrono == null) {
                chrono = IsoChronology.INSTANCE;
            }
        }
        return chrono;
    }

    public final void setChronology(Chronology value) {
        this.chronology.setValue((Object)value);
    }

    public final BooleanProperty showWeekNumbersProperty() {
        if (this.showWeekNumbers == null) {
            String country = Locale.getDefault(Locale.Category.FORMAT).getCountry();
            boolean localizedDefault = !country.isEmpty() && ControlResources.getNonTranslatableString((String)"DatePicker.showWeekNumbers").contains(country);
            this.showWeekNumbers = new StyleableBooleanProperty(localizedDefault){

                protected void invalidated() {
                    super.invalidated();
                    AbstractDatePopupContent.this.updateGrid();
                    AbstractDatePopupContent.this.updateWeeknumberDateCells();
                }

                public CssMetaData<AbstractDatePopupContent, Boolean> getCssMetaData() {
                    return StyleableProperties.SHOW_WEEK_NUMBERS;
                }

                public Object getBean() {
                    return AbstractDatePopupContent.this;
                }

                public String getName() {
                    return "showWeekNumbers";
                }
            };
        }
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean value) {
        this.showWeekNumbersProperty().setValue(Boolean.valueOf(value));
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().getValue();
    }

    @Override
    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    @Override
    public final void setValue(T value) {
        this.valueProperty().set(value);
    }

    @Override
    public final T getValue() {
        return (T)this.valueProperty().get();
    }

    protected abstract T fromLocalDate(LocalDate var1);

    protected abstract LocalDate toLocalDate(T var1);

    private void updateDisplayedYearMonth() {
        LocalDate date = this.toLocalDate(this.getValue());
        this.displayedYearMonth.set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
    }

    static double computeTextWidth(Font font, String text, double wrappingWidth) {
        helper.setText(text);
        helper.setFont(font);
        helper.setWrappingWidth(0.0);
        helper.setLineSpacing(0.0);
        double w = Math.min(helper.prefWidth(-1.0), wrappingWidth);
        helper.setWrappingWidth((double)((int)Math.ceil(w)));
        w = Math.ceil(helper.getLayoutBounds().getWidth());
        helper.setWrappingWidth(DEFAULT_WRAPPING_WIDTH);
        helper.setLineSpacing(DEFAULT_LINE_SPACING);
        helper.setText(DEFAULT_TEXT);
        return w;
    }

    private static class StyleableProperties {
        private static final String country = Locale.getDefault(Locale.Category.FORMAT).getCountry();
        private static final CssMetaData<AbstractDatePopupContent, Boolean> SHOW_WEEK_NUMBERS = new CssMetaData<AbstractDatePopupContent, Boolean>("-fx-show-week-numbers", BooleanConverter.getInstance(), Boolean.valueOf(!country.isEmpty() && ControlResources.getNonTranslatableString((String)"DatePicker.showWeekNumbers").contains(country))){

            public boolean isSettable(AbstractDatePopupContent n) {
                return n.showWeekNumbers == null || !n.showWeekNumbers.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractDatePopupContent n) {
                return (StyleableProperty)n.showWeekNumbersProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SHOW_WEEK_NUMBERS);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

