/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.StringConverter;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.verifier.FractionDigitsPatternVerifier;
import jidefx.scene.control.field.verifier.IntegerDigitsPatternVerifier;
import jidefx.utils.CommonUtils;

public class NumberField
extends FormattedTextField<Number> {
    private BooleanProperty _positiveOnlyProperty;
    private static final String STYLE_CLASS_DEFAULT = "number-field";
    private ObjectProperty<NumberType> _numberTypeProperty;
    private ObjectProperty<DecimalFormat> _decimalFormatProperty;

    public NumberField() {
        this.setNumberType(NumberType.Normal);
    }

    public NumberField(NumberType type) {
        this.setNumberType(type);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setSpinnersVisible(true);
    }

    private boolean isNegative(Number value) {
        return value != null && value.doubleValue() < 0.0;
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!NumberField.this.isNegative(oldValue) && NumberField.this.isNegative(newValue)) {
                    NumberField.this.initializePatternVerifiersForDecimalFormat(NumberField.this.getDecimalFormat());
                }
                if (NumberField.this.isNegative(oldValue) && !NumberField.this.isNegative(newValue)) {
                    NumberField.this.initializePatternVerifiersForDecimalFormat(NumberField.this.getDecimalFormat());
                }
            }
        });
    }

    public ObjectProperty<NumberType> numberTypeProperty() {
        if (this._numberTypeProperty == null) {
            this._numberTypeProperty = new SimpleObjectProperty<NumberType>((Object)this, "numberType"){

                protected void invalidated() {
                    super.invalidated();
                    DecimalFormat format = (DecimalFormat)DecimalFormat.getNumberInstance();
                    NumberType newValue = (NumberType)((Object)this.get());
                    switch (newValue) {
                        case Percent: {
                            format = (DecimalFormat)DecimalFormat.getPercentInstance();
                            break;
                        }
                        case Currency: {
                            format = (DecimalFormat)DecimalFormat.getCurrencyInstance();
                            break;
                        }
                        case Normal: {
                            format = (DecimalFormat)DecimalFormat.getNumberInstance();
                            break;
                        }
                        case Integer: {
                            format = (DecimalFormat)DecimalFormat.getIntegerInstance();
                        }
                    }
                    format.setGroupingUsed(false);
                    NumberField.this.setDecimalFormat(format);
                }
            };
        }
        return this._numberTypeProperty;
    }

    public NumberType getNumberType() {
        return (NumberType)((Object)this.numberTypeProperty().get());
    }

    public void setNumberType(NumberType numberType) {
        this.numberTypeProperty().set((Object)numberType);
    }

    public ObjectProperty<DecimalFormat> decimalFormatProperty() {
        if (this._decimalFormatProperty == null) {
            this._decimalFormatProperty = new SimpleObjectProperty<DecimalFormat>((Object)this, "decimalFormat"){

                protected void invalidated() {
                    super.invalidated();
                    NumberField.this.initializePatternVerifiersForDecimalFormat((DecimalFormat)this.get());
                    NumberField.this.setStringConverter(null);
                }
            };
        }
        return this._decimalFormatProperty;
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.decimalFormatProperty().get();
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.decimalFormatProperty().set((Object)format);
    }

    public BooleanProperty positiveOnlyProperty() {
        if (this._positiveOnlyProperty == null) {
            this._positiveOnlyProperty = new SimpleBooleanProperty(this, "positiveOnly"){

                protected void invalidated() {
                    super.invalidated();
                    NumberField.this.initializePatternVerifiersForDecimalFormat(NumberField.this.getDecimalFormat());
                }
            };
        }
        return this._positiveOnlyProperty;
    }

    public boolean isPositiveOnly() {
        return this.positiveOnlyProperty().get();
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.positiveOnlyProperty().set(positiveOnly);
    }

    @Override
    protected String toString(Number value) {
        DecimalFormat format = this.getDecimalFormat();
        if (format != null) {
            try {
                return format.format(value);
            }
            catch (Exception e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return super.toString(value);
    }

    @Override
    protected Number fromString(String text) {
        DecimalFormat format = this.getDecimalFormat();
        if (format != null) {
            try {
                return format.parse(text);
            }
            catch (ParseException e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return (Number)super.fromString(text);
    }

    @Override
    protected boolean supportFromString() {
        return this.getDecimalFormat() != null || super.supportFromString();
    }

    protected void initializePatternVerifiersForDecimalFormat(final DecimalFormat decimalFormat) {
        int multiplier = decimalFormat.getMultiplier();
        String text = decimalFormat.format((this.getValue() != null && ((Number)this.getValue()).doubleValue() < 0.0 ? -1.2 : 1.2) / (double)multiplier);
        text = text.replace("0", "").replace('2', 'f').replace('1', 'n');
        int integerDigits = decimalFormat.getMaximumIntegerDigits();
        if (integerDigits >= 1) {
            IntegerDigitsPatternVerifier<Number> patternVerifier = new IntegerDigitsPatternVerifier<Number>(this.isPositiveOnly() ? 0 : -((int)Math.pow(10.0, integerDigits)) + 1, (int)Math.pow(10.0, integerDigits) - 1, 1.0, (double)multiplier){

                @Override
                public Number toTargetValue(Number fieldValue) {
                    return fieldValue;
                }

                @Override
                public Number fromTargetValue(Number previousFieldValue, Number targetValue) {
                    return targetValue;
                }
            };
            patternVerifier.setStringConverter(new StringConverter<Number>(){

                private NumberFormat getIntegerFormat(NumberFormat format) {
                    NumberFormat instance = NumberFormat.getInstance();
                    instance.setMaximumIntegerDigits(format.getMaximumIntegerDigits());
                    instance.setMinimumIntegerDigits(format.getMinimumIntegerDigits());
                    instance.setMaximumFractionDigits(0);
                    instance.setGroupingUsed(format.isGroupingUsed());
                    instance.setParseIntegerOnly(true);
                    return instance;
                }

                public String toString(Number object) {
                    return this.getIntegerFormat(decimalFormat).format(object);
                }

                public Number fromString(String string) {
                    try {
                        return this.getIntegerFormat(decimalFormat).parse(string);
                    }
                    catch (ParseException e) {
                        CommonUtils.ignoreException((Exception)e);
                        return Integer.parseInt(string);
                    }
                }
            });
            this.getPatternVerifiers().put((Object)"n", (Object)patternVerifier);
        }
        if (decimalFormat.getMaximumFractionDigits() >= 1) {
            this.getPatternVerifiers().put((Object)"f", (Object)new FractionDigitsPatternVerifier<Number>(decimalFormat.getMaximumFractionDigits(), (double)multiplier){

                @Override
                public Number toTargetValue(Number fieldValue) {
                    return fieldValue;
                }

                @Override
                public Number fromTargetValue(Number previousFieldValue, Number targetValue) {
                    return targetValue;
                }
            });
            decimalFormat.setMinimumFractionDigits(decimalFormat.getMaximumFractionDigits());
        }
        this.setPattern(text);
    }

    public static enum NumberType {
        Normal,
        Integer,
        Percent,
        Currency;

    }
}

