/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.shape.Shape;
import javafx.util.Callback;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.LocalDateTimePopupContent;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.verifier.PatternVerifierUtils;
import jidefx.utils.CommonUtils;
import jidefx.utils.PredefinedShapes;

public class LocalDateTimeField
extends PopupField<LocalDateTime> {
    private static final String STYLE_CLASS_DEFAULT = "local-date-field";
    private ObjectProperty<DateTimeFormatter> _dateTimeFormatProperty;

    public LocalDateTimeField() {
        this(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance()).toPattern());
    }

    public LocalDateTimeField(String pattern) {
        this(pattern, LocalDateTime.now());
    }

    public LocalDateTimeField(String pattern, LocalDateTime value) {
        this.setPattern(pattern);
        this.setValue(value);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<LocalDateTime, PopupContent<LocalDateTime>>(){

            public PopupContent<LocalDateTime> call(LocalDateTime param) {
                LocalDateTimePopupContent content = new LocalDateTimePopupContent();
                content.setValue(LocalDateTimeField.this.getValue());
                return content;
            }
        });
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.patternProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                LocalDateTimeField.this.setDateTimeFormatter(DateTimeFormatter.ofPattern(LocalDateTimeField.this.getPattern()));
            }
        });
    }

    @Override
    protected void customizePopupContent(PopupContent<LocalDateTime> popupContent) {
        super.customizePopupContent(popupContent);
        popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDateTime>(){

            public void changed(ObservableValue<? extends LocalDateTime> observable, LocalDateTime oldValue, LocalDateTime newValue) {
                LocalDateTimeField.this.hide();
            }
        });
    }

    @Override
    protected boolean supportFromString() {
        return this.getDateTimeFormatter() != null || super.supportFromString();
    }

    @Override
    protected LocalDateTime fromString(String text) {
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        if (dateTimeFormatter != null) {
            try {
                TemporalAccessor parse = dateTimeFormatter.parse(text);
                try {
                    return LocalDateTime.from(parse);
                }
                catch (DateTimeException e) {
                    CommonUtils.ignoreException((Exception)e);
                }
            }
            catch (DateTimeParseException e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return (LocalDateTime)super.fromString(text);
    }

    @Override
    protected String toString(LocalDateTime value) {
        DateTimeFormatter formatter = this.getDateTimeFormatter();
        if (formatter != null) {
            try {
                return formatter.format(value);
            }
            catch (Exception e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return super.toString(value);
    }

    public ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        if (this._dateTimeFormatProperty == null) {
            this._dateTimeFormatProperty = new SimpleObjectProperty<DateTimeFormatter>((Object)this, "dateTimeFormatter"){

                protected void invalidated() {
                    super.invalidated();
                    PatternVerifierUtils.initializePatternVerifiersForDateTimeFormatter(LocalDateTimeField.this.getPatternVerifiers());
                    LocalDateTimeField.this.setStringConverter(null);
                }
            };
        }
        return this._dateTimeFormatProperty;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatterProperty().get();
    }

    public void setDateTimeFormatter(DateTimeFormatter format) {
        this.dateTimeFormatterProperty().set((Object)format);
    }

    @Override
    protected Decorator<Button> createPopupButtonDecorator() {
        return new PredefinedDecorators.AbstractButtonDecoratorSupplier(){

            public Decorator<Button> get() {
                Shape calendarIcon = PredefinedShapes.getInstance().createCalendarIcon(15.0);
                Shape shape = PredefinedShapes.getInstance().createArrowedIcon(calendarIcon);
                return new Decorator((Node)this.createButton((Node)shape), Pos.CENTER_RIGHT, new Point2D(-70.0, 0.0), new Insets(0.0, 100.0, 0.0, 0.0));
            }
        }.get();
    }

    public static LocalDateTimeField createLocalDateTimeField(String dateFormat, LocalDateTime initialValue) {
        LocalDateTimeField field = new LocalDateTimeField(dateFormat);
        field.setValue(initialValue);
        return field;
    }

    public static LocalDateTimeField createLocalDateTimeField(LocalDateTime initialValue) {
        LocalDateTimeField field = new LocalDateTimeField();
        field.setValue(initialValue);
        return field;
    }

    public static LocalDateTimeField createLocalDateTimeField() {
        return new LocalDateTimeField();
    }
}

